/*
 * Decompiled with CFR 0.152.
 */
package jme3test.model.anim;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.LoopMode;
import com.jme3.animation.SkeletonControl;
import com.jme3.app.SimpleApplication;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;

public class TestOgreAnim
extends SimpleApplication
implements AnimEventListener,
ActionListener {
    private AnimChannel channel;
    private AnimControl control;

    public static void main(String[] args) {
        TestOgreAnim app = new TestOgreAnim();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(10.0f);
        this.cam.setLocation(new Vector3f(6.4013605f, 7.488437f, 12.843031f));
        this.cam.setRotation(new Quaternion(-0.060740203f, 0.93925786f, -0.2398315f, -0.2378785f));
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-0.1f, -0.7f, -1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.rootNode.addLight((Light)dl);
        Spatial model = this.assetManager.loadModel("Models/Oto/Oto.mesh.xml");
        model.center();
        this.control = (AnimControl)model.getControl(AnimControl.class);
        this.control.addListener((AnimEventListener)this);
        this.channel = this.control.createChannel();
        for (String anim : this.control.getAnimationNames()) {
            System.out.println(anim);
        }
        this.channel.setAnim("stand");
        SkeletonControl skeletonControl = (SkeletonControl)model.getControl(SkeletonControl.class);
        Box b = new Box(0.25f, 3.0f, 0.25f);
        Geometry item = new Geometry("Item", (Mesh)b);
        item.move(0.0f, 1.5f, 0.0f);
        item.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        Node n = skeletonControl.getAttachmentsNode("hand.right");
        n.attachChild((Spatial)item);
        this.rootNode.attachChild(model);
        this.inputManager.addListener((InputListener)this, new String[]{"Attack"});
        this.inputManager.addMapping("Attack", new Trigger[]{new KeyTrigger(57)});
    }

    public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
        if (animName.equals("Dodge")) {
            channel.setAnim("stand", 0.5f);
            channel.setLoopMode(LoopMode.DontLoop);
            channel.setSpeed(1.0f);
        }
    }

    public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
    }

    public void onAction(String binding, boolean value, float tpf) {
        if (binding.equals("Attack") && value && !this.channel.getAnimationName().equals("Dodge")) {
            this.channel.setAnim("Dodge", 0.5f);
            this.channel.setLoopMode(LoopMode.Cycle);
            this.channel.setSpeed(0.1f);
        }
    }
}

