/*
 * Decompiled with CFR 0.152.
 */
package jme3test.model;

import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;

public class TestOgreLoading
extends SimpleApplication {
    float angle1;
    float angle2;
    PointLight pl;
    PointLight p2;
    Spatial lightMdl;
    Spatial lightMd2;

    public static void main(String[] args) {
        TestOgreLoading app = new TestOgreLoading();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(10.0f);
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-0.1f, -0.7f, 1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.rootNode.addLight((Light)dl);
        this.lightMdl = new Geometry("Light", (Mesh)new Sphere(10, 10, 0.1f));
        this.lightMdl.setMaterial(this.assetManager.loadMaterial("Common/Materials/RedColor.j3m"));
        this.rootNode.attachChild(this.lightMdl);
        this.lightMd2 = new Geometry("Light", (Mesh)new Sphere(10, 10, 0.1f));
        this.lightMd2.setMaterial(this.assetManager.loadMaterial("Common/Materials/WhiteColor.j3m"));
        this.rootNode.attachChild(this.lightMd2);
        this.pl = new PointLight();
        this.pl.setColor(new ColorRGBA(1.0f, 0.9f, 0.9f, 0.0f));
        this.pl.setPosition(new Vector3f(0.0f, 0.0f, 4.0f));
        this.rootNode.addLight((Light)this.pl);
        this.p2 = new PointLight();
        this.p2.setColor(new ColorRGBA(0.9f, 1.0f, 0.9f, 0.0f));
        this.p2.setPosition(new Vector3f(0.0f, 0.0f, 3.0f));
        this.rootNode.addLight((Light)this.p2);
        Spatial elephant = this.assetManager.loadModel("Models/Elephant/Elephant.mesh.xml");
        float scale = 0.05f;
        elephant.scale(scale, scale, scale);
        this.rootNode.attachChild(elephant);
    }

    public void simpleUpdate(float tpf) {
        this.angle1 += tpf * 0.25f;
        this.angle1 %= (float)Math.PI * 2;
        this.angle2 += tpf * 0.5f;
        this.angle2 %= (float)Math.PI * 2;
        this.pl.setPosition(new Vector3f(FastMath.cos((float)this.angle1) * 4.0f, 0.5f, FastMath.sin((float)this.angle1) * 4.0f));
        this.p2.setPosition(new Vector3f(FastMath.cos((float)this.angle2) * 4.0f, 0.5f, FastMath.sin((float)this.angle2) * 4.0f));
        this.lightMdl.setLocalTranslation(this.pl.getPosition());
        this.lightMd2.setLocalTranslation(this.p2.getPosition());
    }
}

