/*
 * Decompiled with CFR 0.152.
 */
package jme3test.material;

import com.jme3.app.SimpleApplication;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.TangentBinormalGenerator;

public class TestUnshadedModel
extends SimpleApplication {
    public static void main(String[] args) {
        TestUnshadedModel app = new TestUnshadedModel();
        app.start();
    }

    public void simpleInitApp() {
        Sphere sphMesh = new Sphere(32, 32, 1.0f);
        sphMesh.setTextureMode(Sphere.TextureMode.Projected);
        sphMesh.updateGeometry(32, 32, 1.0f, false, false);
        TangentBinormalGenerator.generate((Mesh)sphMesh);
        Geometry sphere = new Geometry("Rock Ball", (Mesh)sphMesh);
        Material mat = this.assetManager.loadMaterial("Textures/Terrain/Pond/Pond.j3m");
        mat.setColor("Ambient", ColorRGBA.DarkGray);
        mat.setColor("Diffuse", ColorRGBA.White);
        mat.setBoolean("UseMaterialColors", true);
        sphere.setMaterial(mat);
        this.rootNode.attachChild((Spatial)sphere);
        PointLight pl = new PointLight();
        pl.setColor(ColorRGBA.White);
        pl.setPosition(new Vector3f(4.0f, 0.0f, 0.0f));
        this.rootNode.addLight((Light)pl);
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White);
        this.rootNode.addLight((Light)al);
    }
}

