/*
 * Decompiled with CFR 0.152.
 */
package jme3test.material;

import com.jme3.app.SimpleApplication;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Quad;

public class TestColoredTexture
extends SimpleApplication {
    private float time = 0.0f;
    private ColorRGBA nextColor;
    private ColorRGBA prevColor;
    private Material mat;

    public static void main(String[] args) {
        TestColoredTexture app = new TestColoredTexture();
        app.start();
    }

    public void simpleInitApp() {
        Quad quadMesh = new Quad(512.0f, 512.0f);
        Geometry quad = new Geometry("Quad", (Mesh)quadMesh);
        quad.setQueueBucket(RenderQueue.Bucket.Gui);
        this.mat = new Material(this.assetManager, "Common/MatDefs/Misc/ColoredTextured.j3md");
        this.mat.setTexture("ColorMap", this.assetManager.loadTexture("Textures/ColoredTex/Monkey.png"));
        quad.setMaterial(this.mat);
        this.guiNode.attachChildAt((Spatial)quad, 0);
        this.nextColor = ColorRGBA.randomColor();
        this.prevColor = ColorRGBA.Black;
    }

    public void simpleUpdate(float tpf) {
        this.time += tpf;
        if (this.time > 1.0f) {
            this.time -= 1.0f;
            this.prevColor = this.nextColor;
            this.nextColor = ColorRGBA.randomColor();
        }
        ColorRGBA currentColor = new ColorRGBA();
        currentColor.interpolate(this.prevColor, this.nextColor, this.time);
        this.mat.setColor("Color", currentColor);
    }
}

