/*
 * Decompiled with CFR 0.152.
 */
package jme3test.light;

import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.light.PointLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.BufferUtils;
import com.jme3.util.TangentBinormalGenerator;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class TestTangentGen
extends SimpleApplication {
    float angle;
    PointLight pl;
    Geometry lightMdl;

    public static void main(String[] args) {
        TestTangentGen app = new TestTangentGen();
        app.start();
    }

    public void simpleInitApp() {
        this.flyCam.setMoveSpeed(20.0f);
        Sphere sphereMesh = new Sphere(32, 32, 1.0f);
        sphereMesh.setTextureMode(Sphere.TextureMode.Projected);
        sphereMesh.updateGeometry(32, 32, 1.0f, false, false);
        this.addMesh("Sphere", (Mesh)sphereMesh, new Vector3f(-1.0f, 0.0f, 0.0f));
        Quad quadMesh = new Quad(1.0f, 1.0f);
        quadMesh.updateGeometry(1.0f, 1.0f);
        this.addMesh("Quad", (Mesh)quadMesh, new Vector3f(1.0f, 0.0f, 0.0f));
        Mesh strip = this.createTriangleStripMesh();
        this.addMesh("strip", strip, new Vector3f(0.0f, -3.0f, 0.0f));
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(1.0f, -1.0f, -1.0f).normalizeLocal());
        dl.setColor(ColorRGBA.White);
        this.rootNode.addLight((Light)dl);
    }

    private void addMesh(String name, Mesh mesh, Vector3f translation) {
        TangentBinormalGenerator.generate((Mesh)mesh);
        Geometry testGeom = new Geometry(name, mesh);
        Material mat = this.assetManager.loadMaterial("Textures/BumpMapTest/Tangent.j3m");
        testGeom.setMaterial(mat);
        testGeom.getLocalTranslation().set(translation);
        this.rootNode.attachChild((Spatial)testGeom);
        Geometry debug = new Geometry("Debug " + name, TangentBinormalGenerator.genTbnLines((Mesh)mesh, (float)0.08f));
        Material debugMat = this.assetManager.loadMaterial("Common/Materials/VertexColor.j3m");
        debug.setMaterial(debugMat);
        debug.setCullHint(Spatial.CullHint.Never);
        debug.getLocalTranslation().set(translation);
        this.rootNode.attachChild((Spatial)debug);
    }

    public void simpleUpdate(float tpf) {
    }

    private Mesh createTriangleStripMesh() {
        Mesh strip = new Mesh();
        strip.setMode(Mesh.Mode.TriangleStrip);
        FloatBuffer vb = BufferUtils.createFloatBuffer((int)27);
        vb.rewind();
        vb.put(new float[]{0.0f, 2.0f, 0.0f});
        vb.put(new float[]{1.0f, 2.0f, 0.0f});
        vb.put(new float[]{2.0f, 2.0f, 0.0f});
        vb.put(new float[]{0.0f, 1.0f, 0.0f});
        vb.put(new float[]{1.0f, 1.0f, 0.0f});
        vb.put(new float[]{2.0f, 1.0f, 0.0f});
        vb.put(new float[]{0.0f, 0.0f, 0.0f});
        vb.put(new float[]{1.0f, 0.0f, 0.0f});
        vb.put(new float[]{2.0f, 0.0f, 0.0f});
        FloatBuffer nb = BufferUtils.createFloatBuffer((int)27);
        nb.rewind();
        nb.put(new float[]{0.0f, 0.0f, 1.0f});
        nb.put(new float[]{0.0f, 0.0f, 1.0f});
        nb.put(new float[]{0.0f, 0.0f, 1.0f});
        nb.put(new float[]{0.0f, 0.0f, 1.0f});
        nb.put(new float[]{0.0f, 0.0f, 1.0f});
        nb.put(new float[]{0.0f, 0.0f, 1.0f});
        nb.put(new float[]{0.0f, 0.0f, 1.0f});
        nb.put(new float[]{0.0f, 0.0f, 1.0f});
        nb.put(new float[]{0.0f, 0.0f, 1.0f});
        FloatBuffer tb = BufferUtils.createFloatBuffer((int)18);
        tb.rewind();
        tb.put(new float[]{0.0f, 0.0f});
        tb.put(new float[]{0.5f, 0.0f});
        tb.put(new float[]{1.0f, 0.0f});
        tb.put(new float[]{0.0f, 0.5f});
        tb.put(new float[]{0.5f, 0.5f});
        tb.put(new float[]{1.0f, 0.5f});
        tb.put(new float[]{0.0f, 1.0f});
        tb.put(new float[]{0.5f, 1.0f});
        tb.put(new float[]{1.0f, 1.0f});
        int[] indexes = new int[]{0, 3, 1, 4, 2, 5, 5, 3, 3, 6, 4, 7, 5, 8};
        IntBuffer ib = BufferUtils.createIntBuffer((int)indexes.length);
        ib.put(indexes);
        strip.setBuffer(VertexBuffer.Type.Position, 3, vb);
        strip.setBuffer(VertexBuffer.Type.Normal, 3, nb);
        strip.setBuffer(VertexBuffer.Type.TexCoord, 2, tb);
        strip.setBuffer(VertexBuffer.Type.Index, 3, ib);
        strip.updateBound();
        return strip;
    }
}

