/*
 * Decompiled with CFR 0.152.
 */
package jme3test.input.combomoves;

import com.jme3.app.SimpleApplication;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.HashSet;
import jme3test.input.combomoves.ComboMove;
import jme3test.input.combomoves.ComboMoveExecution;

public class TestComboMoves
extends SimpleApplication
implements ActionListener {
    private HashSet<String> pressedMappings = new HashSet();
    private ComboMove fireball;
    private ComboMoveExecution fireballExec;
    private BitmapText fireballText;
    private ComboMove shuriken;
    private ComboMoveExecution shurikenExec;
    private BitmapText shurikenText;
    private ComboMove jab;
    private ComboMoveExecution jabExec;
    private BitmapText jabText;
    private ComboMove punch;
    private ComboMoveExecution punchExec;
    private BitmapText punchText;
    private ComboMove currentMove = null;
    private float currentMoveCastTime = 0.0f;
    private float time = 0.0f;

    public static void main(String[] args) {
        TestComboMoves app = new TestComboMoves();
        app.start();
    }

    public void simpleInitApp() {
        this.fpsText.setCullHint(Spatial.CullHint.Always);
        this.statsView.setCullHint(Spatial.CullHint.Always);
        BitmapText helpText = new BitmapText(this.guiFont);
        helpText.setLocalTranslation(0.0f, (float)this.settings.getHeight(), 0.0f);
        helpText.setText("Moves:\nFireball: Down, Down+Right, Right\nShuriken: Left, Down, Attack1(Z)\nJab: Attack1(Z)\nPunch: Attack1(Z), Attack1(Z)\n");
        this.guiNode.attachChild((Spatial)helpText);
        this.fireballText = new BitmapText(this.guiFont);
        this.fireballText.setColor(ColorRGBA.Orange);
        this.fireballText.setLocalTranslation(0.0f, this.fireballText.getLineHeight(), 0.0f);
        this.guiNode.attachChild((Spatial)this.fireballText);
        this.shurikenText = new BitmapText(this.guiFont);
        this.shurikenText.setColor(ColorRGBA.Cyan);
        this.shurikenText.setLocalTranslation(0.0f, this.shurikenText.getLineHeight() * 2.0f, 0.0f);
        this.guiNode.attachChild((Spatial)this.shurikenText);
        this.jabText = new BitmapText(this.guiFont);
        this.jabText.setColor(ColorRGBA.Red);
        this.jabText.setLocalTranslation(0.0f, this.jabText.getLineHeight() * 3.0f, 0.0f);
        this.guiNode.attachChild((Spatial)this.jabText);
        this.punchText = new BitmapText(this.guiFont);
        this.punchText.setColor(ColorRGBA.Green);
        this.punchText.setLocalTranslation(0.0f, this.punchText.getLineHeight() * 4.0f, 0.0f);
        this.guiNode.attachChild((Spatial)this.punchText);
        this.inputManager.addMapping("Left", new Trigger[]{new KeyTrigger(203)});
        this.inputManager.addMapping("Right", new Trigger[]{new KeyTrigger(205)});
        this.inputManager.addMapping("Up", new Trigger[]{new KeyTrigger(200)});
        this.inputManager.addMapping("Down", new Trigger[]{new KeyTrigger(208)});
        this.inputManager.addMapping("Attack1", new Trigger[]{new KeyTrigger(44)});
        this.inputManager.addListener((InputListener)this, new String[]{"Left", "Right", "Up", "Down", "Attack1"});
        this.fireball = new ComboMove("Fireball");
        this.fireball.press("Down").notPress("Right").done();
        this.fireball.press("Right", "Down").done();
        this.fireball.press("Right").notPress("Down").done();
        this.fireball.notPress("Right", "Down").done();
        this.fireball.setUseFinalState(false);
        this.shuriken = new ComboMove("Shuriken");
        this.shuriken.press("Left").notPress("Down", "Attack1").done();
        this.shuriken.press("Down").notPress("Attack1").timeElapsed(0.11f).done();
        this.shuriken.press("Attack1").notPress("Left").timeElapsed(0.11f).done();
        this.shuriken.notPress("Left", "Down", "Attack1").done();
        this.jab = new ComboMove("Jab");
        this.jab.setPriority(0.5f);
        this.jab.press("Attack1").done();
        this.punch = new ComboMove("Punch");
        this.punch.press("Attack1").done();
        this.punch.notPress("Attack1").done();
        this.punch.press("Attack1").done();
        this.fireballExec = new ComboMoveExecution(this.fireball);
        this.shurikenExec = new ComboMoveExecution(this.shuriken);
        this.jabExec = new ComboMoveExecution(this.jab);
        this.punchExec = new ComboMoveExecution(this.punch);
    }

    public void simpleUpdate(float tpf) {
        this.time += tpf;
        this.secondCounter = 0.0f;
        this.shurikenExec.updateExpiration(this.time);
        this.shurikenText.setText("Shuriken Exec: " + this.shurikenExec.getDebugString());
        this.fireballExec.updateExpiration(this.time);
        this.fireballText.setText("Fireball Exec: " + this.fireballExec.getDebugString());
        this.jabExec.updateExpiration(this.time);
        this.jabText.setText("Jab Exec: " + this.jabExec.getDebugString());
        this.punchExec.updateExpiration(this.time);
        this.punchText.setText("Punch Exec: " + this.punchExec.getDebugString());
        if (this.currentMove != null) {
            this.currentMoveCastTime -= tpf;
            if (this.currentMoveCastTime <= 0.0f) {
                System.out.println("DONE CASTING " + this.currentMove.getMoveName());
                this.currentMoveCastTime = 0.0f;
                this.currentMove = null;
            }
        }
    }

    public void onAction(String name, boolean isPressed, float tpf) {
        if (isPressed) {
            this.pressedMappings.add(name);
        } else {
            this.pressedMappings.remove(name);
        }
        ArrayList<ComboMove> invokedMoves = new ArrayList<ComboMove>();
        if (this.shurikenExec.updateState(this.pressedMappings, this.time)) {
            invokedMoves.add(this.shuriken);
        }
        if (this.fireballExec.updateState(this.pressedMappings, this.time)) {
            invokedMoves.add(this.fireball);
        }
        if (this.jabExec.updateState(this.pressedMappings, this.time)) {
            invokedMoves.add(this.jab);
        }
        if (this.punchExec.updateState(this.pressedMappings, this.time)) {
            invokedMoves.add(this.punch);
        }
        if (invokedMoves.size() > 0) {
            float priority = 0.0f;
            ComboMove toExec = null;
            for (ComboMove move : invokedMoves) {
                if (!(move.getPriority() > priority)) continue;
                priority = move.getPriority();
                toExec = move;
            }
            if (this.currentMove != null && this.currentMove.getPriority() > toExec.getPriority()) {
                return;
            }
            this.currentMove = toExec;
            this.currentMoveCastTime = this.currentMove.getCastTime();
        }
    }
}

