/*
 * Decompiled with CFR 0.152.
 */
package jme3test.input;

import com.jme3.app.SimpleApplication;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseAxisTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.CameraControl;
import com.jme3.scene.shape.Quad;
import com.jme3.system.AppSettings;

public class TestCameraNode
extends SimpleApplication
implements AnalogListener,
ActionListener {
    private Geometry teaGeom;
    private Node teaNode;
    CameraNode camNode;
    boolean rotate = false;
    Vector3f direction = new Vector3f();

    public static void main(String[] args) {
        TestCameraNode app = new TestCameraNode();
        AppSettings s = new AppSettings(true);
        s.setFrameRate(100);
        app.setSettings(s);
        app.start();
    }

    public void simpleInitApp() {
        this.teaGeom = (Geometry)this.assetManager.loadModel("Models/Teapot/Teapot.obj");
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/ShowNormals.j3md");
        this.teaGeom.setMaterial(mat);
        this.teaNode = new Node("teaNode");
        this.teaNode.attachChild((Spatial)this.teaGeom);
        this.rootNode.attachChild((Spatial)this.teaNode);
        mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setTexture("ColorMap", this.assetManager.loadTexture("Interface/Logo/Monkey.jpg"));
        Geometry ground = new Geometry("ground", (Mesh)new Quad(50.0f, 50.0f));
        ground.setLocalRotation(new Quaternion().fromAngleAxis(-1.5707964f, Vector3f.UNIT_X));
        ground.setLocalTranslation(-25.0f, -1.0f, 25.0f);
        ground.setMaterial(mat);
        this.rootNode.attachChild((Spatial)ground);
        this.camNode = new CameraNode("CamNode", this.cam);
        this.camNode.setControlDir(CameraControl.ControlDirection.SpatialToCamera);
        this.teaNode.attachChild((Spatial)this.camNode);
        this.camNode.setLocalTranslation(new Vector3f(-10.0f, 0.0f, 0.0f));
        this.camNode.lookAt(this.teaNode.getLocalTranslation(), Vector3f.UNIT_Y);
        this.flyCam.setEnabled(false);
        this.registerInput();
    }

    public void registerInput() {
        Trigger[] triggerArray = new Trigger[2];
        triggerArray[0] = new KeyTrigger(200);
        triggerArray[1] = new KeyTrigger(17);
        this.inputManager.addMapping("moveForward", triggerArray);
        Trigger[] triggerArray2 = new Trigger[2];
        triggerArray2[0] = new KeyTrigger(208);
        triggerArray2[1] = new KeyTrigger(31);
        this.inputManager.addMapping("moveBackward", triggerArray2);
        Trigger[] triggerArray3 = new Trigger[2];
        triggerArray3[0] = new KeyTrigger(205);
        triggerArray3[1] = new KeyTrigger(32);
        this.inputManager.addMapping("moveRight", triggerArray3);
        Trigger[] triggerArray4 = new Trigger[2];
        triggerArray4[0] = new KeyTrigger(203);
        triggerArray4[1] = new KeyTrigger(30);
        this.inputManager.addMapping("moveLeft", triggerArray4);
        this.inputManager.addMapping("toggleRotate", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addMapping("rotateRight", new Trigger[]{new MouseAxisTrigger(0, true)});
        this.inputManager.addMapping("rotateLeft", new Trigger[]{new MouseAxisTrigger(0, false)});
        this.inputManager.addListener((InputListener)this, new String[]{"moveForward", "moveBackward", "moveRight", "moveLeft"});
        this.inputManager.addListener((InputListener)this, new String[]{"rotateRight", "rotateLeft", "toggleRotate"});
    }

    public void onAnalog(String name, float value, float tpf) {
        this.direction.set(this.cam.getDirection()).normalizeLocal();
        if (name.equals("moveForward")) {
            this.direction.multLocal(5.0f * tpf);
            this.teaNode.move(this.direction);
        }
        if (name.equals("moveBackward")) {
            this.direction.multLocal(-5.0f * tpf);
            this.teaNode.move(this.direction);
        }
        if (name.equals("moveRight")) {
            this.direction.crossLocal(Vector3f.UNIT_Y).multLocal(5.0f * tpf);
            this.teaNode.move(this.direction);
        }
        if (name.equals("moveLeft")) {
            this.direction.crossLocal(Vector3f.UNIT_Y).multLocal(-5.0f * tpf);
            this.teaNode.move(this.direction);
        }
        if (name.equals("rotateRight") && this.rotate) {
            this.teaNode.rotate(0.0f, 5.0f * tpf, 0.0f);
        }
        if (name.equals("rotateLeft") && this.rotate) {
            this.teaNode.rotate(0.0f, -5.0f * tpf, 0.0f);
        }
    }

    public void onAction(String name, boolean keyPressed, float tpf) {
        if (name.equals("toggleRotate") && keyPressed) {
            this.rotate = true;
            this.inputManager.setCursorVisible(false);
        }
        if (name.equals("toggleRotate") && !keyPressed) {
            this.rotate = false;
            this.inputManager.setCursorVisible(true);
        }
    }
}

