/*
 * Decompiled with CFR 0.152.
 */
package jme3test.helloworld;

import com.jme3.app.SimpleApplication;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;

public class HelloPicking
extends SimpleApplication {
    Node shootables;
    Geometry mark;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("Shoot") && !keyPressed) {
                CollisionResults results = new CollisionResults();
                Ray ray = new Ray(HelloPicking.this.cam.getLocation(), HelloPicking.this.cam.getDirection());
                HelloPicking.this.shootables.collideWith((Collidable)ray, results);
                System.out.println("----- Collisions? " + results.size() + "-----");
                for (int i = 0; i < results.size(); ++i) {
                    float dist = results.getCollision(i).getDistance();
                    Vector3f pt = results.getCollision(i).getContactPoint();
                    String hit = results.getCollision(i).getGeometry().getName();
                    System.out.println("* Collision #" + i);
                    System.out.println("  You shot " + hit + " at " + pt + ", " + dist + " wu away.");
                }
                if (results.size() > 0) {
                    CollisionResult closest = results.getClosestCollision();
                    HelloPicking.this.mark.setLocalTranslation(closest.getContactPoint());
                    HelloPicking.this.rootNode.attachChild((Spatial)HelloPicking.this.mark);
                } else {
                    HelloPicking.this.rootNode.detachChild((Spatial)HelloPicking.this.mark);
                }
            }
        }
    };

    public static void main(String[] args) {
        HelloPicking app = new HelloPicking();
        app.start();
    }

    public void simpleInitApp() {
        this.initCrossHairs();
        this.initKeys();
        this.initMark();
        this.shootables = new Node("Shootables");
        this.rootNode.attachChild((Spatial)this.shootables);
        this.shootables.attachChild((Spatial)this.makeCube("a Dragon", -2.0f, 0.0f, 1.0f));
        this.shootables.attachChild((Spatial)this.makeCube("a tin can", 1.0f, -2.0f, 0.0f));
        this.shootables.attachChild((Spatial)this.makeCube("the Sheriff", 0.0f, 1.0f, -2.0f));
        this.shootables.attachChild((Spatial)this.makeCube("the Deputy", 1.0f, 0.0f, -4.0f));
        this.shootables.attachChild((Spatial)this.makeFloor());
        this.shootables.attachChild(this.makeCharacter());
    }

    private void initKeys() {
        this.inputManager.addMapping("Shoot", new Trigger[]{new KeyTrigger(57), new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Shoot"});
    }

    protected Geometry makeCube(String name, float x, float y, float z) {
        Box box = new Box(new Vector3f(x, y, z), 1.0f, 1.0f, 1.0f);
        Geometry cube = new Geometry(name, (Mesh)box);
        Material mat1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat1.setColor("Color", ColorRGBA.randomColor());
        cube.setMaterial(mat1);
        return cube;
    }

    protected Geometry makeFloor() {
        Box box = new Box(new Vector3f(0.0f, -4.0f, -5.0f), 15.0f, 0.2f, 15.0f);
        Geometry floor = new Geometry("the Floor", (Mesh)box);
        Material mat1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat1.setColor("Color", ColorRGBA.Gray);
        floor.setMaterial(mat1);
        return floor;
    }

    protected void initMark() {
        Sphere sphere = new Sphere(30, 30, 0.2f);
        this.mark = new Geometry("BOOM!", (Mesh)sphere);
        Material mark_mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mark_mat.setColor("Color", ColorRGBA.Red);
        this.mark.setMaterial(mark_mat);
    }

    protected void initCrossHairs() {
        this.guiNode.detachAllChildren();
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        BitmapText ch = new BitmapText(this.guiFont, false);
        ch.setSize((float)(this.guiFont.getCharSet().getRenderedSize() * 2));
        ch.setText("+");
        ch.setLocalTranslation((float)(this.settings.getWidth() / 2 - this.guiFont.getCharSet().getRenderedSize() / 3 * 2), (float)(this.settings.getHeight() / 2) + ch.getLineHeight() / 2.0f, 0.0f);
        this.guiNode.attachChild((Spatial)ch);
    }

    protected Spatial makeCharacter() {
        Spatial golem = this.assetManager.loadModel("Models/Oto/Oto.mesh.xml");
        golem.scale(0.5f);
        golem.setLocalTranslation(-1.0f, -1.5f, -0.6f);
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(new Vector3f(-0.1f, -0.7f, -1.0f));
        golem.addLight((Light)sun);
        return golem;
    }
}

