/*
 * Decompiled with CFR 0.152.
 */
package jme3test.helloworld;

import com.jme3.app.SimpleApplication;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.Texture;
import com.jme3.util.TangentBinormalGenerator;

public class HelloMaterial
extends SimpleApplication {
    public static void main(String[] args) {
        HelloMaterial app = new HelloMaterial();
        app.start();
    }

    public void simpleInitApp() {
        Box boxshape1 = new Box(new Vector3f(-3.0f, 1.1f, 0.0f), 1.0f, 1.0f, 1.0f);
        Geometry cube = new Geometry("My Textured Box", (Mesh)boxshape1);
        Material mat_stl = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        Texture tex_ml = this.assetManager.loadTexture("Interface/Logo/Monkey.jpg");
        mat_stl.setTexture("ColorMap", tex_ml);
        cube.setMaterial(mat_stl);
        this.rootNode.attachChild((Spatial)cube);
        Box boxshape3 = new Box(new Vector3f(0.0f, 0.0f, 0.0f), 1.0f, 1.0f, 0.01f);
        Geometry window_frame = new Geometry("window frame", (Mesh)boxshape3);
        Material mat_tt = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat_tt.setTexture("ColorMap", this.assetManager.loadTexture("Textures/ColoredTex/Monkey.png"));
        mat_tt.getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        window_frame.setQueueBucket(RenderQueue.Bucket.Transparent);
        window_frame.setMaterial(mat_tt);
        this.rootNode.attachChild((Spatial)window_frame);
        Box boxshape4 = new Box(new Vector3f(3.0f, -1.0f, 0.0f), 1.0f, 1.0f, 1.0f);
        Geometry cube_leak = new Geometry("Leak-through color cube", (Mesh)boxshape4);
        Material mat_tl = new Material(this.assetManager, "Common/MatDefs/Misc/ColoredTextured.j3md");
        mat_tl.setTexture("ColorMap", this.assetManager.loadTexture("Textures/ColoredTex/Monkey.png"));
        mat_tl.setColor("Color", new ColorRGBA(1.0f, 0.0f, 1.0f, 1.0f));
        cube_leak.setMaterial(mat_tl);
        this.rootNode.attachChild((Spatial)cube_leak);
        Sphere rock = new Sphere(32, 32, 2.0f);
        Geometry shiny_rock = new Geometry("Shiny rock", (Mesh)rock);
        rock.setTextureMode(Sphere.TextureMode.Projected);
        TangentBinormalGenerator.generate((Mesh)rock);
        Material mat_lit = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat_lit.setTexture("DiffuseMap", this.assetManager.loadTexture("Textures/Terrain/Pond/Pond.jpg"));
        mat_lit.setTexture("NormalMap", this.assetManager.loadTexture("Textures/Terrain/Pond/Pond_normal.png"));
        mat_lit.setFloat("Shininess", 5.0f);
        shiny_rock.setMaterial(mat_lit);
        shiny_rock.setLocalTranslation(0.0f, 2.0f, -2.0f);
        shiny_rock.rotate(1.6f, 0.0f, 0.0f);
        this.rootNode.attachChild((Spatial)shiny_rock);
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(new Vector3f(1.0f, 0.0f, -2.0f).normalizeLocal());
        sun.setColor(ColorRGBA.White);
        this.rootNode.addLight((Light)sun);
    }
}

