/*
 * Decompiled with CFR 0.152.
 */
package jme3test.helloworld;

import com.jme3.app.SimpleApplication;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;

public class HelloInput
extends SimpleApplication {
    protected Geometry player;
    Boolean isRunning = true;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("Pause") && !keyPressed) {
                HelloInput.this.isRunning = HelloInput.this.isRunning == false;
            }
        }
    };
    private AnalogListener analogListener = new AnalogListener(){

        public void onAnalog(String name, float value, float tpf) {
            if (HelloInput.this.isRunning.booleanValue()) {
                if (name.equals("Rotate")) {
                    HelloInput.this.player.rotate(0.0f, value, 0.0f);
                }
                if (name.equals("Right")) {
                    HelloInput.this.player.move(new Vector3f(value, 0.0f, 0.0f));
                }
                if (name.equals("Left")) {
                    HelloInput.this.player.move(new Vector3f(-value, 0.0f, 0.0f));
                }
            } else {
                System.out.println("Press P to unpause.");
            }
        }
    };

    public static void main(String[] args) {
        HelloInput app = new HelloInput();
        app.start();
    }

    public void simpleInitApp() {
        Box b = new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f);
        this.player = new Geometry("Player", (Mesh)b);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Blue);
        this.player.setMaterial(mat);
        this.rootNode.attachChild((Spatial)this.player);
        this.initKeys();
    }

    private void initKeys() {
        Trigger[] triggerArray = new Trigger[1];
        triggerArray[0] = new KeyTrigger(25);
        this.inputManager.addMapping("Pause", triggerArray);
        this.inputManager.addMapping("Left", new Trigger[]{new KeyTrigger(36)});
        this.inputManager.addMapping("Right", new Trigger[]{new KeyTrigger(37)});
        this.inputManager.addMapping("Rotate", new Trigger[]{new KeyTrigger(57), new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"Pause"});
        this.inputManager.addListener((InputListener)this.analogListener, new String[]{"Left", "Right", "Rotate"});
    }
}

