/*
 * Decompiled with CFR 0.152.
 */
package jme3test.helloworld;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.collision.shapes.CapsuleCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.control.CharacterControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.util.CollisionShapeFactory;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.AmbientLight;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;

public class HelloCollision
extends SimpleApplication
implements ActionListener {
    private Spatial sceneModel;
    private BulletAppState bulletAppState;
    private RigidBodyControl landscape;
    private CharacterControl player;
    private Vector3f walkDirection = new Vector3f();
    private boolean left = false;
    private boolean right = false;
    private boolean up = false;
    private boolean down = false;

    public static void main(String[] args) {
        HelloCollision app = new HelloCollision();
        app.start();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        this.viewPort.setBackgroundColor(new ColorRGBA(0.7f, 0.8f, 1.0f, 1.0f));
        this.flyCam.setMoveSpeed(100.0f);
        this.setUpKeys();
        this.setUpLight();
        this.assetManager.registerLocator("town.zip", ZipLocator.class.getName());
        this.sceneModel = this.assetManager.loadModel("main.scene");
        this.sceneModel.setLocalScale(2.0f);
        CollisionShape sceneShape = CollisionShapeFactory.createMeshShape((Spatial)((Node)this.sceneModel));
        this.landscape = new RigidBodyControl(sceneShape, 0.0f);
        this.sceneModel.addControl((Control)this.landscape);
        CapsuleCollisionShape capsuleShape = new CapsuleCollisionShape(1.5f, 6.0f, 1);
        this.player = new CharacterControl((CollisionShape)capsuleShape, 0.05f);
        this.player.setJumpSpeed(20.0f);
        this.player.setFallSpeed(30.0f);
        this.player.setGravity(30.0f);
        this.player.setPhysicsLocation(new Vector3f(0.0f, 10.0f, 0.0f));
        this.rootNode.attachChild(this.sceneModel);
        this.bulletAppState.getPhysicsSpace().add((Object)this.landscape);
        this.bulletAppState.getPhysicsSpace().add((Object)this.player);
    }

    private void setUpLight() {
        AmbientLight al = new AmbientLight();
        al.setColor(ColorRGBA.White.mult(1.3f));
        this.rootNode.addLight((Light)al);
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.White);
        dl.setDirection(new Vector3f(2.8f, -2.8f, -2.8f).normalizeLocal());
        this.rootNode.addLight((Light)dl);
    }

    private void setUpKeys() {
        this.inputManager.addMapping("Lefts", new Trigger[]{new KeyTrigger(30)});
        this.inputManager.addMapping("Rights", new Trigger[]{new KeyTrigger(32)});
        this.inputManager.addMapping("Ups", new Trigger[]{new KeyTrigger(17)});
        this.inputManager.addMapping("Downs", new Trigger[]{new KeyTrigger(31)});
        this.inputManager.addMapping("Jumps", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addListener((InputListener)this, new String[]{"Lefts"});
        this.inputManager.addListener((InputListener)this, new String[]{"Rights"});
        this.inputManager.addListener((InputListener)this, new String[]{"Ups"});
        this.inputManager.addListener((InputListener)this, new String[]{"Downs"});
        this.inputManager.addListener((InputListener)this, new String[]{"Jumps"});
    }

    public void onAction(String binding, boolean value, float tpf) {
        if (binding.equals("Lefts")) {
            this.left = value;
        } else if (binding.equals("Rights")) {
            this.right = value;
        } else if (binding.equals("Ups")) {
            this.up = value;
        } else if (binding.equals("Downs")) {
            this.down = value;
        } else if (binding.equals("Jumps")) {
            this.player.jump();
        }
    }

    public void simpleUpdate(float tpf) {
        Vector3f camDir = this.cam.getDirection().clone().multLocal(0.6f);
        Vector3f camLeft = this.cam.getLeft().clone().multLocal(0.4f);
        this.walkDirection.set(0.0f, 0.0f, 0.0f);
        if (this.left) {
            this.walkDirection.addLocal(camLeft);
        }
        if (this.right) {
            this.walkDirection.addLocal(camLeft.negate());
        }
        if (this.up) {
            this.walkDirection.addLocal(camDir);
        }
        if (this.down) {
            this.walkDirection.addLocal(camDir.negate());
        }
        this.player.setWalkDirection(this.walkDirection);
        this.cam.setLocation(this.player.getPhysicsLocation());
    }
}

