/*
 * Decompiled with CFR 0.152.
 */
package jme3test.export;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.app.SimpleApplication;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TestOgreConvert
extends SimpleApplication {
    public static void main(String[] args) {
        TestOgreConvert app = new TestOgreConvert();
        app.start();
    }

    public void simpleInitApp() {
        Spatial ogreModel = this.assetManager.loadModel("Models/Oto/Oto.mesh.xml");
        DirectionalLight dl = new DirectionalLight();
        dl.setColor(ColorRGBA.White);
        dl.setDirection(new Vector3f(0.0f, -1.0f, -1.0f).normalizeLocal());
        this.rootNode.addLight((Light)dl);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BinaryExporter exp = new BinaryExporter();
            exp.save((Savable)ogreModel, (OutputStream)baos);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            BinaryImporter imp = new BinaryImporter();
            imp.setAssetManager(this.assetManager);
            Node ogreModelReloaded = (Node)imp.load((InputStream)bais, null, null);
            AnimControl control = (AnimControl)ogreModelReloaded.getControl(AnimControl.class);
            AnimChannel chan = control.createChannel();
            chan.setAnim("Walk");
            this.rootNode.attachChild((Spatial)ogreModelReloaded);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

