/*
 * Decompiled with CFR 0.152.
 */
package jme3test.collision;

import com.jme3.app.SimpleApplication;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.material.Material;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import jme3test.collision.RayTrace;

public class TestRayCasting
extends SimpleApplication {
    private RayTrace tracer;
    private Spatial teapot;

    public static void main(String[] args) {
        TestRayCasting app = new TestRayCasting();
        app.setPauseOnLostFocus(false);
        app.start();
    }

    public void simpleInitApp() {
        Material mat = this.assetManager.loadMaterial("Interface/Logo/Logo.j3m");
        Mesh q = new Mesh();
        q.setBuffer(VertexBuffer.Type.Position, 3, new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.5f, 0.0f, -1.0f, 0.0f, 0.0f});
        q.setBuffer(VertexBuffer.Type.Index, 3, new int[]{0, 1, 2});
        q.setBound((BoundingVolume)new BoundingSphere());
        q.updateBound();
        this.teapot = this.assetManager.loadModel("Models/Teapot/Teapot.mesh.xml");
        this.teapot.rotate(1.5707964f, 1.5707964f, 1.5707964f);
        this.teapot.setMaterial(mat);
        this.rootNode.attachChild(this.teapot);
        this.tracer = new RayTrace((Spatial)this.rootNode, this.cam, 160, 128);
        this.tracer.show();
        this.tracer.update();
    }

    public void simpleUpdate(float tpf) {
        this.teapot.rotate(0.0f, tpf, 0.0f);
        this.tracer.update();
    }
}

