/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.animation.AnimChannel;
import com.jme3.animation.AnimControl;
import com.jme3.animation.AnimEventListener;
import com.jme3.animation.LoopMode;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.asset.TextureKey;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.control.KinematicRagdollControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.texture.Texture;
import jme3test.bullet.PhysicsTestHelper;

public class TestRagdollCharacter
extends SimpleApplication
implements AnimEventListener,
ActionListener {
    BulletAppState bulletAppState;
    Node model;
    KinematicRagdollControl ragdoll;
    boolean leftStrafe = false;
    boolean rightStrafe = false;
    boolean forward = false;
    boolean backward = false;
    boolean leftRotate = false;
    boolean rightRotate = false;
    AnimControl animControl;
    AnimChannel animChannel;

    public static void main(String[] args) {
        TestRagdollCharacter app = new TestRagdollCharacter();
        app.start();
    }

    public void simpleInitApp() {
        this.setupKeys();
        this.bulletAppState = new BulletAppState();
        this.bulletAppState.setEnabled(true);
        this.stateManager.attach((AppState)this.bulletAppState);
        PhysicsTestHelper.createPhysicsTestWorld(this.rootNode, this.assetManager, this.bulletAppState.getPhysicsSpace());
        this.initWall(2.0f, 1.0f, 1.0f);
        this.setupLight();
        this.cam.setLocation(new Vector3f(-8.0f, 0.0f, -4.0f));
        this.cam.lookAt(new Vector3f(4.0f, 0.0f, -7.0f), Vector3f.UNIT_Y);
        this.model = (Node)this.assetManager.loadModel("Models/Sinbad/Sinbad.mesh.xml");
        this.model.lookAt(new Vector3f(0.0f, 0.0f, -1.0f), Vector3f.UNIT_Y);
        this.model.setLocalTranslation(4.0f, 0.0f, -7.0f);
        this.ragdoll = new KinematicRagdollControl(0.5f);
        this.model.addControl((Control)this.ragdoll);
        this.getPhysicsSpace().add((Object)this.ragdoll);
        this.speed = 1.3f;
        this.rootNode.attachChild((Spatial)this.model);
        AnimControl control = (AnimControl)this.model.getControl(AnimControl.class);
        this.animChannel = control.createChannel();
        this.animChannel.setAnim("IdleTop");
        control.addListener((AnimEventListener)this);
    }

    private void setupLight() {
        DirectionalLight dl = new DirectionalLight();
        dl.setDirection(new Vector3f(-0.1f, -0.7f, -1.0f).normalizeLocal());
        dl.setColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.rootNode.addLight((Light)dl);
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    private void setupKeys() {
        this.inputManager.addMapping("Rotate Left", new Trigger[]{new KeyTrigger(35)});
        this.inputManager.addMapping("Rotate Right", new Trigger[]{new KeyTrigger(37)});
        this.inputManager.addMapping("Walk Forward", new Trigger[]{new KeyTrigger(22)});
        this.inputManager.addMapping("Walk Backward", new Trigger[]{new KeyTrigger(36)});
        this.inputManager.addMapping("Slice", new Trigger[]{new KeyTrigger(57), new KeyTrigger(28)});
        this.inputManager.addListener((InputListener)this, new String[]{"Strafe Left", "Strafe Right"});
        this.inputManager.addListener((InputListener)this, new String[]{"Rotate Left", "Rotate Right"});
        this.inputManager.addListener((InputListener)this, new String[]{"Walk Forward", "Walk Backward"});
        this.inputManager.addListener((InputListener)this, new String[]{"Slice"});
    }

    public void initWall(float bLength, float bWidth, float bHeight) {
        Box brick = new Box(Vector3f.ZERO, bLength, bHeight, bWidth);
        brick.scaleTextureCoordinates(new Vector2f(1.0f, 0.5f));
        Material mat2 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key = new TextureKey("Textures/Terrain/BrickWall/BrickWall.jpg");
        key.setGenerateMips(true);
        Texture tex = this.assetManager.loadTexture(key);
        mat2.setTexture("ColorMap", tex);
        float startpt = bLength / 4.0f;
        float height = -5.0f;
        for (int j = 0; j < 15; ++j) {
            for (int i = 0; i < 4; ++i) {
                Vector3f ori = new Vector3f((float)i * bLength * 2.0f + startpt, bHeight + height, -10.0f);
                Geometry reBoxg = new Geometry("brick", (Mesh)brick);
                reBoxg.setMaterial(mat2);
                reBoxg.setLocalTranslation(ori);
                reBoxg.addControl((Control)new RigidBodyControl(1.5f));
                reBoxg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                ((RigidBodyControl)reBoxg.getControl(RigidBodyControl.class)).setFriction(0.6f);
                this.rootNode.attachChild((Spatial)reBoxg);
                this.getPhysicsSpace().add((Object)reBoxg);
            }
            startpt = -startpt;
            height += 2.0f * bHeight;
        }
    }

    public void onAnimCycleDone(AnimControl control, AnimChannel channel, String animName) {
        if (channel.getAnimationName().equals("SliceHorizontal")) {
            channel.setLoopMode(LoopMode.DontLoop);
            channel.setAnim("IdleTop", 5.0f);
            channel.setLoopMode(LoopMode.Loop);
        }
    }

    public void onAnimChange(AnimControl control, AnimChannel channel, String animName) {
    }

    public void onAction(String binding, boolean value, float tpf) {
        if (binding.equals("Rotate Left")) {
            this.leftRotate = value;
        } else if (binding.equals("Rotate Right")) {
            this.rightRotate = value;
        } else if (binding.equals("Walk Forward")) {
            this.forward = value;
        } else if (binding.equals("Walk Backward")) {
            this.backward = value;
        } else if (binding.equals("Slice") && value) {
            this.animChannel.setAnim("SliceHorizontal");
            this.animChannel.setSpeed(0.3f);
        }
    }

    public void simpleUpdate(float tpf) {
        if (this.forward) {
            this.model.move(this.model.getLocalRotation().multLocal(new Vector3f(0.0f, 0.0f, 1.0f)).multLocal(tpf));
        } else if (this.backward) {
            this.model.move(this.model.getLocalRotation().multLocal(new Vector3f(0.0f, 0.0f, 1.0f)).multLocal(-tpf));
        } else if (this.leftRotate) {
            this.model.rotate(0.0f, tpf, 0.0f);
        } else if (this.rightRotate) {
            this.model.rotate(0.0f, -tpf, 0.0f);
        }
        this.fpsText.setText(this.cam.getLocation() + "/" + this.cam.getRotation());
    }
}

