/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.MeshCollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;

public class TestCcd
extends SimpleApplication
implements ActionListener {
    private Material mat;
    private Material mat2;
    private Sphere bullet;
    private SphereCollisionShape bulletCollisionShape;
    private BulletAppState bulletAppState;

    public static void main(String[] args) {
        TestCcd app = new TestCcd();
        app.start();
    }

    private void setupKeys() {
        this.inputManager.addMapping("shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addMapping("shoot2", new Trigger[]{new MouseButtonTrigger(1)});
        this.inputManager.addListener((InputListener)this, new String[]{"shoot"});
        this.inputManager.addListener((InputListener)this, new String[]{"shoot2"});
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        this.bulletAppState.getPhysicsSpace().enableDebug(this.assetManager);
        this.bullet = new Sphere(32, 32, 0.4f, true, false);
        this.bullet.setTextureMode(Sphere.TextureMode.Projected);
        this.bulletCollisionShape = new SphereCollisionShape(0.1f);
        this.setupKeys();
        this.mat = new Material(this.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat.getAdditionalRenderState().setWireframe(true);
        this.mat.setColor("Color", ColorRGBA.Green);
        this.mat2 = new Material(this.getAssetManager(), "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat2.getAdditionalRenderState().setWireframe(true);
        this.mat2.setColor("Color", ColorRGBA.Red);
        Node node2 = new Node();
        node2.setName("mesh");
        node2.setLocalTranslation(new Vector3f(2.5f, 0.0f, 0.0f));
        node2.addControl((Control)new RigidBodyControl((CollisionShape)new MeshCollisionShape((Mesh)new Box(Vector3f.ZERO, 4.0f, 4.0f, 0.1f)), 0.0f));
        this.rootNode.attachChild((Spatial)node2);
        this.getPhysicsSpace().add((Object)node2);
        Node node3 = new Node();
        node3.setLocalTranslation(new Vector3f(0.0f, -6.0f, 0.0f));
        node3.addControl((Control)new RigidBodyControl((CollisionShape)new BoxCollisionShape(new Vector3f(100.0f, 1.0f, 100.0f)), 0.0f));
        this.rootNode.attachChild((Spatial)node3);
        this.getPhysicsSpace().add((Object)node3);
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    public void simpleUpdate(float tpf) {
    }

    public void simpleRender(RenderManager rm) {
    }

    public void onAction(String binding, boolean value, float tpf) {
        if (binding.equals("shoot") && !value) {
            Geometry bulletg = new Geometry("bullet", (Mesh)this.bullet);
            bulletg.setMaterial(this.mat);
            bulletg.setName("bullet");
            bulletg.setLocalTranslation(this.cam.getLocation());
            bulletg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
            bulletg.addControl((Control)new RigidBodyControl((CollisionShape)this.bulletCollisionShape, 1.0f));
            ((RigidBodyControl)bulletg.getControl(RigidBodyControl.class)).setCcdMotionThreshold(0.1f);
            ((RigidBodyControl)bulletg.getControl(RigidBodyControl.class)).setLinearVelocity(this.cam.getDirection().mult(40.0f));
            this.rootNode.attachChild((Spatial)bulletg);
            this.getPhysicsSpace().add((Object)bulletg);
        } else if (binding.equals("shoot2") && !value) {
            Geometry bulletg = new Geometry("bullet", (Mesh)this.bullet);
            bulletg.setMaterial(this.mat2);
            bulletg.setName("bullet");
            bulletg.setLocalTranslation(this.cam.getLocation());
            bulletg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
            bulletg.addControl((Control)new RigidBodyControl((CollisionShape)this.bulletCollisionShape, 1.0f));
            ((RigidBodyControl)bulletg.getControl(RigidBodyControl.class)).setLinearVelocity(this.cam.getDirection().mult(40.0f));
            this.rootNode.attachChild((Spatial)bulletg);
            this.getPhysicsSpace().add((Object)bulletg);
        }
    }
}

