/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.asset.TextureKey;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Sphere;
import com.jme3.shadow.PssmShadowRenderer;
import com.jme3.texture.Texture;
import jme3test.bullet.BombControl;

public class TestBrickTower
extends SimpleApplication {
    int bricksPerLayer = 8;
    int brickLayers = 30;
    static float brickWidth = 0.75f;
    static float brickHeight = 0.25f;
    static float brickDepth = 0.25f;
    float radius = 3.0f;
    float angle = 0.0f;
    Material mat;
    Material mat2;
    Material mat3;
    PssmShadowRenderer bsr;
    private Sphere bullet;
    private Box brick;
    private SphereCollisionShape bulletCollisionShape;
    private BulletAppState bulletAppState;
    private ActionListener actionListener = new ActionListener(){

        public void onAction(String name, boolean keyPressed, float tpf) {
            if (name.equals("shoot") && !keyPressed) {
                Geometry bulletg = new Geometry("bullet", (Mesh)TestBrickTower.this.bullet);
                bulletg.setMaterial(TestBrickTower.this.mat2);
                bulletg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                bulletg.setLocalTranslation(TestBrickTower.this.cam.getLocation());
                BombControl bulletNode = new BombControl(TestBrickTower.this.assetManager, (CollisionShape)TestBrickTower.this.bulletCollisionShape, 1.0f);
                bulletNode.setLinearVelocity(TestBrickTower.this.cam.getDirection().mult(25.0f));
                bulletg.addControl((Control)bulletNode);
                TestBrickTower.this.rootNode.attachChild((Spatial)bulletg);
                TestBrickTower.this.getPhysicsSpace().add((Object)bulletNode);
            }
        }
    };

    public static void main(String[] args) {
        TestBrickTower f = new TestBrickTower();
        f.start();
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.bulletAppState.setThreadingType(BulletAppState.ThreadingType.PARALLEL);
        this.stateManager.attach((AppState)this.bulletAppState);
        this.bullet = new Sphere(32, 32, 0.4f, true, false);
        this.bullet.setTextureMode(Sphere.TextureMode.Projected);
        this.bulletCollisionShape = new SphereCollisionShape(0.4f);
        this.brick = new Box(Vector3f.ZERO, brickWidth, brickHeight, brickDepth);
        this.brick.scaleTextureCoordinates(new Vector2f(1.0f, 0.5f));
        this.initMaterial();
        this.initTower();
        this.initFloor();
        this.initCrossHairs();
        this.cam.setLocation(new Vector3f(0.0f, 25.0f, 8.0f));
        this.cam.lookAt(Vector3f.ZERO, new Vector3f(0.0f, 1.0f, 0.0f));
        this.cam.setFrustumFar(80.0f);
        this.inputManager.addMapping("shoot", new Trigger[]{new MouseButtonTrigger(0)});
        this.inputManager.addListener((InputListener)this.actionListener, new String[]{"shoot"});
        this.rootNode.setShadowMode(RenderQueue.ShadowMode.Off);
        this.bsr = new PssmShadowRenderer(this.assetManager, 1024, 2);
        this.bsr.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f).normalizeLocal());
        this.bsr.setLambda(0.55f);
        this.bsr.setShadowIntensity(0.6f);
        this.bsr.setCompareMode(PssmShadowRenderer.CompareMode.Hardware);
        this.bsr.setFilterMode(PssmShadowRenderer.FilterMode.PCF4);
        this.viewPort.addProcessor((SceneProcessor)this.bsr);
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    public void initTower() {
        double tempX = 0.0;
        double tempY = 0.0;
        double tempZ = 0.0;
        this.angle = 0.0f;
        for (int i = 0; i < this.brickLayers; ++i) {
            tempY = i != 0 ? (tempY += (double)(brickHeight * 2.0f)) : (double)brickHeight;
            this.angle = 360.0f / (float)this.bricksPerLayer * (float)i / 2.0f;
            for (int j = 0; j < this.bricksPerLayer; ++j) {
                tempZ = Math.cos(Math.toRadians(this.angle)) * (double)this.radius;
                tempX = Math.sin(Math.toRadians(this.angle)) * (double)this.radius;
                System.out.println("x=" + (float)tempX + " y=" + (float)tempY + " z=" + (float)tempZ);
                Vector3f vt = new Vector3f((float)tempX, (float)tempY, (float)tempZ);
                if (i == this.brickLayers - 1) {
                    if (j % 2 == 0) {
                        this.addBrick(vt);
                    }
                } else {
                    this.addBrick(vt);
                }
                this.angle = (float)((double)this.angle + 360.0 / (double)this.bricksPerLayer);
            }
        }
    }

    public void initFloor() {
        Box floorBox = new Box(Vector3f.ZERO, 10.0f, 0.1f, 5.0f);
        floorBox.scaleTextureCoordinates(new Vector2f(3.0f, 6.0f));
        Geometry floor = new Geometry("floor", (Mesh)floorBox);
        floor.setMaterial(this.mat3);
        floor.setShadowMode(RenderQueue.ShadowMode.Receive);
        floor.setLocalTranslation(0.0f, 0.0f, 0.0f);
        floor.addControl((Control)new RigidBodyControl(0.0f));
        this.rootNode.attachChild((Spatial)floor);
        this.getPhysicsSpace().add((Object)floor);
    }

    public void initMaterial() {
        this.mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key = new TextureKey("Textures/Terrain/BrickWall/BrickWall.jpg");
        key.setGenerateMips(true);
        Texture tex = this.assetManager.loadTexture(key);
        this.mat.setTexture("ColorMap", tex);
        this.mat2 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key2 = new TextureKey("Textures/Terrain/Rock/Rock.PNG");
        key2.setGenerateMips(true);
        Texture tex2 = this.assetManager.loadTexture(key2);
        this.mat2.setTexture("ColorMap", tex2);
        this.mat3 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        TextureKey key3 = new TextureKey("Textures/Terrain/Pond/Pond.jpg");
        key3.setGenerateMips(true);
        Texture tex3 = this.assetManager.loadTexture(key3);
        tex3.setWrap(Texture.WrapMode.Repeat);
        this.mat3.setTexture("ColorMap", tex3);
    }

    public void addBrick(Vector3f ori) {
        Geometry reBoxg = new Geometry("brick", (Mesh)this.brick);
        reBoxg.setMaterial(this.mat);
        reBoxg.setLocalTranslation(ori);
        reBoxg.rotate(0.0f, (float)Math.toRadians(this.angle), 0.0f);
        reBoxg.addControl((Control)new RigidBodyControl(1.5f));
        reBoxg.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        ((RigidBodyControl)reBoxg.getControl(RigidBodyControl.class)).setFriction(1.6f);
        this.rootNode.attachChild((Spatial)reBoxg);
        this.getPhysicsSpace().add((Object)reBoxg);
    }

    protected void initCrossHairs() {
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        BitmapText ch = new BitmapText(this.guiFont, false);
        ch.setSize((float)(this.guiFont.getCharSet().getRenderedSize() * 2));
        ch.setText("+");
        ch.setLocalTranslation((float)(this.settings.getWidth() / 2 - this.guiFont.getCharSet().getRenderedSize() / 3 * 2), (float)(this.settings.getHeight() / 2) + ch.getLineHeight() / 2.0f, 0.0f);
        this.guiNode.attachChild((Spatial)ch);
    }
}

