/*
 * Decompiled with CFR 0.152.
 */
package jme3test.bullet;

import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.PhysicsSpace;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.bullet.collision.shapes.SphereCollisionShape;
import com.jme3.bullet.control.GhostControl;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.bullet.joints.HingeJoint;
import com.jme3.bullet.objects.PhysicsRigidBody;
import com.jme3.input.controls.AnalogListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import jme3test.bullet.PhysicsTestHelper;

public class TestAttachGhostObject
extends SimpleApplication
implements AnalogListener {
    private HingeJoint joint;
    private GhostControl ghostControl;
    private Node collisionNode;
    private Node hammerNode;
    private Vector3f tempVec = new Vector3f();
    private BulletAppState bulletAppState;

    public static void main(String[] args) {
        TestAttachGhostObject app = new TestAttachGhostObject();
        app.start();
    }

    private void setupKeys() {
        this.inputManager.addMapping("Lefts", new Trigger[]{new KeyTrigger(35)});
        this.inputManager.addMapping("Rights", new Trigger[]{new KeyTrigger(37)});
        this.inputManager.addMapping("Space", new Trigger[]{new KeyTrigger(57)});
        this.inputManager.addListener((InputListener)this, new String[]{"Lefts", "Rights", "Space"});
    }

    public void onAnalog(String binding, float value, float tpf) {
        if (binding.equals("Lefts")) {
            this.joint.enableMotor(true, 1.0f, 0.1f);
        } else if (binding.equals("Rights")) {
            this.joint.enableMotor(true, -1.0f, 0.1f);
        } else if (binding.equals("Space")) {
            this.joint.enableMotor(false, 0.0f, 0.0f);
        }
    }

    public void simpleInitApp() {
        this.bulletAppState = new BulletAppState();
        this.stateManager.attach((AppState)this.bulletAppState);
        this.bulletAppState.getPhysicsSpace().enableDebug(this.assetManager);
        this.setupKeys();
        this.setupJoint();
    }

    private PhysicsSpace getPhysicsSpace() {
        return this.bulletAppState.getPhysicsSpace();
    }

    public void setupJoint() {
        Node holderNode = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)new BoxCollisionShape(new Vector3f(0.1f, 0.1f, 0.1f)), 0.0f);
        ((RigidBodyControl)holderNode.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.rootNode.attachChild((Spatial)holderNode);
        this.getPhysicsSpace().add((Object)holderNode);
        Node hammerNode = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)new BoxCollisionShape(new Vector3f(0.3f, 0.3f, 0.3f)), 1.0f);
        ((RigidBodyControl)hammerNode.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(0.0f, -1.0f, 0.0f));
        this.rootNode.attachChild((Spatial)hammerNode);
        this.getPhysicsSpace().add((Object)hammerNode);
        this.collisionNode = PhysicsTestHelper.createPhysicsTestNode(this.assetManager, (CollisionShape)new BoxCollisionShape(new Vector3f(0.3f, 0.3f, 0.3f)), 0.0f);
        ((RigidBodyControl)this.collisionNode.getControl(RigidBodyControl.class)).setPhysicsLocation(new Vector3f(1.8f, 0.0f, 0.0f));
        this.rootNode.attachChild((Spatial)this.collisionNode);
        this.getPhysicsSpace().add((Object)this.collisionNode);
        this.ghostControl = new GhostControl((CollisionShape)new SphereCollisionShape(0.7f));
        hammerNode.addControl((Control)this.ghostControl);
        this.getPhysicsSpace().add((Object)this.ghostControl);
        this.joint = new HingeJoint((PhysicsRigidBody)holderNode.getControl(RigidBodyControl.class), (PhysicsRigidBody)hammerNode.getControl(RigidBodyControl.class), Vector3f.ZERO, new Vector3f(0.0f, -1.0f, 0.0f), Vector3f.UNIT_Z, Vector3f.UNIT_Z);
        this.getPhysicsSpace().add((Object)this.joint);
    }

    public void simpleUpdate(float tpf) {
        if (this.ghostControl.getOverlappingObjects().contains(this.collisionNode.getControl(PhysicsControl.class))) {
            this.fpsText.setText("collide");
        }
    }
}

