/*
 * Decompiled with CFR 0.152.
 */
package jme3test.blender.scene;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Line;
import com.jme3.scene.shape.Sphere;

public class Pivot
extends Node {
    public Pivot(AssetManager assetManager) {
        this.attachChild((Spatial)this.getAxis("x", new Vector3f(10.0f, 0.0f, 0.0f), ColorRGBA.Red, assetManager));
        this.attachChild((Spatial)this.getAxis("y", new Vector3f(0.0f, 10.0f, 0.0f), ColorRGBA.Green, assetManager));
        this.attachChild((Spatial)this.getAxis("z", new Vector3f(0.0f, 0.0f, 10.0f), ColorRGBA.Blue, assetManager));
        this.assignPoints(assetManager);
    }

    private void assignPoints(AssetManager assetManager) {
        Material defaultMaterial = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        defaultMaterial.setColor("Color", ColorRGBA.DarkGray);
        for (int i = -10; i <= 10; ++i) {
            Geometry g = new Geometry("", (Mesh)new Sphere(3, 3, 0.05f));
            g.setLocalTranslation((float)i, 0.0f, 0.0f);
            g.setMaterial(defaultMaterial);
            this.attachChild((Spatial)g);
            g = new Geometry("", (Mesh)new Sphere(3, 3, 0.05f));
            g.setLocalTranslation(0.0f, (float)i, 0.0f);
            g.setMaterial(defaultMaterial);
            this.attachChild((Spatial)g);
            g = new Geometry("", (Mesh)new Sphere(3, 3, 0.05f));
            g.setLocalTranslation(0.0f, 0.0f, (float)i);
            g.setMaterial(defaultMaterial);
            this.attachChild((Spatial)g);
        }
    }

    private Geometry getAxis(String name, Vector3f endPoint, ColorRGBA color, AssetManager assetManager) {
        Line axis = new Line(new Vector3f(0.0f, 0.0f, 0.0f), endPoint);
        Material mat = new Material(assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", color);
        Geometry geom = new Geometry(name, (Mesh)axis);
        geom.setMaterial(mat);
        return geom;
    }
}

