/*
 * Decompiled with CFR 0.152.
 */
package jme3test.blender.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import jme3test.blender.config.AnimationsTable;

public abstract class AbstractConfigDialog
extends JDialog {
    private static final long serialVersionUID = -3677493125861310310L;
    private static final Logger LOGGER = Logger.getLogger(AbstractConfigDialog.class.getName());
    protected JComboBox jComboBoxVersionSelection;
    protected JList jListBlenderFiles;
    protected JTable jTableProperties;
    protected JTable jTableAnimations;
    protected JButton jButtonAddAnimation;
    protected JButton jButtonRemoveAnimation;
    protected JCheckBox jCheckBoxUseModelKey;
    protected JButton jButtonOK;
    protected JButton jButtonCancel;

    public AbstractConfigDialog() {
        super((Frame)null, true);
        this.init();
    }

    private void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InstantiationException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (UnsupportedLookAndFeelException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.setLocationByPlatform(true);
        this.add((Component)this.prepareBlenderFilesAndLogLevelPanel(), "West");
        this.add((Component)this.prepareFilePropertiesPanel(), "Center");
        this.add((Component)this.prepareButtonsPanel(), "South");
        this.pack();
    }

    private JPanel prepareBlenderFilesAndLogLevelPanel() {
        Level[] levels;
        JPanel jPanelBlenderFilesListAndLogLevel = new JPanel();
        jPanelBlenderFilesListAndLogLevel.setBorder(new TitledBorder("Blender test files"));
        jPanelBlenderFilesListAndLogLevel.setLayout(new BorderLayout());
        this.jComboBoxVersionSelection = new JComboBox(new DefaultComboBoxModel());
        this.jComboBoxVersionSelection.setEditable(false);
        jPanelBlenderFilesListAndLogLevel.add((Component)this.jComboBoxVersionSelection, "North");
        this.jListBlenderFiles = new JList(new DefaultListModel());
        this.jListBlenderFiles.setSelectionMode(0);
        JScrollPane listScroller = new JScrollPane(this.jListBlenderFiles);
        jPanelBlenderFilesListAndLogLevel.add((Component)listScroller, "Center");
        Box box = Box.createVerticalBox();
        box.add(new Label("Log level:"));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Level level : levels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL}) {
            JRadioButtonLevel jRadioButtonLevel = new JRadioButtonLevel(level);
            buttonGroup.add(jRadioButtonLevel);
            box.add(jRadioButtonLevel);
        }
        jPanelBlenderFilesListAndLogLevel.add((Component)box, "South");
        return jPanelBlenderFilesListAndLogLevel;
    }

    protected JPanel prepareFilePropertiesPanel() {
        JPanel jPanelProperties = new JPanel();
        jPanelProperties.setBorder(new EmptyBorder(new Insets(0, 5, 0, 5)));
        jPanelProperties.setLayout(new BorderLayout());
        jPanelProperties.add((Component)new JLabel("Properties"), "North");
        this.jTableProperties = new JTable();
        this.jTableProperties.setSelectionMode(0);
        this.jTableProperties.setModel(new BlenderTableModel(new Object[]{"Name", "Value"}));
        this.jTableProperties.getColumnModel().getColumn(1).setCellEditor(new BlenderTableCellEditor());
        JScrollPane jScrollPaneProperties = new JScrollPane(this.jTableProperties);
        this.jTableProperties.setFillsViewportHeight(true);
        jPanelProperties.add((Component)jScrollPaneProperties, "Center");
        JPanel jPanelAnimations = new JPanel();
        jPanelAnimations.setBorder(new EmptyBorder(new Insets(0, 5, 0, 5)));
        jPanelAnimations.setLayout(new BorderLayout());
        jPanelAnimations.add((Component)new JLabel("Animations"), "North");
        this.jTableAnimations = new AnimationsTable();
        JScrollPane jScrollPaneAnimations = new JScrollPane(this.jTableAnimations);
        this.jTableAnimations.setFillsViewportHeight(true);
        JPanel jPanelTableButtons = new JPanel();
        jPanelTableButtons.setLayout(new FlowLayout(0));
        this.jButtonAddAnimation = new JButton("Add animation");
        this.jButtonAddAnimation.setEnabled(false);
        this.jButtonRemoveAnimation = new JButton("Remove animation");
        this.jButtonRemoveAnimation.setEnabled(false);
        jPanelTableButtons.add(this.jButtonAddAnimation);
        jPanelTableButtons.add(this.jButtonRemoveAnimation);
        jPanelAnimations.add((Component)jScrollPaneAnimations, "Center");
        jPanelAnimations.add((Component)jPanelTableButtons, "South");
        this.jCheckBoxUseModelKey = new JCheckBox();
        this.jCheckBoxUseModelKey.setText("Use ModelKey to start the test");
        this.jCheckBoxUseModelKey.setToolTipText("All BlenderKey settings will remain here, but the application will be started using a model key. So only the path to the file will be given!");
        JPanel jPanelResult = new JPanel();
        jPanelResult.setBorder(new TitledBorder("Loading properties"));
        jPanelResult.setLayout(new BorderLayout());
        jPanelResult.add((Component)jPanelProperties, "West");
        jPanelResult.add((Component)jPanelAnimations, "Center");
        jPanelResult.add((Component)this.jCheckBoxUseModelKey, "South");
        return jPanelResult;
    }

    protected JPanel prepareButtonsPanel() {
        JPanel jPanelButtons = new JPanel();
        this.jButtonOK = new JButton("OK");
        this.jButtonOK.setEnabled(false);
        jPanelButtons.add(this.jButtonOK);
        this.jButtonCancel = new JButton("Cancel");
        jPanelButtons.add(this.jButtonCancel);
        return jPanelButtons;
    }

    protected static class BlenderTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = -8601975203921608519L;
        private JCheckBox jCheckBox = new JCheckBox();
        private JTextField jTextField = new JTextField();
        private JComboBox jComboBox = new JComboBox();
        private Object lastValue;

        protected BlenderTableCellEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.lastValue = value;
            if (value instanceof Boolean) {
                this.jCheckBox.setSelected((Boolean)value);
                return this.jCheckBox;
            }
            if (value instanceof String || value instanceof Number || value instanceof Character) {
                this.jTextField.setText(value.toString());
                return this.jTextField;
            }
            if (value instanceof Enum) {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.jComboBox.getModel();
                defaultComboBoxModel.removeAllElements();
                for (Object object : value.getClass().getEnumConstants()) {
                    defaultComboBoxModel.addElement(object);
                }
                return this.jComboBox;
            }
            this.jTextField.setText(value == null ? "" : value.toString());
            return this.jTextField;
        }

        public Object getCellEditorValue() {
            if (this.lastValue instanceof Boolean) {
                return this.jCheckBox.isSelected();
            }
            if (this.lastValue instanceof String) {
                return this.jTextField.getText();
            }
            if (this.lastValue instanceof Character) {
                return Character.valueOf(this.jTextField.getText().charAt(0));
            }
            if (this.lastValue instanceof Byte) {
                return Byte.valueOf(this.jTextField.getText());
            }
            if (this.lastValue instanceof Short) {
                return Short.valueOf(this.jTextField.getText());
            }
            if (this.lastValue instanceof Integer) {
                return Integer.valueOf(this.jTextField.getText());
            }
            if (this.lastValue instanceof Long) {
                return Long.valueOf(this.jTextField.getText());
            }
            if (this.lastValue instanceof Float) {
                return Float.valueOf(this.jTextField.getText());
            }
            if (this.lastValue instanceof Double) {
                return Double.valueOf(this.jTextField.getText());
            }
            if (this.lastValue instanceof Enum) {
                return this.jComboBox.getSelectedItem();
            }
            return null;
        }
    }

    protected static class BlenderTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = -4211206550875326553L;

        public BlenderTableModel(Object[] columnNames) {
            super(columnNames, 0);
        }

        public void addRow(Object[] rowData) {
            for (int i = 0; i < rowData.length; ++i) {
                if (rowData[i] != null) continue;
                rowData[i] = "";
            }
            super.addRow(rowData);
        }

        public boolean isCellEditable(int row, int column) {
            return column > 0;
        }
    }

    protected static class FileListItem {
        private File file;

        public FileListItem(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    protected static class JRadioButtonLevel
    extends JRadioButton {
        private static final long serialVersionUID = 8874525909060993518L;
        private static Level selectedLevel;
        private static Map<Level, JRadioButtonLevel> radioButtons;
        private Level level;

        public JRadioButtonLevel(Level level) {
            super(level.getName());
            this.level = level;
            radioButtons.put(level, this);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    selectedLevel = JRadioButtonLevel.this.level;
                }
            });
        }

        public static Level getSelectedLevel() {
            return selectedLevel;
        }

        public static synchronized void setSelectedLevel(Level level) {
            radioButtons.get(level).setSelected(true);
            selectedLevel = level;
        }

        static {
            radioButtons = new HashMap<Level, JRadioButtonLevel>();
        }
    }
}

