/*
 * Decompiled with CFR 0.152.
 */
package jme3test.blender;

import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.ModelKey;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderLoader;
import com.jme3.scene.plugins.blender.BlenderModelLoader;
import com.jme3.texture.plugins.AWTLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jme3test.blender.config.BlenderKeyConfiguration;
import jme3test.blender.config.ConfigDialog;
import jme3test.blender.scene.Pivot;

public class ManualBlenderTester
extends SimpleApplication {
    private static final Logger LOGGER = Logger.getLogger(ManualBlenderTester.class.getName());
    private BlenderKeyConfiguration blenderKeyConfiguration;
    private final boolean debug;

    public static void main(String[] args) {
        boolean debug = false;
        for (String arg : args) {
            if (!"-debug".equalsIgnoreCase(arg)) continue;
            debug = true;
            break;
        }
        boolean debugMode = debug;
        ConfigDialog configDialog = new ConfigDialog("./src/test-data/Blender");
        BlenderKeyConfiguration bkk = configDialog.getBlenderKeyConfiguration();
        if (bkk != null) {
            new ManualBlenderTester(bkk, debugMode).start();
        }
    }

    public ManualBlenderTester(BlenderKeyConfiguration bkc, boolean debug) {
        this.debug = debug;
        Logger.getLogger("com.jme3").setLevel(bkc.getLogLevel());
        this.blenderKeyConfiguration = bkc;
        this.showSettings = false;
    }

    public void simpleInitApp() {
        if (this.debug) {
            this.mouseInput.setCursorVisible(true);
        }
        this.assetManager.registerLocator(".", FileLocator.class);
        this.assetManager.registerLocator("./src/test-data/Blender/2.4x", FileLocator.class);
        this.assetManager.registerLocator("./src/test-data/Blender/2.4x/textures", FileLocator.class);
        this.assetManager.registerLocator("./src/test-data/Blender/2.5x", FileLocator.class);
        this.assetManager.registerLoader(BlenderLoader.class, new String[]{"blend"});
        this.assetManager.registerLoader(AWTLoader.class, new String[]{"png", "jpg", "bmp"});
        this.viewPort.setBackgroundColor(ColorRGBA.Gray);
        this.flyCam.setMoveSpeed(20.0f);
        this.cam.setFrustumFar(1000.0f);
        this.cam.setFrustumNear(1.0f);
        ModelKey modelKey = this.blenderKeyConfiguration.getKeyToUse();
        AssetInfo ai = new AssetInfo(this.assetManager, (AssetKey)modelKey){

            public InputStream openStream() {
                try {
                    return new FileInputStream(this.key.getName());
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    return null;
                }
            }
        };
        this.rootNode.attachChild((Spatial)new Pivot(this.assetManager));
        if (modelKey instanceof BlenderKey) {
            this.testBlenderLoader(ai);
        } else {
            this.testBlenderModelLoader(ai);
        }
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(new Vector3f(0.0f, -10.0f, 0.0f).normalizeLocal());
        sun.setColor(ColorRGBA.White);
        this.rootNode.addLight((Light)sun);
    }

    private Spatial findNode(Node rootNode, String name) {
        if (name.equals(rootNode.getName())) {
            return rootNode;
        }
        return rootNode.getChild(name);
    }

    private Node testBlenderLoader(AssetInfo assetInfo) {
        Node blenderModel = null;
        BlenderLoader blenderLoader = new BlenderLoader();
        try {
            BlenderKey.LoadingResults loadingResults = (BlenderKey.LoadingResults)blenderLoader.load(assetInfo);
            for (Node object : loadingResults.getObjects()) {
                this.rootNode.attachChild((Spatial)object);
                blenderModel = object;
            }
            for (Light light : loadingResults.getLights()) {
                this.rootNode.addLight(light);
            }
            for (Camera camera : loadingResults.getCameras()) {
                LOGGER.info(camera.toString());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return blenderModel;
    }

    private Node testBlenderModelLoader(AssetInfo assetInfo) {
        BlenderModelLoader blenderLoader = new BlenderModelLoader();
        try {
            Spatial loadingResults = blenderLoader.load(assetInfo);
            this.rootNode.attachChild(loadingResults);
            if (loadingResults instanceof Node) {
                return (Node)loadingResults;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }
}

