/*
 * Decompiled with CFR 0.152.
 */
package jme3test.batching;

import com.jme3.app.SimpleApplication;
import com.jme3.font.BitmapText;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.BloomFilter;
import com.jme3.scene.Geometry;
import com.jme3.scene.GeometryBatch;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.debug.Arrow;
import com.jme3.scene.shape.Box;
import com.jme3.system.AppSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TestCubeCluster
extends SimpleApplication {
    private ActionListener al = new ActionListener(){

        public void onAction(String name, boolean isPressed, float tpf) {
            if (name.equals("Start Game")) {
                // empty if block
            }
        }
    };
    protected Random rand = new Random();
    protected int maxCubes = 2000;
    protected int startAt = 0;
    protected static int xPositions = 0;
    protected static int yPositions = 0;
    protected static int zPositions = 0;
    protected int returner = 0;
    protected ArrayList<Integer> xPosition = new ArrayList();
    protected ArrayList<Integer> yPosition = new ArrayList();
    protected ArrayList<Integer> zPosition = new ArrayList();
    protected int xLimitf = 60;
    protected int xLimits = -60;
    protected int yLimitf = 60;
    protected int yLimits = -20;
    protected int zLimitf = 60;
    protected int zLimits = -60;
    protected int circ = 8;
    protected int dynamic = 4;
    protected static AppSettings settingst;
    protected boolean isTrue = true;
    private BitmapText helloText2;
    private int lineLength = 50;
    protected GeometryBatch blue;
    protected GeometryBatch brown;
    protected GeometryBatch pink;
    protected GeometryBatch orange;
    protected List<Geometry> blueList = new ArrayList<Geometry>();
    protected List<Geometry> brownList = new ArrayList<Geometry>();
    protected List<Geometry> pinkList = new ArrayList<Geometry>();
    protected List<Geometry> orangeList = new ArrayList<Geometry>();
    Material mat1;
    Material mat2;
    Material mat3;
    Material mat4;
    Node terrain;
    long nbFrames = 0L;
    long cullTime = 0L;
    float time = 0.0f;
    Vector3f lookAtPos = new Vector3f(0.0f, 0.0f, 0.0f);
    float xpos = 0.0f;
    Spatial box;

    public static void main(String[] args) {
        TestCubeCluster app = new TestCubeCluster();
        settingst = new AppSettings(true);
        settingst.setResolution(640, 480);
        settingst.setVSync(false);
        settingst.setFullscreen(false);
        app.setSettings(settingst);
        app.setShowSettings(false);
        app.start();
    }

    public void simpleInitApp() {
        this.blue = new GeometryBatch("blue");
        this.brown = new GeometryBatch("brown");
        this.pink = new GeometryBatch("pink");
        this.orange = new GeometryBatch("orange");
        this.mat1 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat1.setColor("Color", ColorRGBA.White);
        this.mat1.setColor("GlowColor", ColorRGBA.Blue.mult(10.0f));
        this.blue.setMaterial(this.mat1);
        this.mat2 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat2.setColor("Color", ColorRGBA.White);
        this.mat2.setColor("GlowColor", ColorRGBA.Red.mult(10.0f));
        this.brown.setMaterial(this.mat2);
        this.mat3 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat3.setColor("Color", ColorRGBA.White);
        this.mat3.setColor("GlowColor", ColorRGBA.Yellow.mult(10.0f));
        this.pink.setMaterial(this.mat3);
        this.mat4 = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        this.mat4.setColor("Color", ColorRGBA.White);
        this.mat4.setColor("GlowColor", ColorRGBA.Orange.mult(10.0f));
        this.orange.setMaterial(this.mat4);
        this.inputManager.addMapping("Start Game", new Trigger[]{new KeyTrigger(36)});
        this.inputManager.addListener((InputListener)this.al, new String[]{"Start Game"});
        this.cam.setLocation(new Vector3f(-34.403286f, 126.65158f, 434.791f));
        this.cam.setRotation(new Quaternion(0.022630932f, 0.9749435f, -0.18736298f, 0.11776358f));
        this.xPosition.add(0);
        this.yPosition.add(0);
        this.zPosition.add(0);
        this.randomGenerator();
        List l = this.blue.batch(this.blueList);
        l = this.brown.batch(this.brownList);
        l = this.pink.batch(this.pinkList);
        l = this.orange.batch(this.orangeList);
        this.terrain = new Node("terrain");
        this.terrain.setLocalTranslation(50.0f, 0.0f, 50.0f);
        this.terrain.attachChild((Spatial)this.blue);
        this.terrain.attachChild((Spatial)this.brown);
        this.terrain.attachChild((Spatial)this.pink);
        this.terrain.attachChild((Spatial)this.orange);
        this.flyCam.setMoveSpeed(100.0f);
        this.rootNode.attachChild((Spatial)this.terrain);
        Vector3f pos = new Vector3f(-40.0f, 0.0f, -40.0f);
        this.blue.setLocalTranslation(pos);
        this.brown.setLocalTranslation(pos);
        this.pink.setLocalTranslation(pos);
        this.orange.setLocalTranslation(pos);
        Arrow a = new Arrow(new Vector3f(0.0f, 50.0f, 0.0f));
        Geometry g = new Geometry("a", (Mesh)a);
        g.setLocalTranslation(this.terrain.getLocalTranslation());
        Material m = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        m.setColor("Color", ColorRGBA.Blue);
        g.setMaterial(m);
        FilterPostProcessor fpp = new FilterPostProcessor(this.assetManager);
        fpp.addFilter((Filter)new BloomFilter(BloomFilter.GlowMode.Objects));
        this.viewPort.addProcessor((SceneProcessor)fpp);
    }

    public void randomGenerator() {
        for (int i = this.startAt; i < this.maxCubes - 1; ++i) {
            this.randomize();
            Geometry box = new Geometry("Box" + i, (Mesh)new Box(Vector3f.ZERO, 1.0f, 1.0f, 1.0f));
            box.setLocalTranslation(new Vector3f((float)this.xPosition.get(this.xPosition.size() - 1).intValue(), (float)this.yPosition.get(this.yPosition.size() - 1).intValue(), (float)this.zPosition.get(this.zPosition.size() - 1).intValue()));
            if (i < 500) {
                this.blueList.add(box);
                continue;
            }
            if (i < 1000) {
                this.brownList.add(box);
                continue;
            }
            if (i < 1500) {
                this.pinkList.add(box);
                continue;
            }
            this.orangeList.add(box);
        }
    }

    public GeometryBatch randomBatch() {
        int randomn = this.rand.nextInt(4);
        if (randomn == 0) {
            return this.blue;
        }
        if (randomn == 1) {
            return this.brown;
        }
        if (randomn == 2) {
            return this.pink;
        }
        if (randomn == 3) {
            return this.orange;
        }
        return null;
    }

    public ColorRGBA randomColor() {
        ColorRGBA color = ColorRGBA.Black;
        int randomn = this.rand.nextInt(4);
        if (randomn == 0) {
            color = ColorRGBA.Orange;
        } else if (randomn == 1) {
            color = ColorRGBA.Blue;
        } else if (randomn == 2) {
            color = ColorRGBA.Brown;
        } else if (randomn == 3) {
            color = ColorRGBA.Magenta;
        }
        return color;
    }

    public void randomize() {
        int xpos = this.xPosition.get(this.xPosition.size() - 1);
        int ypos = this.yPosition.get(this.yPosition.size() - 1);
        int zpos = this.zPosition.get(this.zPosition.size() - 1);
        int x = 0;
        int y = 0;
        int z = 0;
        boolean unTrue = true;
        while (unTrue) {
            unTrue = false;
            boolean xChanged = false;
            x = 0;
            y = 0;
            z = 0;
            if (xpos >= this.lineLength * 2) {
                x = 2;
                xChanged = true;
            } else {
                x = this.xPosition.get(this.xPosition.size() - 1) + 2;
            }
            if (!xChanged) {
                y = this.rand.nextInt(3);
                if (this.yPosition.size() > this.lineLength) {
                    if (this.yPosition.size() > 51) {
                        if (y == 0 && ypos < this.yLimitf && this.getym(this.lineLength) > ypos - 2) {
                            y = ypos + 2;
                        } else if (y == 1 && ypos > this.yLimits && this.getym(this.lineLength) < ypos + 2) {
                            y = ypos - 2;
                        } else if (y == 2 && this.getym(this.lineLength) > ypos - 2 && this.getym(this.lineLength) < ypos + 2) {
                            y = ypos;
                        } else if (ypos >= this.yLimitf) {
                            y = ypos - 2;
                        } else if (ypos <= this.yLimits) {
                            y = ypos + 2;
                        } else if (y == 0 && this.getym(this.lineLength) >= ypos - 4) {
                            y = ypos - 2;
                        } else if (y == 0 && this.getym(this.lineLength) >= ypos - 2) {
                            y = ypos;
                        } else if (y == 1 && this.getym(this.lineLength) >= ypos + 4) {
                            y = ypos + 2;
                        } else if (y == 1 && this.getym(this.lineLength) >= ypos + 2) {
                            y = ypos;
                        } else if (y == 2 && this.getym(this.lineLength) <= ypos - 2) {
                            y = ypos - 2;
                        } else if (y == 2 && this.getym(this.lineLength) >= ypos + 2) {
                            y = ypos + 2;
                        } else {
                            System.out.println("wtf");
                        }
                    } else if (this.yPosition.size() == this.lineLength) {
                        if (y == 0 && ypos < this.yLimitf) {
                            y = this.getym(this.lineLength) + 2;
                        } else if (y == 1 && ypos > this.yLimits) {
                            y = this.getym(this.lineLength) - 2;
                        }
                    }
                } else if (y == 0 && ypos < this.yLimitf) {
                    y = ypos + 2;
                } else if (y == 1 && ypos > this.yLimits) {
                    y = ypos - 2;
                } else if (y == 2) {
                    y = ypos;
                } else if (y == 0 && ypos >= this.yLimitf) {
                    y = ypos - 2;
                } else if (y == 1 && ypos <= this.yLimits) {
                    y = ypos + 2;
                }
            }
            if (xChanged) {
                z = zpos + 2;
                continue;
            }
            z = zpos;
        }
        this.xPosition.add(x);
        this.yPosition.add(y);
        this.zPosition.add(z);
    }

    public int getxm(int i) {
        return this.xPosition.get(this.xPosition.size() - i);
    }

    public int getym(int i) {
        return this.yPosition.get(this.yPosition.size() - i);
    }

    public int getzm(int i) {
        return this.zPosition.get(this.zPosition.size() - i);
    }

    public int getx(int i) {
        return this.xPosition.get(i);
    }

    public int gety(int i) {
        return this.yPosition.get(i);
    }

    public int getz(int i) {
        return this.zPosition.get(i);
    }

    public void simpleUpdate(float tpf) {
        this.time += tpf;
        int random = this.rand.nextInt(2000);
        float mult1 = 1.0f;
        float mult2 = 1.0f;
        GeometryBatch b = null;
        if (random < 500) {
            b = this.blue;
            mult1 = 1.0f;
            mult2 = 1.0f;
        } else if (random < 1000) {
            b = this.brown;
            mult1 = -1.0f;
            mult2 = 1.0f;
        } else if (random < 1500) {
            b = this.pink;
            mult1 = 1.0f;
            mult2 = -1.0f;
        } else if (random <= 2000) {
            b = this.orange;
            mult1 = -1.0f;
            mult2 = -1.0f;
        }
        this.box = b.getChild("Box" + random);
        if (this.box != null) {
            Vector3f v = this.box.getLocalTranslation();
            this.box.setLocalTranslation(v.x + FastMath.sin((float)(this.time * mult1)) * 20.0f, v.y + FastMath.sin((float)(this.time * mult1)) * FastMath.cos((float)(this.time * mult1)) * 20.0f, v.z + FastMath.cos((float)(this.time * mult2)) * 20.0f);
        }
        this.terrain.setLocalRotation(new Quaternion().fromAngleAxis(this.time, Vector3f.UNIT_Y));
    }
}

