/*
 * Decompiled with CFR 0.152.
 */
package jme3test.awt;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeCanvasContext;
import com.jme3.system.JmeSystem;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Graphics;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;

public class TestApplet
extends Applet {
    private static JmeCanvasContext context;
    private static Application app;
    private static Canvas canvas;
    private static TestApplet applet;

    public static void createCanvas(String appClass) {
        AppSettings settings = new AppSettings(true);
        settings.setWidth(640);
        settings.setHeight(480);
        JmeSystem.setLowPermissions((boolean)true);
        try {
            Class<?> clazz = Class.forName(appClass);
            app = (Application)clazz.newInstance();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        app.setSettings(settings);
        app.createCanvas();
        context = (JmeCanvasContext)app.getContext();
        canvas = context.getCanvas();
        canvas.setSize(settings.getWidth(), settings.getHeight());
    }

    public static void startApp() {
        applet.add(canvas);
        app.startCanvas();
        app.enqueue((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                if (app instanceof SimpleApplication) {
                    SimpleApplication simpleApp = (SimpleApplication)app;
                    simpleApp.getFlyByCamera().setDragToRotate(true);
                    simpleApp.getInputManager().setCursorVisible(true);
                }
                return null;
            }
        });
    }

    public void freezeApp() {
        this.remove(canvas);
    }

    public void unfreezeApp() {
        this.add(canvas);
    }

    public final void update(Graphics g) {
    }

    public void init() {
        applet = this;
        TestApplet.createCanvas("jme3test.model.shape.TestBox");
        TestApplet.startApp();
        app.setPauseOnLostFocus(false);
        System.out.println("applet:init");
    }

    public void start() {
        System.out.println("applet:start");
    }

    public void stop() {
        System.out.println("applet:stop");
    }

    public void destroy() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestApplet.this.removeAll();
                System.out.println("applet:destroyStart");
            }
        });
        app.stop(true);
        System.out.println("applet:destroyEnd");
    }
}

