/*
 * Decompiled with CFR 0.152.
 */
package jme3test.asset;

import com.jme3.asset.Asset;
import com.jme3.asset.AssetCache;
import com.jme3.asset.AssetKey;
import java.util.ArrayList;

public class TestAssetCache {
    private static final boolean KEEP_REFERENCES = false;
    private static final boolean USE_SMART_CACHE = true;
    private static final boolean CLONEABLE_ASSET = true;
    private static int counter = 0;

    public static void main(String[] args) {
        ArrayList refs = new ArrayList(5000);
        AssetCache cache = new AssetCache();
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        long memory = Runtime.getRuntime().freeMemory();
        while (true) {
            SmartKey key = new SmartKey();
            DummyData data = new DummyData();
            cache.addToCache((AssetKey)key, (Object)data);
            if (counter % 100 != 0) continue;
            long newMem = Runtime.getRuntime().freeMemory();
            System.out.println("Allocated objects: " + counter);
            System.out.println("Allocated memory: " + (memory - newMem) / 1024L + "K");
            memory = newMem;
        }
    }

    private static class DumbKey
    extends AssetKey {
        public DumbKey() {
            super(".");
            counter++;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object other) {
            return false;
        }

        public Object createClonedInstance(Object asset) {
            DummyData data = new DummyData();
            return data;
        }
    }

    private static class SmartKey
    extends AssetKey {
        public SmartKey() {
            super(".");
            counter++;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object other) {
            return false;
        }

        public boolean useSmartCache() {
            return true;
        }

        public Object createClonedInstance(Object asset) {
            DummyData data = new DummyData();
            return data;
        }
    }

    private static class DummyData
    implements Asset {
        private AssetKey key;
        private byte[] data = new byte[10000];

        private DummyData() {
        }

        public byte[] getData() {
            return this.data;
        }

        public AssetKey getKey() {
            return this.key;
        }

        public void setKey(AssetKey key) {
            this.key = key;
        }
    }
}

