/*
 * Decompiled with CFR 0.152.
 */
package jme3test.app;

import com.jme3.math.Vector3f;
import com.jme3.util.TempVars;

public class TestTempVars {
    private static final int ITERATIONS = 10000000;
    private static final int NANOS_TO_MS = 1000000;
    private static final Vector3f sumCompute = new Vector3f();

    public static void main(String[] args) {
        int i;
        for (i = 0; i < 4; ++i) {
            System.gc();
        }
        sumCompute.set(0.0f, 0.0f, 0.0f);
        long nanos = System.nanoTime();
        for (i = 0; i < 10000000; ++i) {
            TestTempVars.methodThatUsesTempVars();
        }
        long milliseconds = (System.nanoTime() - nanos) / 1000000L;
        System.out.println("100 million TempVars calls: " + milliseconds + " ms");
        System.out.println(sumCompute);
        sumCompute.set(0.0f, 0.0f, 0.0f);
        nanos = System.nanoTime();
        for (i = 0; i < 10000000; ++i) {
            TestTempVars.methodThatUsesAllocation();
        }
        milliseconds = (System.nanoTime() - nanos) / 1000000L;
        System.out.println("100 million allocation calls: " + milliseconds + " ms");
        System.out.println(sumCompute);
        nanos = System.nanoTime();
        for (i = 0; i < 10; ++i) {
            System.gc();
        }
        milliseconds = (System.nanoTime() - nanos) / 1000000L;
        System.out.println("cleanup time after allocation calls: " + milliseconds + " ms");
    }

    public static void methodThatUsesAllocation() {
        Vector3f vector = new Vector3f();
        vector.set(0.1f, 0.2f, 0.3f);
        sumCompute.addLocal(vector);
    }

    public static void recursiveMethod(int recurse) {
        TempVars vars = TempVars.get();
        vars.vect1.set(0.1f, 0.2f, 0.3f);
        if (recurse < 4) {
            TestTempVars.recursiveMethod(recurse + 1);
        }
        sumCompute.addLocal(vars.vect1);
        vars.release();
    }

    public static void methodThatUsesTempVars() {
        TempVars vars = TempVars.get();
        vars.vect1.set(0.1f, 0.2f, 0.3f);
        sumCompute.addLocal(vars.vect1);
        vars.release();
    }
}

