/*
 * Decompiled with CFR 0.152.
 */
package jme3test.animation;

import com.jme3.app.SimpleApplication;
import com.jme3.cinematic.MotionPath;
import com.jme3.cinematic.MotionPathListener;
import com.jme3.cinematic.events.MotionTrack;
import com.jme3.font.BitmapText;
import com.jme3.input.ChaseCamera;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Spline;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;

public class TestMotionPath
extends SimpleApplication {
    private Spatial teapot;
    private boolean active = true;
    private boolean playing = false;
    private MotionPath path;
    private MotionTrack motionControl;

    public static void main(String[] args) {
        TestMotionPath app = new TestMotionPath();
        app.start();
    }

    public void simpleInitApp() {
        this.createScene();
        this.cam.setLocation(new Vector3f(8.4399185f, 11.189463f, 14.267577f));
        this.path = new MotionPath();
        this.path.addWayPoint(new Vector3f(10.0f, 3.0f, 0.0f));
        this.path.addWayPoint(new Vector3f(10.0f, 3.0f, 10.0f));
        this.path.addWayPoint(new Vector3f(-40.0f, 3.0f, 10.0f));
        this.path.addWayPoint(new Vector3f(-40.0f, 3.0f, 0.0f));
        this.path.addWayPoint(new Vector3f(-40.0f, 8.0f, 0.0f));
        this.path.addWayPoint(new Vector3f(10.0f, 8.0f, 0.0f));
        this.path.addWayPoint(new Vector3f(10.0f, 8.0f, 10.0f));
        this.path.addWayPoint(new Vector3f(15.0f, 8.0f, 10.0f));
        this.path.enableDebugShape(this.assetManager, this.rootNode);
        this.motionControl = new MotionTrack(this.teapot, this.path);
        this.motionControl.setDirectionType(MotionTrack.Direction.PathAndRotation);
        this.motionControl.setRotation(new Quaternion().fromAngleNormalAxis(-1.5707964f, Vector3f.UNIT_Y));
        this.motionControl.setInitialDuration(10.0f);
        this.motionControl.setSpeed(0.1f);
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        final BitmapText wayPointsText = new BitmapText(this.guiFont, false);
        wayPointsText.setSize((float)this.guiFont.getCharSet().getRenderedSize());
        this.guiNode.attachChild((Spatial)wayPointsText);
        this.path.addListener(new MotionPathListener(){

            public void onWayPointReach(MotionTrack control, int wayPointIndex) {
                if (TestMotionPath.this.path.getNbWayPoints() == wayPointIndex + 1) {
                    wayPointsText.setText(control.getSpatial().getName() + "Finished!!! ");
                } else {
                    wayPointsText.setText(control.getSpatial().getName() + " Reached way point " + wayPointIndex);
                }
                wayPointsText.setLocalTranslation(((float)TestMotionPath.this.cam.getWidth() - wayPointsText.getLineWidth()) / 2.0f, (float)TestMotionPath.this.cam.getHeight(), 0.0f);
            }
        });
        this.flyCam.setEnabled(false);
        ChaseCamera chaser = new ChaseCamera(this.cam, this.teapot);
        chaser.registerWithInput(this.inputManager);
        this.initInputs();
    }

    private void createScene() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        mat.setFloat("Shininess", 1.0f);
        mat.setBoolean("UseMaterialColors", true);
        mat.setColor("Ambient", ColorRGBA.Black);
        mat.setColor("Diffuse", ColorRGBA.DarkGray);
        mat.setColor("Specular", ColorRGBA.White.mult(0.6f));
        Material matSoil = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        matSoil.setBoolean("UseMaterialColors", true);
        matSoil.setColor("Ambient", ColorRGBA.Black);
        matSoil.setColor("Diffuse", ColorRGBA.Black);
        matSoil.setColor("Specular", ColorRGBA.Black);
        this.teapot = this.assetManager.loadModel("Models/Teapot/Teapot.obj");
        this.teapot.setName("Teapot");
        this.teapot.setLocalScale(3.0f);
        this.teapot.setMaterial(mat);
        this.rootNode.attachChild(this.teapot);
        Geometry soil = new Geometry("soil", (Mesh)new Box(new Vector3f(0.0f, -1.0f, 0.0f), 50.0f, 1.0f, 50.0f));
        soil.setMaterial(matSoil);
        this.rootNode.attachChild((Spatial)soil);
        DirectionalLight light = new DirectionalLight();
        light.setDirection(new Vector3f(0.0f, -1.0f, 0.0f).normalizeLocal());
        light.setColor(ColorRGBA.White.mult(1.5f));
        this.rootNode.addLight((Light)light);
    }

    private void initInputs() {
        this.inputManager.addMapping("display_hidePath", new Trigger[]{new KeyTrigger(25)});
        this.inputManager.addMapping("SwitchPathInterpolation", new Trigger[]{new KeyTrigger(23)});
        this.inputManager.addMapping("tensionUp", new Trigger[]{new KeyTrigger(22)});
        this.inputManager.addMapping("tensionDown", new Trigger[]{new KeyTrigger(36)});
        this.inputManager.addMapping("play_stop", new Trigger[]{new KeyTrigger(57)});
        ActionListener acl = new ActionListener(){

            public void onAction(String name, boolean keyPressed, float tpf) {
                if (name.equals("display_hidePath") && keyPressed) {
                    if (TestMotionPath.this.active) {
                        TestMotionPath.this.active = false;
                        TestMotionPath.this.path.disableDebugShape();
                    } else {
                        TestMotionPath.this.active = true;
                        TestMotionPath.this.path.enableDebugShape(TestMotionPath.this.assetManager, TestMotionPath.this.rootNode);
                    }
                }
                if (name.equals("play_stop") && keyPressed) {
                    if (TestMotionPath.this.playing) {
                        TestMotionPath.this.playing = false;
                        TestMotionPath.this.motionControl.stop();
                    } else {
                        TestMotionPath.this.playing = true;
                        TestMotionPath.this.motionControl.play();
                    }
                }
                if (name.equals("SwitchPathInterpolation") && keyPressed) {
                    if (TestMotionPath.this.path.getPathSplineType() == Spline.SplineType.CatmullRom) {
                        TestMotionPath.this.path.setPathSplineType(Spline.SplineType.Linear);
                    } else {
                        TestMotionPath.this.path.setPathSplineType(Spline.SplineType.CatmullRom);
                    }
                }
                if (name.equals("tensionUp") && keyPressed) {
                    TestMotionPath.this.path.setCurveTension(TestMotionPath.this.path.getCurveTension() + 0.1f);
                    System.err.println("Tension : " + TestMotionPath.this.path.getCurveTension());
                }
                if (name.equals("tensionDown") && keyPressed) {
                    TestMotionPath.this.path.setCurveTension(TestMotionPath.this.path.getCurveTension() - 0.1f);
                    System.err.println("Tension : " + TestMotionPath.this.path.getCurveTension());
                }
            }
        };
        this.inputManager.addListener((InputListener)acl, new String[]{"display_hidePath", "play_stop", "SwitchPathInterpolation", "tensionUp", "tensionDown"});
    }
}

