/*
 * Decompiled with CFR 0.152.
 */
package jme3test.animation;

import com.jme3.animation.LoopMode;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.AppState;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.MotionPath;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.cinematic.events.AnimationTrack;
import com.jme3.cinematic.events.CinematicEvent;
import com.jme3.cinematic.events.CinematicEventListener;
import com.jme3.cinematic.events.MotionTrack;
import com.jme3.cinematic.events.PositionTrack;
import com.jme3.cinematic.events.RotationTrack;
import com.jme3.cinematic.events.ScaleTrack;
import com.jme3.cinematic.events.SoundTrack;
import com.jme3.font.BitmapText;
import com.jme3.input.ChaseCamera;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.post.Filter;
import com.jme3.post.FilterPostProcessor;
import com.jme3.post.SceneProcessor;
import com.jme3.post.filters.FadeFilter;
import com.jme3.renderer.Caps;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.CameraNode;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Box;
import com.jme3.shadow.PssmShadowRenderer;
import jme3test.animation.SubtitleTrack;

public class TestCinematic
extends SimpleApplication {
    private Spatial model;
    private Spatial teapot;
    private MotionPath path;
    private MotionTrack cameraMotionTrack;
    private Cinematic cinematic;
    private ChaseCamera chaseCam;
    private FilterPostProcessor fpp;
    private FadeFilter fade;

    public static void main(String[] args) {
        TestCinematic app = new TestCinematic();
        app.start();
    }

    public void simpleInitApp() {
        this.guiFont = this.assetManager.loadFont("Interface/Fonts/Default.fnt");
        BitmapText text = new BitmapText(this.guiFont, false);
        text.setSize((float)this.guiFont.getCharSet().getRenderedSize());
        text.setText("Press enter to play/pause cinematic");
        text.setLocalTranslation(((float)this.cam.getWidth() - text.getLineWidth()) / 2.0f, (float)this.cam.getHeight(), 0.0f);
        this.guiNode.attachChild((Spatial)text);
        this.createScene();
        this.cinematic = new Cinematic(this.rootNode, 20.0f);
        this.cinematic.bindUi("Interface/Nifty/CinematicTest.xml");
        this.stateManager.attach((AppState)this.cinematic);
        this.createCameraMotion();
        this.cinematic.addCinematicEvent(0.0f, (CinematicEvent)new AbstractCinematicEvent(){

            public void onPlay() {
                TestCinematic.this.fade.setValue(0.0f);
                TestCinematic.this.fade.fadeIn();
            }

            public void onUpdate(float tpf) {
            }

            public void onStop() {
            }

            public void onPause() {
            }
        });
        this.cinematic.addCinematicEvent(0.0f, (CinematicEvent)new PositionTrack(this.teapot, new Vector3f(10.0f, 0.0f, 10.0f), 0.0f));
        this.cinematic.addCinematicEvent(0.0f, (CinematicEvent)new ScaleTrack(this.teapot, new Vector3f(1.0f, 1.0f, 1.0f), 0.0f));
        float[] rotation = new float[]{0.0f, 0.0f, 0.0f};
        this.cinematic.addCinematicEvent(0.0f, (CinematicEvent)new RotationTrack(this.teapot, rotation, 0.0f));
        this.cinematic.addCinematicEvent(0.0f, (CinematicEvent)new PositionTrack(this.teapot, new Vector3f(10.0f, 0.0f, -10.0f), 20.0f));
        this.cinematic.addCinematicEvent(0.0f, (CinematicEvent)new ScaleTrack(this.teapot, new Vector3f(4.0f, 4.0f, 4.0f), 10.0f));
        this.cinematic.addCinematicEvent(10.0f, (CinematicEvent)new ScaleTrack(this.teapot, new Vector3f(1.0f, 1.0f, 1.0f), 10.0f));
        float[] rotation2 = new float[]{0.0f, (float)Math.PI * 2, 0.0f};
        this.cinematic.addCinematicEvent(0.0f, (CinematicEvent)new RotationTrack(this.teapot, rotation2, 20.0f));
        this.cinematic.activateCamera(0.0f, "aroundCam");
        this.cinematic.addCinematicEvent(0.0f, (CinematicEvent)this.cameraMotionTrack);
        this.cinematic.addCinematicEvent(0.0f, (CinematicEvent)new SoundTrack("Sound/Environment/Nature.ogg", LoopMode.Loop));
        this.cinematic.addCinematicEvent(3.0f, (CinematicEvent)new SoundTrack("Sound/Effects/kick.wav"));
        this.cinematic.addCinematicEvent(3.0f, (CinematicEvent)new SubtitleTrack("start", 3.0f, "jMonkey engine really kicks A..."));
        this.cinematic.addCinematicEvent(5.0f, (CinematicEvent)new SoundTrack("Sound/Effects/Beep.ogg", 1.0f));
        this.cinematic.addCinematicEvent(6.0f, (CinematicEvent)new AnimationTrack(this.model, "Walk", LoopMode.Loop));
        this.cinematic.activateCamera(6.0f, "topView");
        this.cinematic.activateCamera(10.0f, "aroundCam");
        this.cinematic.addCinematicEvent(19.0f, (CinematicEvent)new AbstractCinematicEvent(){

            public void onPlay() {
                TestCinematic.this.fade.fadeOut();
            }

            public void onUpdate(float tpf) {
            }

            public void onStop() {
            }

            public void onPause() {
            }
        });
        this.cinematic.addListener(new CinematicEventListener(){

            public void onPlay(CinematicEvent cinematic) {
                TestCinematic.this.chaseCam.setEnabled(false);
                System.out.println("play");
            }

            public void onPause(CinematicEvent cinematic) {
                TestCinematic.this.chaseCam.setEnabled(true);
                System.out.println("pause");
            }

            public void onStop(CinematicEvent cinematic) {
                TestCinematic.this.chaseCam.setEnabled(true);
                TestCinematic.this.fade.setValue(1.0f);
                System.out.println("stop");
            }
        });
        this.flyCam.setEnabled(false);
        this.chaseCam = new ChaseCamera(this.cam, this.model, this.inputManager);
        this.initInputs();
    }

    private void createCameraMotion() {
        CameraNode camNode = this.cinematic.bindCamera("topView", this.cam);
        camNode.setLocalTranslation(new Vector3f(0.0f, 50.0f, 0.0f));
        camNode.lookAt(this.model.getLocalTranslation(), Vector3f.UNIT_Y);
        CameraNode camNode2 = this.cinematic.bindCamera("aroundCam", this.cam);
        this.path = new MotionPath();
        this.path.setCycle(true);
        this.path.addWayPoint(new Vector3f(20.0f, 3.0f, 0.0f));
        this.path.addWayPoint(new Vector3f(0.0f, 3.0f, 20.0f));
        this.path.addWayPoint(new Vector3f(-20.0f, 3.0f, 0.0f));
        this.path.addWayPoint(new Vector3f(0.0f, 3.0f, -20.0f));
        this.path.setCurveTension(0.83f);
        this.cameraMotionTrack = new MotionTrack((Spatial)camNode2, this.path);
        this.cameraMotionTrack.setLoopMode(LoopMode.Loop);
        this.cameraMotionTrack.setLookAt(this.model.getWorldTranslation(), Vector3f.UNIT_Y);
        this.cameraMotionTrack.setDirectionType(MotionTrack.Direction.LookAt);
    }

    private void createScene() {
        this.model = this.assetManager.loadModel("Models/Oto/Oto.mesh.xml");
        this.model.center();
        this.model.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.rootNode.attachChild(this.model);
        Material mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        mat.setColor("Color", ColorRGBA.Cyan);
        this.teapot = this.assetManager.loadModel("Models/Teapot/Teapot.obj");
        this.teapot.setLocalTranslation(10.0f, 0.0f, 10.0f);
        this.teapot.setMaterial(mat);
        this.teapot.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
        this.rootNode.attachChild(this.teapot);
        Material matSoil = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        matSoil.setBoolean("UseMaterialColors", true);
        matSoil.setColor("Ambient", ColorRGBA.Gray);
        matSoil.setColor("Diffuse", ColorRGBA.Green);
        matSoil.setColor("Specular", ColorRGBA.Black);
        Geometry soil = new Geometry("soil", (Mesh)new Box(new Vector3f(0.0f, -6.0f, 0.0f), 50.0f, 1.0f, 50.0f));
        soil.setMaterial(matSoil);
        soil.setShadowMode(RenderQueue.ShadowMode.Receive);
        this.rootNode.attachChild((Spatial)soil);
        DirectionalLight light = new DirectionalLight();
        light.setDirection(new Vector3f(0.0f, -1.0f, -1.0f).normalizeLocal());
        light.setColor(ColorRGBA.White.mult(1.5f));
        this.rootNode.addLight((Light)light);
        this.fpp = new FilterPostProcessor(this.assetManager);
        this.fade = new FadeFilter();
        this.fpp.addFilter((Filter)this.fade);
        if (this.renderer.getCaps().contains(Caps.GLSL100)) {
            PssmShadowRenderer pssm = new PssmShadowRenderer(this.assetManager, 512, 1);
            pssm.setDirection(new Vector3f(0.0f, -1.0f, -1.0f).normalizeLocal());
            pssm.setShadowIntensity(0.4f);
            this.viewPort.addProcessor((SceneProcessor)pssm);
            this.viewPort.addProcessor((SceneProcessor)this.fpp);
        }
    }

    private void initInputs() {
        Trigger[] triggerArray = new Trigger[1];
        triggerArray[0] = new KeyTrigger(28);
        this.inputManager.addMapping("togglePause", triggerArray);
        ActionListener acl = new ActionListener(){

            public void onAction(String name, boolean keyPressed, float tpf) {
                if (name.equals("togglePause") && keyPressed) {
                    if (TestCinematic.this.cinematic.getPlayState() == PlayState.Playing) {
                        TestCinematic.this.cinematic.pause();
                    } else {
                        TestCinematic.this.cinematic.play();
                    }
                }
            }
        };
        this.inputManager.addListener((InputListener)acl, new String[]{"togglePause"});
    }
}

