/*
 * Decompiled with CFR 0.152.
 */
package jme3test;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.system.JmeContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestChooser
extends JDialog {
    private static final Logger logger = Logger.getLogger(TestChooser.class.getName());
    private static final long serialVersionUID = 1L;
    private Object[] selectedClass = null;
    private boolean showSetting = true;

    public TestChooser() throws HeadlessException {
        super((Frame)null, "TestChooser");
    }

    protected Vector<Class> find(String pckgname, boolean recursive, Vector<Class> classes) {
        File directory;
        String name = pckgname;
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        name = name.replace('.', '/');
        URL url = this.getClass().getResource(name);
        pckgname = pckgname + ".";
        try {
            directory = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (directory.exists()) {
            logger.info("Searching for Demo classes in \"" + directory.getName() + "\".");
            this.addAllFilesInDirectory(directory, classes, pckgname, recursive);
        } else {
            try {
                logger.info("Searching for Demo classes in \"" + url + "\".");
                URLConnection urlConnection = url.openConnection();
                if (urlConnection instanceof JarURLConnection) {
                    JarURLConnection conn = (JarURLConnection)urlConnection;
                    JarFile jfile = conn.getJarFile();
                    Enumeration<JarEntry> e = jfile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        Class result = this.load(entry.getName());
                        if (result == null || classes.contains(result)) continue;
                        classes.add(result);
                    }
                }
            }
            catch (IOException e) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "find(pckgname, recursive, classes)", "Exception", e);
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, this.getClass().toString(), "find(pckgname, recursive, classes)", "Exception", e);
            }
        }
        return classes;
    }

    private Class load(String name) {
        if (name.endsWith(".class") && name.indexOf("Test") >= 0 && name.indexOf(36) < 0) {
            String classname = name.substring(0, name.length() - ".class".length());
            if (classname.startsWith("/")) {
                classname = classname.substring(1);
            }
            classname = classname.replace('/', '.');
            try {
                Class<?> cls = Class.forName(classname);
                cls.getMethod("main", String[].class);
                if (!this.getClass().equals(cls)) {
                    return cls;
                }
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (UnsupportedClassVersionError e) {
                return null;
            }
        }
        return null;
    }

    private void addAllFilesInDirectory(File directory, Collection<Class> allClasses, String packageName, boolean recursive) {
        File[] files = directory.listFiles(this.getFileFilter());
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (!recursive) continue;
                    this.addAllFilesInDirectory(files[i], allClasses, packageName + files[i].getName() + ".", true);
                    continue;
                }
                Class result = this.load(packageName + files[i].getName());
                if (result == null || allClasses.contains(result)) continue;
                allClasses.add(result);
            }
        }
    }

    private FileFilter getFileFilter() {
        return new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory() && !pathname.getName().startsWith(".") || pathname.getName().endsWith(".class") && pathname.getName().indexOf("Test") >= 0 && pathname.getName().indexOf(36) < 0;
            }
        };
    }

    private void startApp(final Object[] appClass) {
        if (appClass == null) {
            JOptionPane.showMessageDialog(this.rootPane, "Please select a test from the list", "Error", 0);
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                for (int i = 0; i < appClass.length; ++i) {
                    Class clazz = (Class)appClass[i];
                    try {
                        Method mainMethod;
                        Object app = clazz.newInstance();
                        if (app instanceof Application) {
                            if (app instanceof SimpleApplication) {
                                Method settingMethod = clazz.getMethod("setShowSettings", Boolean.TYPE);
                                settingMethod.invoke(app, TestChooser.this.showSetting);
                            }
                            mainMethod = clazz.getMethod("start", new Class[0]);
                            mainMethod.invoke(app, new Object[0]);
                            Field contextField = Application.class.getDeclaredField("context");
                            contextField.setAccessible(true);
                            JmeContext context = null;
                            while (context == null) {
                                context = (JmeContext)contextField.get(app);
                                Thread.sleep(100L);
                            }
                            while (!context.isCreated()) {
                                Thread.sleep(100L);
                            }
                            while (context.isCreated()) {
                                Thread.sleep(100L);
                            }
                        } else {
                            mainMethod = clazz.getMethod("main", new String[0].getClass());
                            mainMethod.invoke(app, new Object[]{new String[0]});
                        }
                        System.gc();
                        continue;
                    }
                    catch (IllegalAccessException ex) {
                        logger.log(Level.SEVERE, "Cannot access constructor: " + clazz.getName(), ex);
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        logger.log(Level.SEVERE, "main() had illegal argument: " + clazz.getName(), ex);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        logger.log(Level.SEVERE, "main() method had exception: " + clazz.getName(), ex);
                        continue;
                    }
                    catch (InstantiationException ex) {
                        logger.log(Level.SEVERE, "Failed to create app: " + clazz.getName(), ex);
                        continue;
                    }
                    catch (NoSuchMethodException ex) {
                        logger.log(Level.SEVERE, "Test class doesn't have main method: " + clazz.getName(), ex);
                        continue;
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, "Cannot start test: " + clazz.getName(), ex);
                        ex.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private void setup(Vector<Class> classes) {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mainPanel, "Center");
        mainPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        final FilteredJList list = new FilteredJList();
        list.setSelectionMode(2);
        DefaultListModel<Class> model = new DefaultListModel<Class>();
        for (Class c : classes) {
            model.addElement(c);
        }
        list.setModel((ListModel)model);
        mainPanel.add((Component)this.createSearchPanel(list), "North");
        mainPanel.add((Component)new JScrollPane(list), "Center");
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TestChooser.access$302(TestChooser.this, list.getSelectedValues());
            }
        });
        list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && TestChooser.this.selectedClass != null) {
                    TestChooser.this.startApp(TestChooser.this.selectedClass);
                }
            }
        });
        list.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TestChooser.this.startApp(TestChooser.this.selectedClass);
                } else if (e.getKeyCode() == 27) {
                    TestChooser.this.dispose();
                }
            }
        });
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        mainPanel.add((Component)buttonPanel, "Last");
        JButton okButton = new JButton("Ok");
        okButton.setMnemonic('O');
        buttonPanel.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestChooser.this.startApp(TestChooser.this.selectedClass);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic('C');
        buttonPanel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestChooser.this.dispose();
            }
        });
        this.pack();
        this.center();
    }

    private void center() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new TestChooser().start(args);
    }

    protected void start(String[] args) {
        Vector<Class> classes = new Vector<Class>();
        logger.info("Composing Test list...");
        this.addDisplayedClasses(classes);
        this.setup(classes);
        this.setVisible(true);
    }

    protected void addDisplayedClasses(Vector<Class> classes) {
        this.find("jme3test", true, classes);
    }

    private JPanel createSearchPanel(final FilteredJList classes) {
        JPanel search = new JPanel();
        search.setLayout(new BorderLayout());
        search.add((Component)new JLabel("Choose a Demo to start:      Find: "), "West");
        final JTextField jtf = new JTextField();
        jtf.getDocument().addDocumentListener(new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                classes.setFilter(jtf.getText());
            }

            public void insertUpdate(DocumentEvent e) {
                classes.setFilter(jtf.getText());
            }

            public void changedUpdate(DocumentEvent e) {
                classes.setFilter(jtf.getText());
            }
        });
        jtf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestChooser.access$302(TestChooser.this, classes.getSelectedValues());
                TestChooser.this.startApp(TestChooser.this.selectedClass);
            }
        });
        final JCheckBox showSettingCheck = new JCheckBox("Show Setting");
        showSettingCheck.setSelected(true);
        showSettingCheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestChooser.this.showSetting = showSettingCheck.isSelected();
            }
        });
        jtf.setPreferredSize(new Dimension(100, 25));
        search.add((Component)jtf, "Center");
        search.add((Component)showSettingCheck, "East");
        return search;
    }

    static /* synthetic */ Object[] access$302(TestChooser x0, Object[] x1) {
        x0.selectedClass = x1;
        return x1;
    }

    private class FilteredJList
    extends JList {
        private static final long serialVersionUID = 1L;
        private String filter;
        private ListModel originalModel;

        private FilteredJList() {
        }

        public void setModel(ListModel m) {
            this.originalModel = m;
            super.setModel(m);
        }

        private void update() {
            if (this.filter == null || this.filter.length() == 0) {
                super.setModel(this.originalModel);
            }
            DefaultListModel v = new DefaultListModel();
            for (int i = 0; i < this.originalModel.getSize(); ++i) {
                Object o = this.originalModel.getElementAt(i);
                String s = String.valueOf(o).toLowerCase();
                if (!s.contains(this.filter)) continue;
                v.addElement(o);
            }
            super.setModel(v);
            if (v.getSize() == 1) {
                this.setSelectedIndex(0);
            }
            this.revalidate();
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter.toLowerCase();
            this.update();
        }
    }
}

