/*
 * Decompiled with CFR 0.152.
 */
package jme3tools.converters.model.strip;

import java.util.Arrays;

class VertexCache {
    int[] entries;
    int numEntries;

    public VertexCache() {
        this(16);
    }

    public VertexCache(int size) {
        this.numEntries = size;
        this.entries = new int[this.numEntries];
        this.clear();
    }

    public boolean inCache(int entry) {
        for (int i = 0; i < this.numEntries; ++i) {
            if (this.entries[i] != entry) continue;
            return true;
        }
        return false;
    }

    public int addEntry(int entry) {
        int removed = this.entries[this.numEntries - 1];
        for (int i = this.numEntries - 2; i >= 0; --i) {
            this.entries[i + 1] = this.entries[i];
        }
        this.entries[0] = entry;
        return removed;
    }

    public void clear() {
        Arrays.fill(this.entries, -1);
    }

    public int at(int index) {
        return this.entries[index];
    }

    public void set(int index, int value) {
        this.entries[index] = value;
    }

    public void copy(VertexCache inVcache) {
        for (int i = 0; i < this.numEntries; ++i) {
            inVcache.set(i, this.entries[i]);
        }
    }
}

