/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.system.Timer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.Sys;

public class LwjglTimer
extends Timer {
    private static final Logger logger = Logger.getLogger(LwjglTimer.class.getName());
    private long lastFrameDiff;
    private long oldTime;
    private float lastTPF;
    private float lastFPS;
    public static int TIMER_SMOOTHNESS = 32;
    private long[] tpf;
    private int smoothIndex;
    private static final long LWJGL_TIMER_RES = Sys.getTimerResolution();
    private static final float INV_LWJGL_TIMER_RES = 1.0f / (float)LWJGL_TIMER_RES;
    private static float invTimerRezSmooth;
    public static final long LWJGL_TIME_TO_NANOS;
    private long startTime;
    private boolean allSmooth = false;

    public LwjglTimer() {
        this.reset();
        logger.log(Level.INFO, "Timer resolution: {0} ticks per second", LWJGL_TIMER_RES);
    }

    public void reset() {
        this.lastFrameDiff = 0L;
        this.lastFPS = 0.0f;
        this.lastTPF = 0.0f;
        this.oldTime = -1L;
        this.startTime = Sys.getTime();
        this.tpf = new long[TIMER_SMOOTHNESS];
        this.smoothIndex = TIMER_SMOOTHNESS - 1;
        invTimerRezSmooth = 1.0f / (float)(LWJGL_TIMER_RES * (long)TIMER_SMOOTHNESS);
        int i = this.tpf.length;
        while (--i >= 0) {
            this.tpf[i] = -1L;
        }
    }

    public long getTime() {
        return Sys.getTime() - this.startTime;
    }

    public long getResolution() {
        return LWJGL_TIMER_RES;
    }

    public float getFrameRate() {
        return this.lastFPS;
    }

    public float getTimePerFrame() {
        return this.lastTPF;
    }

    public void update() {
        long newTime = Sys.getTime();
        long oldTime = this.oldTime;
        this.oldTime = newTime;
        if (oldTime == -1L) {
            this.lastTPF = 0.016666668f;
            this.lastFPS = 1.0f / this.lastTPF;
            return;
        }
        long frameDiff = newTime - oldTime;
        long lastFrameDiff = this.lastFrameDiff;
        if (lastFrameDiff > 0L && frameDiff > lastFrameDiff * 100L) {
            frameDiff = lastFrameDiff * 100L;
        }
        this.lastFrameDiff = frameDiff;
        this.tpf[this.smoothIndex] = frameDiff;
        --this.smoothIndex;
        if (this.smoothIndex < 0) {
            this.smoothIndex = this.tpf.length - 1;
        }
        this.lastTPF = 0.0f;
        if (!this.allSmooth) {
            int smoothCount = 0;
            int i = this.tpf.length;
            while (--i >= 0) {
                if (this.tpf[i] == -1L) continue;
                this.lastTPF += (float)this.tpf[i];
                ++smoothCount;
            }
            if (smoothCount == this.tpf.length) {
                this.allSmooth = true;
            }
            this.lastTPF *= INV_LWJGL_TIMER_RES / (float)smoothCount;
        } else {
            int i = this.tpf.length;
            while (--i >= 0) {
                if (this.tpf[i] == -1L) continue;
                this.lastTPF += (float)this.tpf[i];
            }
            this.lastTPF *= invTimerRezSmooth;
        }
        if (this.lastTPF < 1.1920929E-7f) {
            this.lastTPF = 1.1920929E-7f;
        }
        this.lastFPS = 1.0f / this.lastTPF;
    }

    public String toString() {
        String string2 = super.toString();
        string2 = string2 + "\nTime: " + this.oldTime;
        string2 = string2 + "\nFPS: " + this.getFrameRate();
        return string2;
    }

    static {
        LWJGL_TIME_TO_NANOS = 1000000000L / LWJGL_TIMER_RES;
    }
}

