/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.system.lwjgl;

import com.jme3.input.lwjgl.JInputJoyInput;
import com.jme3.input.lwjgl.LwjglKeyInput;
import com.jme3.input.lwjgl.LwjglMouseInput;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.lwjgl.LwjglGL1Renderer;
import com.jme3.renderer.lwjgl.LwjglRenderer;
import com.jme3.system.AppSettings;
import com.jme3.system.JmeContext;
import com.jme3.system.SystemListener;
import com.jme3.system.Timer;
import com.jme3.system.lwjgl.LwjglTimer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public abstract class LwjglContext
implements JmeContext {
    private static final Logger logger = Logger.getLogger(LwjglContext.class.getName());
    protected AtomicBoolean created = new AtomicBoolean(false);
    protected AtomicBoolean renderable = new AtomicBoolean(false);
    protected final Object createdLock = new Object();
    protected AppSettings settings = new AppSettings(true);
    protected Renderer renderer;
    protected LwjglKeyInput keyInput;
    protected LwjglMouseInput mouseInput;
    protected JInputJoyInput joyInput;
    protected Timer timer;
    protected SystemListener listener;

    public void setSystemListener(SystemListener listener) {
        this.listener = listener;
    }

    protected void printContextInitInfo() {
        logger.log(Level.FINE, "Running on thread: {0}", Thread.currentThread().getName());
        logger.log(Level.INFO, "Adapter: {0}", Display.getAdapter());
        logger.log(Level.INFO, "Driver Version: {0}", Display.getVersion());
        String vendor = GL11.glGetString((int)7936);
        logger.log(Level.INFO, "Vendor: {0}", vendor);
        String version = GL11.glGetString((int)7938);
        logger.log(Level.INFO, "OpenGL Version: {0}", version);
        String renderGl = GL11.glGetString((int)7937);
        logger.log(Level.INFO, "Renderer: {0}", renderGl);
        if (GLContext.getCapabilities().OpenGL20) {
            String shadingLang = GL11.glGetString((int)35724);
            logger.log(Level.INFO, "GLSL Ver: {0}", shadingLang);
        }
    }

    protected ContextAttribs createContextAttribs() {
        if (this.settings.getBoolean("GraphicsDebug") || this.settings.getRenderer().equals("LWJGL-OpenGL3")) {
            ContextAttribs attr2;
            if (this.settings.getRenderer().equals("LWJGL-OpenGL3")) {
                attr2 = new ContextAttribs(3, 3);
                attr2 = attr2.withProfileCore(true).withForwardCompatible(true).withProfileCompatibility(false);
            } else {
                attr2 = new ContextAttribs();
            }
            if (this.settings.getBoolean("GraphicsDebug")) {
                attr2 = attr2.withDebug(true);
            }
            return attr2;
        }
        return null;
    }

    protected void initContextFirstTime() {
        if (this.settings.getRenderer().equals("LWJGL-OpenGL2") || this.settings.getRenderer().equals("LWJGL-OpenGL3")) {
            this.renderer = new LwjglRenderer();
        } else if (this.settings.getRenderer().equals("LWJGL-OPENGL1")) {
            this.renderer = new LwjglGL1Renderer();
        } else if (this.settings.getRenderer().equals("LWJGL-OpenGL-Any")) {
            this.renderer = GLContext.getCapabilities().OpenGL20 ? new LwjglRenderer() : new LwjglGL1Renderer();
        } else {
            throw new UnsupportedOperationException("Unsupported renderer: " + this.settings.getRenderer());
        }
        if (this.renderer instanceof LwjglRenderer) {
            ((LwjglRenderer)this.renderer).initialize();
        } else if (this.renderer instanceof LwjglGL1Renderer) {
            ((LwjglGL1Renderer)this.renderer).initialize();
        } else assert (false);
        if (this.keyInput != null) {
            this.keyInput.initialize();
        }
        if (this.mouseInput != null) {
            this.mouseInput.initialize();
        }
        if (this.joyInput != null) {
            this.joyInput.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalDestroy() {
        this.renderer = null;
        this.timer = null;
        this.renderable.set(false);
        Object object = this.createdLock;
        synchronized (object) {
            this.created.set(false);
            this.createdLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalCreate() {
        this.timer = new LwjglTimer();
        Object object = this.createdLock;
        synchronized (object) {
            this.created.set(true);
            this.createdLock.notifyAll();
        }
        if (this.renderable.get()) {
            this.initContextFirstTime();
        } else assert (this.getType() == JmeContext.Type.Canvas);
    }

    public void create() {
        this.create(false);
    }

    public void destroy() {
        this.destroy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitFor(boolean createdVal) {
        Object object = this.createdLock;
        synchronized (object) {
            while (this.created.get() != createdVal) {
                try {
                    this.createdLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isCreated() {
        return this.created.get();
    }

    public boolean isRenderable() {
        return this.renderable.get();
    }

    public void setSettings(AppSettings settings) {
        this.settings.copyFrom(settings);
    }

    public AppSettings getSettings() {
        return this.settings;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public Timer getTimer() {
        return this.timer;
    }
}

