/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures;

import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.textures.NoiseGenerator;
import com.jme3.scene.plugins.blender.textures.TextureGenerator;
import com.jme3.scene.plugins.blender.textures.TextureHelper;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture3D;
import com.jme3.util.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class TextureGeneratorDistnoise
extends TextureGenerator {
    public TextureGeneratorDistnoise(NoiseGenerator noiseGenerator) {
        super(noiseGenerator);
    }

    protected Texture generate(Structure tex, int width, int height, int depth, DataRepository dataRepository) {
        float noisesize = ((Number)tex.getFieldValue("noisesize")).floatValue();
        float nabla = ((Number)tex.getFieldValue("nabla")).floatValue();
        float distAmount = ((Number)tex.getFieldValue("dist_amount")).floatValue();
        int noisebasis = ((Number)tex.getFieldValue("noisebasis")).intValue();
        int noisebasis2 = ((Number)tex.getFieldValue("noisebasis2")).intValue();
        float contrast = ((Number)tex.getFieldValue("contrast")).floatValue();
        float brightness = ((Number)tex.getFieldValue("bright")).floatValue();
        TextureHelper.TexResult texres = new TextureHelper.TexResult();
        float[] texvec = new float[]{0.0f, 0.0f, 0.0f};
        float wDelta = 1.0f / (float)width;
        float hDelta = 1.0f / (float)height;
        float dDelta = 1.0f / (float)depth;
        int halfW = width;
        int halfH = height;
        int halfD = depth;
        TextureHelper.ColorBand colorBand = this.readColorband(tex, dataRepository);
        Image.Format format = colorBand != null ? Image.Format.RGB8 : Image.Format.Luminance8;
        int bytesPerPixel = colorBand != null ? 3 : 1;
        ByteBuffer data = BufferUtils.createByteBuffer((width <<= 1) * (height <<= 1) * (depth <<= 1) * bytesPerPixel);
        for (int i = -halfW; i < halfW; ++i) {
            texvec[0] = wDelta * (float)i / noisesize;
            for (int j = -halfH; j < halfH; ++j) {
                texvec[1] = hDelta * (float)j / noisesize;
                for (int k = -halfD; k < halfD; ++k) {
                    texvec[2] = dDelta * (float)k;
                    texres.tin = this.noiseGenerator.mgVLNoise(texvec[0], texvec[1], texvec[2], distAmount, noisebasis, noisebasis2);
                    if (colorBand != null) {
                        this.noiseGenerator.doColorband(colorBand, texres, dataRepository);
                        if (texres.nor != null) {
                            float offs = nabla / noisesize;
                            texres.nor[0] = this.noiseGenerator.mgVLNoise(texvec[0] + offs, texvec[1], texvec[2], distAmount, noisebasis, noisebasis2);
                            texres.nor[1] = this.noiseGenerator.mgVLNoise(texvec[0], texvec[1] + offs, texvec[2], distAmount, noisebasis, noisebasis2);
                            texres.nor[2] = this.noiseGenerator.mgVLNoise(texvec[0], texvec[1], texvec[2] + offs, distAmount, noisebasis, noisebasis2);
                            this.noiseGenerator.texNormalDerivate(colorBand, texres, dataRepository);
                        }
                        this.noiseGenerator.brightnesAndContrastRGB(tex, texres);
                        data.put((byte)(texres.tr * 255.0f));
                        data.put((byte)(texres.tg * 255.0f));
                        data.put((byte)(texres.tb * 255.0f));
                        continue;
                    }
                    this.noiseGenerator.brightnesAndContrast(texres, contrast, brightness);
                    data.put((byte)(texres.tin * 255.0f));
                }
            }
        }
        ArrayList<ByteBuffer> dataArray = new ArrayList<ByteBuffer>(1);
        dataArray.add(data);
        return new Texture3D(new Image(format, width, height, depth, dataArray));
    }
}

