/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.BoneAnimation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.math.Quaternion;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.animations.Ipo;
import com.jme3.scene.plugins.blender.constraints.Constraint;
import com.jme3.scene.plugins.blender.constraints.ConstraintType;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;

class ConstraintRotLike
extends Constraint {
    private static final int ROTLIKE_X = 1;
    private static final int ROTLIKE_Y = 2;
    private static final int ROTLIKE_Z = 4;
    private static final int ROTLIKE_X_INVERT = 16;
    private static final int ROTLIKE_Y_INVERT = 32;
    private static final int ROTLIKE_Z_INVERT = 64;
    private static final int ROTLIKE_OFFSET = 128;

    public ConstraintRotLike(Structure constraintStructure, Long boneOMA, Ipo influenceIpo, DataRepository dataRepository) throws BlenderFileException {
        super(constraintStructure, boneOMA, influenceIpo, dataRepository);
    }

    public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation) {
        BoneTrack boneTrack = this.getBoneTrack(skeleton, boneAnimation);
        if (boneTrack != null) {
            Quaternion targetRotation = this.getTargetRotation();
            int flag = ((Number)this.data.getFieldValue("flag")).intValue();
            float[] targetAngles = targetRotation.toAngles(null);
            Quaternion[] rotations = boneTrack.getRotations();
            int maxFrames = rotations.length;
            for (int frame = 0; frame < maxFrames; ++frame) {
                float[] angles = rotations[frame].toAngles(null);
                Quaternion offset = Quaternion.IDENTITY;
                if ((flag & 0x80) != 0) {
                    offset = rotations[frame].clone();
                }
                if ((flag & 1) != 0) {
                    angles[0] = targetAngles[0];
                    if ((flag & 0x10) != 0) {
                        angles[0] = -angles[0];
                    }
                } else if ((flag & 2) != 0) {
                    angles[1] = targetAngles[1];
                    if ((flag & 0x20) != 0) {
                        angles[1] = -angles[1];
                    }
                } else if ((flag & 4) != 0) {
                    angles[2] = targetAngles[2];
                    if ((flag & 0x40) != 0) {
                        angles[2] = -angles[2];
                    }
                }
                rotations[frame].fromAngles(angles).multLocal(offset);
            }
            boneTrack.setKeyframes(boneTrack.getTimes(), boneTrack.getTranslations(), rotations, boneTrack.getScales());
        }
    }

    public ConstraintType getType() {
        return ConstraintType.CONSTRAINT_TYPE_ROTLIKE;
    }
}

