/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.cameras;

import com.jme3.renderer.Camera;
import com.jme3.scene.plugins.blender.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Structure;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CameraHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(CameraHelper.class.getName());
    protected static final int DEFAULT_CAM_WIDTH = 100;
    protected static final int DEFAULT_CAM_HEIGHT = 100;

    public CameraHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public Camera toCamera(Structure structure) throws BlenderFileException {
        if (this.blenderVersion >= 250) {
            return this.toCamera250(structure);
        }
        return this.toCamera249(structure);
    }

    public Camera toCamera250(Structure structure) throws BlenderFileException {
        Camera result = new Camera(100, 100);
        int type = ((Number)structure.getFieldValue("type")).intValue();
        if (type != 0 && type != 1) {
            LOGGER.log(Level.WARNING, "Unknown camera type: {0}. Perspective camera is being used!", type);
            type = 0;
        }
        result.setParallelProjection(type == 1);
        float aspect = 0.0f;
        float clipsta = ((Number)structure.getFieldValue("clipsta")).floatValue();
        float clipend = ((Number)structure.getFieldValue("clipend")).floatValue();
        aspect = type == 0 ? ((Number)structure.getFieldValue("lens")).floatValue() : ((Number)structure.getFieldValue("ortho_scale")).floatValue();
        result.setFrustumPerspective(45.0f, aspect, clipsta, clipend);
        return result;
    }

    public Camera toCamera249(Structure structure) throws BlenderFileException {
        Camera result = new Camera(100, 100);
        int type = ((Number)structure.getFieldValue("type")).intValue();
        if (type != 0 && type != 1) {
            LOGGER.log(Level.WARNING, "Unknown camera type: {0}. Perspective camera is being used!", type);
            type = 0;
        }
        result.setParallelProjection(type == 1);
        float angle = ((Number)structure.getFieldValue("angle")).floatValue();
        float aspect = 0.0f;
        float clipsta = ((Number)structure.getFieldValue("clipsta")).floatValue();
        float clipend = ((Number)structure.getFieldValue("clipend")).floatValue();
        aspect = type == 0 ? ((Number)structure.getFieldValue("lens")).floatValue() : ((Number)structure.getFieldValue("ortho_scale")).floatValue();
        result.setFrustumPerspective(angle, aspect, clipsta, clipend);
        return result;
    }

    public boolean shouldBeLoaded(Structure structure, DataRepository dataRepository) {
        return (dataRepository.getBlenderKey().getFeaturesToLoad() & 0x20) != 0;
    }
}

