/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.renderer.android;

import android.graphics.Bitmap;
import android.opengl.GLES10;
import android.opengl.GLES11;
import android.opengl.GLES20;
import com.jme3.light.LightList;
import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Caps;
import com.jme3.renderer.GLObjectManager;
import com.jme3.renderer.IDList;
import com.jme3.renderer.RenderContext;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.RendererException;
import com.jme3.renderer.Statistics;
import com.jme3.renderer.android.TextureUtil;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.shader.Attribute;
import com.jme3.shader.Shader;
import com.jme3.shader.Uniform;
import com.jme3.texture.FrameBuffer;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import com.jme3.util.IntMap;
import com.jme3.util.ListMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OGLESShaderRenderer
implements Renderer {
    private static final Logger logger = Logger.getLogger(OGLESShaderRenderer.class.getName());
    private static final boolean VALIDATE_SHADER = false;
    private final ByteBuffer nameBuf = BufferUtils.createByteBuffer(250);
    private final StringBuilder stringBuf = new StringBuilder(250);
    private final IntBuffer intBuf1 = BufferUtils.createIntBuffer(1);
    private final IntBuffer intBuf16 = BufferUtils.createIntBuffer(16);
    private final RenderContext context = new RenderContext();
    private final GLObjectManager objManager = new GLObjectManager();
    private final EnumSet<Caps> caps = EnumSet.noneOf(Caps.class);
    private Shader boundShader;
    private int initialDrawBuf;
    private int initialReadBuf;
    private int glslVer;
    private int vertexTextureUnits;
    private int fragTextureUnits;
    private int vertexUniforms;
    private int fragUniforms;
    private int vertexAttribs;
    private int maxFBOSamples;
    private int maxFBOAttachs;
    private int maxMRTFBOAttachs;
    private int maxRBSize;
    private int maxTexSize;
    private int maxCubeTexSize;
    private int maxVertCount;
    private int maxTriCount;
    private boolean tdc;
    private FrameBuffer lastFb = null;
    private final Statistics statistics = new Statistics();
    private int vpX;
    private int vpY;
    private int vpW;
    private int vpH;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private boolean powerOf2 = false;
    private boolean verboseLogging = false;
    private boolean useVBO = false;

    public void setUseVA(boolean value) {
        logger.log(Level.INFO, "use_VBO [{0}] -> [{1}]", new Object[]{this.useVBO, !value});
        this.useVBO = !value;
    }

    public void setVerboseLogging(boolean value) {
        logger.log(Level.INFO, "verboseLogging [{0}] -> [{1}]", new Object[]{this.verboseLogging, value});
        this.verboseLogging = value;
    }

    protected void updateNameBuffer() {
        int len = this.stringBuf.length();
        this.nameBuf.position(0);
        this.nameBuf.limit(len);
        for (int i = 0; i < len; ++i) {
            this.nameBuf.put((byte)this.stringBuf.charAt(i));
        }
        this.nameBuf.rewind();
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public EnumSet<Caps> getCaps() {
        return this.caps;
    }

    public void initialize() {
        logger.info("Vendor: " + GLES20.glGetString((int)7936));
        logger.info("Renderer: " + GLES20.glGetString((int)7937));
        logger.info("Version: " + GLES20.glGetString((int)7938));
        String shadingLanguageVersion = GLES20.glGetString((int)35724);
        logger.log(Level.INFO, "GLES20.Shading Language Version: {0}", shadingLanguageVersion);
        String versionStr = GLES20.glGetString((int)35724);
        if (versionStr == null || versionStr.equals("")) {
            this.glslVer = -1;
            throw new UnsupportedOperationException("GLSL and OpenGL2 is required for the LWJGL renderer!");
        }
        int spaceIdx = versionStr.lastIndexOf(" ");
        if (spaceIdx >= 1) {
            versionStr = versionStr.substring(spaceIdx, versionStr.length());
        }
        float version = Float.parseFloat(versionStr);
        this.glslVer = (int)(version * 100.0f);
        switch (this.glslVer) {
            default: {
                if (this.glslVer < 400) break;
            }
            case 150: 
            case 330: 
            case 400: {
                this.caps.add(Caps.GLSL150);
            }
            case 140: {
                this.caps.add(Caps.GLSL140);
            }
            case 130: {
                this.caps.add(Caps.GLSL130);
            }
            case 120: {
                this.caps.add(Caps.GLSL120);
            }
            case 110: {
                this.caps.add(Caps.GLSL110);
            }
            case 100: {
                this.caps.add(Caps.GLSL100);
            }
        }
        if (!this.caps.contains((Object)Caps.GLSL100)) {
            logger.info("Force-adding GLSL100 support, since OpenGL is supported.");
            this.caps.add(Caps.GLSL100);
        }
        GLES20.glGetIntegerv((int)35660, (IntBuffer)this.intBuf16);
        this.vertexTextureUnits = this.intBuf16.get(0);
        logger.log(Level.INFO, "VTF Units: {0}", this.vertexTextureUnits);
        if (this.vertexTextureUnits > 0) {
            this.caps.add(Caps.VertexTextureFetch);
        }
        GLES20.glGetIntegerv((int)34930, (IntBuffer)this.intBuf16);
        this.fragTextureUnits = this.intBuf16.get(0);
        logger.log(Level.INFO, "Texture Units: {0}", this.fragTextureUnits);
        GLES20.glGetIntegerv((int)34921, (IntBuffer)this.intBuf16);
        this.vertexAttribs = this.intBuf16.get(0);
        logger.log(Level.INFO, "Vertex Attributes: {0}", this.vertexAttribs);
        GLES20.glGetIntegerv((int)3408, (IntBuffer)this.intBuf16);
        int subpixelBits = this.intBuf16.get(0);
        logger.log(Level.INFO, "Subpixel Bits: {0}", subpixelBits);
        GLES20.glGetIntegerv((int)3379, (IntBuffer)this.intBuf16);
        this.maxTexSize = this.intBuf16.get(0);
        logger.log(Level.INFO, "Maximum Texture Resolution: {0}", this.maxTexSize);
        GLES20.glGetIntegerv((int)34076, (IntBuffer)this.intBuf16);
        this.maxCubeTexSize = this.intBuf16.get(0);
        logger.log(Level.INFO, "Maximum CubeMap Resolution: {0}", this.maxCubeTexSize);
        String extensions = GLES20.glGetString((int)7939);
        logger.log(Level.INFO, "GL_EXTENSIONS: {0}", extensions);
        GLES20.glGetIntegerv((int)34467, (IntBuffer)this.intBuf16);
        for (int i = 0; i < this.intBuf16.limit(); ++i) {
            logger.log(Level.INFO, "Compressed Texture Formats: {0}", this.intBuf16.get(i));
        }
        if (extensions.contains("GL_OES_texture_npot")) {
            this.powerOf2 = true;
        }
        this.applyRenderState(RenderState.DEFAULT);
        if (this.verboseLogging) {
            logger.info("GLES20.glDisable(GL10.GL_DITHER)");
        }
        GLES20.glDisable((int)3024);
        this.checkGLError();
        if (this.verboseLogging) {
            logger.info("GLES20.glHint(GL10.GL_PERSPECTIVE_CORRECTION_HINT, GL10.GL_FASTEST)");
        }
        GLES20.glHint((int)3152, (int)4353);
        logger.log(Level.INFO, "Caps: {0}", this.caps);
    }

    @Override
    public void resetGLObjects() {
        this.objManager.resetObjects();
        this.statistics.clearMemory();
        this.boundShader = null;
        this.lastFb = null;
        this.context.reset();
    }

    @Override
    public void cleanup() {
        this.objManager.deleteAllObjects(this);
        this.statistics.clearMemory();
    }

    private void checkCap(Caps cap) {
        if (!this.caps.contains((Object)cap)) {
            throw new UnsupportedOperationException("Required capability missing: " + cap.name());
        }
    }

    @Override
    public void setDepthRange(float start, float end) {
        if (this.verboseLogging) {
            logger.log(Level.INFO, "GLES20.glDepthRangef({0}, {1})", new Object[]{Float.valueOf(start), Float.valueOf(end)});
        }
        GLES20.glDepthRangef((float)start, (float)end);
        this.checkGLError();
    }

    @Override
    public void clearBuffers(boolean color, boolean depth, boolean stencil) {
        int bits = 0;
        if (color) {
            bits = 16384;
        }
        if (depth) {
            bits |= 0x100;
        }
        if (stencil) {
            bits |= 0x400;
        }
        if (bits != 0) {
            if (this.verboseLogging) {
                logger.log(Level.INFO, "GLES20.glClear(color={0}, depth={1}, stencil={2})", new Object[]{color, depth, stencil});
            }
            GLES20.glClear((int)bits);
            this.checkGLError();
        }
    }

    @Override
    public void setBackgroundColor(ColorRGBA color) {
        if (this.verboseLogging) {
            logger.log(Level.INFO, "GLES20.glClearColor({0}, {1}, {2}, {3})", new Object[]{Float.valueOf(color.r), Float.valueOf(color.g), Float.valueOf(color.b), Float.valueOf(color.a)});
        }
        GLES20.glClearColor((float)color.r, (float)color.g, (float)color.b, (float)color.a);
        this.checkGLError();
    }

    @Override
    public void applyRenderState(RenderState state) {
        if (state.isDepthTest() && !this.context.depthTestEnabled) {
            if (this.verboseLogging) {
                logger.info("GLES20.glEnable(GLES20.GL_DEPTH_TEST)");
            }
            GLES20.glEnable((int)2929);
            this.checkGLError();
            if (this.verboseLogging) {
                logger.info("GLES20.glDepthFunc(GLES20.GL_LEQUAL)");
            }
            GLES20.glDepthFunc((int)515);
            this.checkGLError();
            this.context.depthTestEnabled = true;
        } else if (!state.isDepthTest() && this.context.depthTestEnabled) {
            if (this.verboseLogging) {
                logger.info("GLES20.glDisable(GLES20.GL_DEPTH_TEST)");
            }
            GLES20.glDisable((int)2929);
            this.checkGLError();
            this.context.depthTestEnabled = false;
        }
        if (state.isAlphaTest() && !this.context.alphaTestEnabled) {
            this.context.alphaTestEnabled = true;
        } else if (!state.isAlphaTest() && this.context.alphaTestEnabled) {
            this.context.alphaTestEnabled = false;
        }
        if (state.isDepthWrite() && !this.context.depthWriteEnabled) {
            if (this.verboseLogging) {
                logger.info("GLES20.glDepthMask(true)");
            }
            GLES20.glDepthMask((boolean)true);
            this.checkGLError();
            this.context.depthWriteEnabled = true;
        } else if (!state.isDepthWrite() && this.context.depthWriteEnabled) {
            if (this.verboseLogging) {
                logger.info("GLES20.glDepthMask(false)");
            }
            GLES20.glDepthMask((boolean)false);
            this.checkGLError();
            this.context.depthWriteEnabled = false;
        }
        if (state.isColorWrite() && !this.context.colorWriteEnabled) {
            if (this.verboseLogging) {
                logger.info("GLES20.glColorMask(true, true, true, true)");
            }
            GLES20.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            this.checkGLError();
            this.context.colorWriteEnabled = true;
        } else if (!state.isColorWrite() && this.context.colorWriteEnabled) {
            if (this.verboseLogging) {
                logger.info("GLES20.glColorMask(false, false, false, false)");
            }
            GLES20.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            this.checkGLError();
            this.context.colorWriteEnabled = false;
        }
        if (state.isPointSprite() && !this.context.pointSprite || state.isPointSprite() || this.context.pointSprite) {
            // empty if block
        }
        if (state.isPolyOffset()) {
            if (!this.context.polyOffsetEnabled) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glEnable(GLES20.GL_POLYGON_OFFSET_FILL)");
                }
                GLES20.glEnable((int)32823);
                this.checkGLError();
                if (this.verboseLogging) {
                    logger.log(Level.INFO, "GLES20.glPolygonOffset({0}, {1})", new Object[]{Float.valueOf(state.getPolyOffsetFactor()), Float.valueOf(state.getPolyOffsetUnits())});
                }
                GLES20.glPolygonOffset((float)state.getPolyOffsetFactor(), (float)state.getPolyOffsetUnits());
                this.checkGLError();
                this.context.polyOffsetEnabled = true;
                this.context.polyOffsetFactor = state.getPolyOffsetFactor();
                this.context.polyOffsetUnits = state.getPolyOffsetUnits();
            } else if (state.getPolyOffsetFactor() != this.context.polyOffsetFactor || state.getPolyOffsetUnits() != this.context.polyOffsetUnits) {
                if (this.verboseLogging) {
                    logger.log(Level.INFO, "GLES20.glPolygonOffset({0}, {1})", new Object[]{Float.valueOf(state.getPolyOffsetFactor()), Float.valueOf(state.getPolyOffsetUnits())});
                }
                GLES20.glPolygonOffset((float)state.getPolyOffsetFactor(), (float)state.getPolyOffsetUnits());
                this.checkGLError();
                this.context.polyOffsetFactor = state.getPolyOffsetFactor();
                this.context.polyOffsetUnits = state.getPolyOffsetUnits();
            }
        } else if (this.context.polyOffsetEnabled) {
            if (this.verboseLogging) {
                logger.info("GLES20.glDisable(GLES20.GL_POLYGON_OFFSET_FILL)");
            }
            GLES20.glDisable((int)32823);
            this.checkGLError();
            this.context.polyOffsetEnabled = false;
            this.context.polyOffsetFactor = 0.0f;
            this.context.polyOffsetUnits = 0.0f;
        }
        if (state.getFaceCullMode() != this.context.cullMode) {
            if (state.getFaceCullMode() == RenderState.FaceCullMode.Off) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glDisable(GLES20.GL_CULL_FACE)");
                }
                GLES20.glDisable((int)2884);
            } else {
                if (this.verboseLogging) {
                    logger.info("GLES20.glEnable(GLES20.GL_CULL_FACE)");
                }
                GLES20.glEnable((int)2884);
            }
            this.checkGLError();
            switch (state.getFaceCullMode()) {
                case Off: {
                    break;
                }
                case Back: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glCullFace(GLES20.GL_BACK)");
                    }
                    GLES20.glCullFace((int)1029);
                    break;
                }
                case Front: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glCullFace(GLES20.GL_FRONT)");
                    }
                    GLES20.glCullFace((int)1028);
                    break;
                }
                case FrontAndBack: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glCullFace(GLES20.GL_FRONT_AND_BACK)");
                    }
                    GLES20.glCullFace((int)1032);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unrecognized face cull mode: " + (Object)((Object)state.getFaceCullMode()));
                }
            }
            this.checkGLError();
            this.context.cullMode = state.getFaceCullMode();
        }
        if (state.getBlendMode() != this.context.blendMode) {
            if (state.getBlendMode() == RenderState.BlendMode.Off) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glDisable(GLES20.GL_BLEND)");
                }
                GLES20.glDisable((int)3042);
            } else {
                if (this.verboseLogging) {
                    logger.info("GLES20.glEnable(GLES20.GL_BLEND)");
                }
                GLES20.glEnable((int)3042);
                switch (state.getBlendMode()) {
                    case Off: {
                        break;
                    }
                    case Additive: {
                        if (this.verboseLogging) {
                            logger.info("GLES20.glBlendFunc(GLES20.GL_ONE, GLES20.GL_ONE)");
                        }
                        GLES20.glBlendFunc((int)1, (int)1);
                        break;
                    }
                    case AlphaAdditive: {
                        if (this.verboseLogging) {
                            logger.info("GLES20.glBlendFunc(GLES20.GL_SRC_ALPHA, GLES20.GL_ONE)");
                        }
                        GLES20.glBlendFunc((int)770, (int)1);
                        break;
                    }
                    case Color: {
                        if (this.verboseLogging) {
                            logger.info("GLES20.glBlendFunc(GLES20.GL_ONE, GLES20.GL_ONE_MINUS_SRC_COLOR)");
                        }
                        GLES20.glBlendFunc((int)1, (int)769);
                        break;
                    }
                    case Alpha: {
                        if (this.verboseLogging) {
                            logger.info("GLES20.glBlendFunc(GLES20.GL_SRC_ALPHA, GLES20.GL_ONE_MINUS_SRC_ALPHA)");
                        }
                        GLES20.glBlendFunc((int)770, (int)771);
                        break;
                    }
                    case PremultAlpha: {
                        if (this.verboseLogging) {
                            logger.info("GLES20.glBlendFunc(GLES20.GL_ONE, GLES20.GL_ONE_MINUS_SRC_ALPHA)");
                        }
                        GLES20.glBlendFunc((int)1, (int)771);
                        break;
                    }
                    case Modulate: {
                        if (this.verboseLogging) {
                            logger.info("GLES20.glBlendFunc(GLES20.GL_DST_COLOR, GLES20.GL_ZERO)");
                        }
                        GLES20.glBlendFunc((int)774, (int)0);
                        break;
                    }
                    case ModulateX2: {
                        if (this.verboseLogging) {
                            logger.info("GLES20.glBlendFunc(GLES20.GL_DST_COLOR, GLES20.GL_SRC_COLOR)");
                        }
                        GLES20.glBlendFunc((int)774, (int)768);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unrecognized blend mode: " + (Object)((Object)state.getBlendMode()));
                    }
                }
            }
            this.checkGLError();
            this.context.blendMode = state.getBlendMode();
        }
    }

    @Override
    public void setViewPort(int x, int y, int w, int h) {
        if (x != this.vpX || this.vpY != y || this.vpW != w || this.vpH != h) {
            if (this.verboseLogging) {
                logger.log(Level.INFO, "GLES20.glViewport({0}, {1}, {2}, {3})", new Object[]{x, y, w, h});
            }
            GLES20.glViewport((int)x, (int)y, (int)w, (int)h);
            this.checkGLError();
            this.vpX = x;
            this.vpY = y;
            this.vpW = w;
            this.vpH = h;
        }
    }

    @Override
    public void setClipRect(int x, int y, int width, int height) {
        if (!this.context.clipRectEnabled) {
            if (this.verboseLogging) {
                logger.info("GLES20.glEnable(GLES20.GL_SCISSOR_TEST)");
            }
            GLES20.glEnable((int)3089);
            this.checkGLError();
            this.context.clipRectEnabled = true;
        }
        if (this.clipX != x || this.clipY != y || this.clipW != width || this.clipH != height) {
            if (this.verboseLogging) {
                logger.log(Level.INFO, "GLES20.glScissor({0}, {1}, {2}, {3})", new Object[]{x, y, width, height});
            }
            GLES20.glScissor((int)x, (int)y, (int)width, (int)height);
            this.clipX = x;
            this.clipY = y;
            this.clipW = width;
            this.clipH = height;
            this.checkGLError();
        }
    }

    @Override
    public void clearClipRect() {
        if (this.context.clipRectEnabled) {
            if (this.verboseLogging) {
                logger.info("GLES20.glDisable(GLES20.GL_SCISSOR_TEST)");
            }
            GLES20.glDisable((int)3089);
            this.checkGLError();
            this.context.clipRectEnabled = false;
            this.clipX = 0;
            this.clipY = 0;
            this.clipW = 0;
            this.clipH = 0;
        }
    }

    @Override
    public void onFrame() {
        this.objManager.deleteUnused(this);
    }

    @Override
    public void setWorldMatrix(Matrix4f worldMatrix) {
    }

    @Override
    public void setViewProjectionMatrices(Matrix4f viewMatrix, Matrix4f projMatrix) {
    }

    protected void updateUniformLocation(Shader shader, Uniform uniform) {
        this.stringBuf.setLength(0);
        this.stringBuf.append(uniform.getName()).append('\u0000');
        this.updateNameBuffer();
        if (this.verboseLogging) {
            logger.log(Level.INFO, "GLES20.glGetUniformLocation({0}, {1})", new Object[]{shader.getId(), uniform.getName()});
        }
        int loc = GLES20.glGetUniformLocation((int)shader.getId(), (String)uniform.getName());
        this.checkGLError();
        if (loc < 0) {
            uniform.setLocation(-1);
            if (this.verboseLogging) {
                logger.log(Level.WARNING, "Uniform [{0}] is not declared in shader.", uniform.getName());
            }
        } else {
            uniform.setLocation(loc);
        }
    }

    protected void updateUniform(Shader shader, Uniform uniform) {
        int shaderId = shader.getId();
        assert (uniform.getName() != null);
        assert (shader.getId() > 0);
        if (this.context.boundShaderProgram != shaderId) {
            if (this.verboseLogging) {
                logger.log(Level.INFO, "GLES20.glUseProgram({0})", shaderId);
            }
            GLES20.glUseProgram((int)shaderId);
            this.checkGLError();
            this.statistics.onShaderUse(shader, true);
            this.boundShader = shader;
            this.context.boundShaderProgram = shaderId;
        } else {
            this.statistics.onShaderUse(shader, false);
        }
        int loc = uniform.getLocation();
        if (loc == -1) {
            if (this.verboseLogging) {
                logger.log(Level.WARNING, "no location for uniform [{0}]", uniform.getName());
            }
            return;
        }
        if (loc == -2) {
            this.updateUniformLocation(shader, uniform);
            if (uniform.getLocation() == -1) {
                if (this.verboseLogging) {
                    logger.log(Level.WARNING, "not declared uniform: [{0}]", uniform.getName());
                }
                uniform.clearUpdateNeeded();
                return;
            }
            loc = uniform.getLocation();
        }
        if (uniform.getVarType() == null) {
            logger.warning("value is not set yet.");
            return;
        }
        this.statistics.onUniformSet();
        uniform.clearUpdateNeeded();
        switch (uniform.getVarType()) {
            case Float: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform1f set Float. " + uniform.getName());
                }
                Float f = (Float)uniform.getValue();
                GLES20.glUniform1f((int)loc, (float)f.floatValue());
                break;
            }
            case Vector2: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform2f set Vector2. " + uniform.getName());
                }
                Vector2f v2 = (Vector2f)uniform.getValue();
                GLES20.glUniform2f((int)loc, (float)v2.getX(), (float)v2.getY());
                break;
            }
            case Vector3: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform3f set Vector3. " + uniform.getName());
                }
                Vector3f v3 = (Vector3f)uniform.getValue();
                GLES20.glUniform3f((int)loc, (float)v3.getX(), (float)v3.getY(), (float)v3.getZ());
                break;
            }
            case Vector4: {
                Object val;
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform4f set Vector4." + uniform.getName());
                }
                if ((val = uniform.getValue()) instanceof ColorRGBA) {
                    ColorRGBA c = (ColorRGBA)val;
                    GLES20.glUniform4f((int)loc, (float)c.r, (float)c.g, (float)c.b, (float)c.a);
                    break;
                }
                Quaternion c = (Quaternion)uniform.getValue();
                GLES20.glUniform4f((int)loc, (float)c.getX(), (float)c.getY(), (float)c.getZ(), (float)c.getW());
                break;
            }
            case Boolean: {
                Boolean b;
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform1i set Boolean." + uniform.getName());
                }
                GLES20.glUniform1i((int)loc, (int)((b = (Boolean)uniform.getValue()) != false ? 1 : 0));
                break;
            }
            case Matrix3: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniformMatrix3fv set Matrix3." + uniform.getName());
                }
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                assert (fb.remaining() == 9);
                GLES20.glUniformMatrix3fv((int)loc, (int)1, (boolean)false, (FloatBuffer)fb);
                break;
            }
            case Matrix4: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniformMatrix4fv set Matrix4." + uniform.getName());
                }
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                assert (fb.remaining() == 16);
                GLES20.glUniformMatrix4fv((int)loc, (int)1, (boolean)false, (FloatBuffer)fb);
                break;
            }
            case FloatArray: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform1fv set FloatArray." + uniform.getName());
                }
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                GLES20.glUniform1fv((int)loc, (int)1, (FloatBuffer)fb);
                break;
            }
            case Vector2Array: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform2fv set Vector2Array." + uniform.getName());
                }
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                GLES20.glUniform2fv((int)loc, (int)1, (FloatBuffer)fb);
                break;
            }
            case Vector3Array: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform3fv set Vector3Array." + uniform.getName());
                }
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                GLES20.glUniform3fv((int)loc, (int)1, (FloatBuffer)fb);
                break;
            }
            case Vector4Array: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform4fv set Vector4Array." + uniform.getName());
                }
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                GLES20.glUniform4fv((int)loc, (int)1, (FloatBuffer)fb);
                break;
            }
            case Matrix4Array: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform4fv set Matrix4Array." + uniform.getName());
                }
                FloatBuffer fb = (FloatBuffer)uniform.getValue();
                int size = fb.capacity() / 16;
                GLES20.glUniformMatrix4fv((int)loc, (int)size, (boolean)false, (FloatBuffer)fb);
                break;
            }
            case Int: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUniform1i set Int." + uniform.getName());
                }
                Integer i = (Integer)uniform.getValue();
                GLES20.glUniform1i((int)loc, (int)i);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported uniform type: " + (Object)((Object)uniform.getVarType()));
            }
        }
        this.checkGLError();
    }

    protected void updateShaderUniforms(Shader shader) {
        ListMap<String, Uniform> uniforms = shader.getUniformMap();
        for (int i = 0; i < uniforms.size(); ++i) {
            Uniform uniform = uniforms.getValue(i);
            if (!uniform.isUpdateNeeded()) continue;
            this.updateUniform(shader, uniform);
        }
    }

    protected void resetUniformLocations(Shader shader) {
        ListMap<String, Uniform> uniforms = shader.getUniformMap();
        for (int i = 0; i < uniforms.size(); ++i) {
            Uniform uniform = uniforms.getValue(i);
            uniform.reset();
        }
    }

    @Override
    public void setLighting(LightList list) {
    }

    public int convertShaderType(Shader.ShaderType type) {
        switch (type) {
            case Fragment: {
                return 35632;
            }
            case Vertex: {
                return 35633;
            }
        }
        throw new RuntimeException("Unrecognized shader type.");
    }

    public void updateShaderSourceData(Shader.ShaderSource source, String language) {
        int id = source.getId();
        if (id == -1) {
            if (this.verboseLogging) {
                logger.info("GLES20.glCreateShader(" + (Object)((Object)source.getType()) + ")");
            }
            id = GLES20.glCreateShader((int)this.convertShaderType(source.getType()));
            this.checkGLError();
            if (id <= 0) {
                throw new RendererException("Invalid ID received when trying to create shader.");
            }
            source.setId(id);
        }
        byte[] versionData = new byte[]{};
        byte[] definesCodeData = source.getDefines().getBytes();
        byte[] sourceCodeData = source.getSource().getBytes();
        ByteBuffer codeBuf = BufferUtils.createByteBuffer(versionData.length + definesCodeData.length + sourceCodeData.length);
        codeBuf.put(versionData);
        codeBuf.put(definesCodeData);
        codeBuf.put(sourceCodeData);
        codeBuf.flip();
        if (this.verboseLogging) {
            logger.info("GLES20.glShaderSource(" + id + ")");
        }
        GLES20.glShaderSource((int)id, (String)("precision mediump float;\n" + source.getDefines() + source.getSource()));
        this.checkGLError();
        if (this.verboseLogging) {
            logger.info("GLES20.glCompileShader(" + id + ")");
        }
        GLES20.glCompileShader((int)id);
        this.checkGLError();
        if (this.verboseLogging) {
            logger.info("GLES20.glGetShaderiv(" + id + ", GLES20.GL_COMPILE_STATUS)");
        }
        GLES20.glGetShaderiv((int)id, (int)35713, (IntBuffer)this.intBuf1);
        this.checkGLError();
        boolean compiledOK = this.intBuf1.get(0) == 1;
        String infoLog = null;
        if (!compiledOK) {
            if (this.verboseLogging) {
                logger.info("GLES20.glGetShaderiv()");
            }
            GLES20.glGetShaderiv((int)id, (int)35716, (IntBuffer)this.intBuf1);
            this.checkGLError();
            int length = this.intBuf1.get(0);
            if (length > 3) {
                ByteBuffer logBuf = BufferUtils.createByteBuffer(length);
                if (this.verboseLogging) {
                    logger.info("GLES20.glGetShaderInfoLog(" + id + ")");
                }
                infoLog = GLES20.glGetShaderInfoLog((int)id);
            }
        }
        if (compiledOK) {
            if (infoLog != null) {
                logger.log(Level.INFO, "compile success: " + source.getName() + ", " + infoLog);
            } else {
                logger.log(Level.FINE, "compile success: " + source.getName());
            }
        } else {
            if (infoLog != null) {
                logger.log(Level.WARNING, "compile error: " + source.getName() + ", " + infoLog);
            } else {
                logger.log(Level.WARNING, "compile error: " + source.getName());
            }
            logger.log(Level.WARNING, source.getDefines() + "\n" + source.getSource());
        }
        source.clearUpdateNeeded();
        source.setUsable(compiledOK);
        if (!compiledOK) {
            if (this.verboseLogging) {
                logger.info("GLES20.glDeleteShader(" + id + ")");
            }
            GLES20.glDeleteShader((int)id);
            this.checkGLError();
        } else {
            this.objManager.registerForCleanup(source);
        }
    }

    public void updateShaderData(Shader shader) {
        int id = shader.getId();
        boolean needRegister = false;
        if (id == -1) {
            if (this.verboseLogging) {
                logger.info("GLES20.glCreateProgram()");
            }
            if ((id = GLES20.glCreateProgram()) <= 0) {
                throw new RendererException("Invalid ID received when trying to create shader program.");
            }
            shader.setId(id);
            needRegister = true;
        }
        for (Shader.ShaderSource source : shader.getSources()) {
            if (source.isUpdateNeeded()) {
                this.updateShaderSourceData(source, shader.getLanguage());
            }
            if (!source.isUsable()) {
                shader.setUsable(false);
                shader.clearUpdateNeeded();
                return;
            }
            if (this.verboseLogging) {
                logger.info("GLES20.glAttachShader(" + id + ", " + source.getId() + ")");
            }
            GLES20.glAttachShader((int)id, (int)source.getId());
        }
        if (this.verboseLogging) {
            logger.info("GLES20.glLinkProgram(" + id + ")");
        }
        GLES20.glLinkProgram((int)id);
        if (this.verboseLogging) {
            logger.info("GLES20.glGetProgramiv(" + id + ")");
        }
        GLES20.glGetProgramiv((int)id, (int)35714, (IntBuffer)this.intBuf1);
        boolean linkOK = this.intBuf1.get(0) == 1;
        String infoLog = null;
        if (!linkOK) {
            if (this.verboseLogging) {
                logger.info("GLES20.glGetProgramiv(" + id + ", GLES20.GL_INFO_LOG_LENGTH, buffer)");
            }
            GLES20.glGetProgramiv((int)id, (int)35716, (IntBuffer)this.intBuf1);
            int length = this.intBuf1.get(0);
            if (length > 3) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glGetProgramInfoLog(" + id + ")");
                }
                infoLog = GLES20.glGetProgramInfoLog((int)id);
            }
        }
        if (linkOK) {
            if (infoLog != null) {
                logger.log(Level.INFO, "shader link success. \n{0}", infoLog);
            } else {
                logger.fine("shader link success");
            }
        } else if (infoLog != null) {
            logger.log(Level.WARNING, "shader link failure. \n{0}", infoLog);
        } else {
            logger.warning("shader link failure");
        }
        shader.clearUpdateNeeded();
        if (!linkOK) {
            shader.resetSources();
            shader.setUsable(false);
            this.deleteShader(shader);
        } else {
            shader.setUsable(true);
            if (needRegister) {
                this.objManager.registerForCleanup(shader);
                this.statistics.onNewShader();
            } else {
                this.resetUniformLocations(shader);
            }
        }
    }

    @Override
    public void setShader(Shader shader) {
        if (this.verboseLogging) {
            logger.info("setShader(" + shader + ")");
        }
        if (shader == null) {
            if (this.context.boundShaderProgram > 0) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUseProgram(0)");
                }
                GLES20.glUseProgram((int)0);
                this.statistics.onShaderUse(null, true);
                this.context.boundShaderProgram = 0;
                this.boundShader = null;
            }
        } else {
            if (shader.isUpdateNeeded()) {
                this.updateShaderData(shader);
            }
            if (!shader.isUsable()) {
                logger.warning("shader is not usable.");
                return;
            }
            assert (shader.getId() > 0);
            this.updateShaderUniforms(shader);
            if (this.context.boundShaderProgram != shader.getId()) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glUseProgram(" + shader.getId() + ")");
                }
                GLES20.glUseProgram((int)shader.getId());
                this.statistics.onShaderUse(shader, true);
                this.context.boundShaderProgram = shader.getId();
                this.boundShader = shader;
            } else {
                this.statistics.onShaderUse(shader, false);
            }
        }
    }

    @Override
    public void deleteShaderSource(Shader.ShaderSource source) {
        if (source.getId() < 0) {
            logger.warning("Shader source is not uploaded to GPU, cannot delete.");
            return;
        }
        source.setUsable(false);
        source.clearUpdateNeeded();
        if (this.verboseLogging) {
            logger.info("GLES20.glDeleteShader(" + source.getId() + ")");
        }
        GLES20.glDeleteShader((int)source.getId());
        source.resetObject();
    }

    @Override
    public void deleteShader(Shader shader) {
        if (shader.getId() == -1) {
            logger.warning("Shader is not uploaded to GPU, cannot delete.");
            return;
        }
        for (Shader.ShaderSource source : shader.getSources()) {
            if (source.getId() == -1) continue;
            if (this.verboseLogging) {
                logger.info("GLES20.glDetachShader(" + shader.getId() + ", " + source.getId() + ")");
            }
            GLES20.glDetachShader((int)shader.getId(), (int)source.getId());
        }
        shader.resetSources();
        if (this.verboseLogging) {
            logger.info("GLES20.glDeleteProgram(" + shader.getId() + ")");
        }
        GLES20.glDeleteProgram((int)shader.getId());
        this.statistics.onDeleteShader();
    }

    @Override
    public void copyFrameBuffer(FrameBuffer src, FrameBuffer dst) {
        logger.warning("copyFrameBuffer is not supported.");
    }

    @Override
    public void copyFrameBuffer(FrameBuffer src, FrameBuffer dst, boolean copyDepth) {
        logger.warning("copyFrameBuffer is not supported.");
    }

    private void checkFrameBufferError() {
        logger.warning("checkFrameBufferError is not supported.");
    }

    private void updateRenderBuffer(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        logger.warning("updateRenderBuffer is not supported.");
    }

    private int convertAttachmentSlot(int attachmentSlot) {
        logger.warning("convertAttachmentSlot is not supported.");
        return -1;
    }

    public void updateRenderTexture(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        logger.warning("updateRenderTexture is not supported.");
    }

    public void updateFrameBufferAttachment(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        logger.warning("updateFrameBufferAttachment is not supported.");
    }

    public void updateFrameBuffer(FrameBuffer fb) {
        logger.warning("updateFrameBuffer is not supported.");
    }

    @Override
    public void setFrameBuffer(FrameBuffer fb) {
        if (this.verboseLogging) {
            logger.warning("setFrameBuffer is not supported.");
        }
    }

    @Override
    public void readFrameBuffer(FrameBuffer fb, ByteBuffer byteBuf) {
        logger.warning("readFrameBuffer is not supported.");
    }

    private void deleteRenderBuffer(FrameBuffer fb, FrameBuffer.RenderBuffer rb) {
        logger.warning("deleteRenderBuffer is not supported.");
    }

    @Override
    public void deleteFrameBuffer(FrameBuffer fb) {
        logger.warning("deleteFrameBuffer is not supported.");
    }

    private int convertTextureType(Texture.Type type) {
        switch (type) {
            case TwoDimensional: {
                return 3553;
            }
            case CubeMap: {
                return 34067;
            }
        }
        throw new UnsupportedOperationException("Unknown texture type: " + (Object)((Object)type));
    }

    private int convertMagFilter(Texture.MagFilter filter) {
        switch (filter) {
            case Bilinear: {
                return 9729;
            }
            case Nearest: {
                return 9728;
            }
        }
        throw new UnsupportedOperationException("Unknown mag filter: " + (Object)((Object)filter));
    }

    private int convertMinFilter(Texture.MinFilter filter) {
        switch (filter) {
            case Trilinear: {
                return 9987;
            }
            case BilinearNearestMipMap: {
                return 9985;
            }
            case NearestLinearMipMap: {
                return 9986;
            }
            case NearestNearestMipMap: {
                return 9984;
            }
            case BilinearNoMipMaps: {
                return 9729;
            }
            case NearestNoMipMaps: {
                return 9728;
            }
        }
        throw new UnsupportedOperationException("Unknown min filter: " + (Object)((Object)filter));
    }

    private int convertWrapMode(Texture.WrapMode mode) {
        switch (mode) {
            case EdgeClamp: {
                return 33071;
            }
            case Repeat: {
                return 10497;
            }
            case MirroredRepeat: {
                return 33648;
            }
        }
        throw new UnsupportedOperationException("Unknown wrap mode: " + (Object)((Object)mode));
    }

    private void setupTextureParams(Texture tex) {
        int target = this.convertTextureType(tex.getType());
        int minFilter = this.convertMinFilter(tex.getMinFilter());
        int magFilter = this.convertMagFilter(tex.getMagFilter());
        if (this.verboseLogging) {
            logger.info("GLES20.glTexParameteri(" + target + ", GLES20.GL_TEXTURE_MIN_FILTER, " + minFilter + ")");
        }
        GLES20.glTexParameteri((int)target, (int)10241, (int)minFilter);
        if (this.verboseLogging) {
            logger.info("GLES20.glTexParameteri(" + target + ", GLES20.GL_TEXTURE_MAG_FILTER, " + magFilter + ")");
        }
        GLES20.glTexParameteri((int)target, (int)10240, (int)magFilter);
        switch (tex.getType()) {
            case TwoDimensional: 
            case CubeMap: 
            case ThreeDimensional: 
            case TwoDimensionalArray: {
                if (this.verboseLogging) {
                    logger.info("GLES20.glTexParameteri(" + target + ", GLES20.GL_TEXTURE_WRAP_T, " + this.convertWrapMode(tex.getWrap(Texture.WrapAxis.T)));
                }
                GLES20.glTexParameteri((int)target, (int)10243, (int)this.convertWrapMode(tex.getWrap(Texture.WrapAxis.T)));
                if (this.verboseLogging) {
                    logger.info("GLES20.glTexParameteri(" + target + ", GLES20.GL_TEXTURE_WRAP_S, " + this.convertWrapMode(tex.getWrap(Texture.WrapAxis.S)));
                }
                GLES20.glTexParameteri((int)target, (int)10242, (int)this.convertWrapMode(tex.getWrap(Texture.WrapAxis.S)));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown texture type: " + (Object)((Object)tex.getType()));
            }
        }
    }

    public void updateTexImageData(Image img, Texture.Type type, boolean mips) {
        int texId = img.getId();
        if (texId == -1) {
            if (this.verboseLogging) {
                logger.info("GLES20.glGenTexture(1, buffer)");
            }
            GLES20.glGenTextures((int)1, (IntBuffer)this.intBuf1);
            texId = this.intBuf1.get(0);
            img.setId(texId);
            this.objManager.registerForCleanup(img);
            this.statistics.onNewTexture();
        }
        int target = this.convertTextureType(type);
        if (this.context.boundTextures[0] != img) {
            if (this.context.boundTextureUnit != 0) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glActiveTexture(GLES20.GL_TEXTURE0)");
                }
                GLES20.glActiveTexture((int)33984);
                this.context.boundTextureUnit = 0;
            }
            if (this.verboseLogging) {
                logger.info("GLES20.glBindTexture(" + target + ", " + texId + ")");
            }
            GLES20.glBindTexture((int)target, (int)texId);
            this.context.boundTextures[0] = img;
        }
        if (target == 34067) {
            List bmps = (List)img.getEfficentData();
            if (bmps != null) {
                if (bmps.size() != 6) {
                    throw new UnsupportedOperationException("Invalid texture: " + img + "Cubemap textures must contain 6 data units.");
                }
                for (int i = 0; i < 6; ++i) {
                    TextureUtil.uploadTextureBitmap(34069 + i, (Bitmap)bmps.get(i), false, this.powerOf2);
                }
            } else {
                List<ByteBuffer> data = img.getData();
                if (data.size() != 6) {
                    logger.log(Level.WARNING, "Invalid texture: {0}\nCubemap textures must contain 6 data units.", img);
                    return;
                }
                for (int i = 0; i < 6; ++i) {
                    TextureUtil.uploadTexture(img, 34069 + i, i, 0, this.tdc, false, this.powerOf2);
                }
            }
        } else {
            TextureUtil.uploadTexture(img, target, 0, 0, this.tdc, false, this.powerOf2);
            if (this.verboseLogging) {
                logger.info("GLES20.glTexParameteri(" + target + "GLES11.GL_GENERATE_MIMAP, GLES20.GL_TRUE)");
            }
            if (!img.hasMipmaps() && mips) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glGenerateMipmap(GLES20.GL_TEXTURE_2D)");
                }
                GLES20.glGenerateMipmap((int)3553);
            }
        }
        img.clearUpdateNeeded();
    }

    @Override
    public void setTexture(int unit, Texture tex) {
        Image image = tex.getImage();
        if (image.isUpdateNeeded()) {
            this.updateTexImageData(image, tex.getType(), tex.getMinFilter().usesMipMapLevels());
        }
        int texId = image.getId();
        assert (texId != -1);
        if (texId == -1) {
            logger.warning("error: texture image has -1 id");
        }
        Image[] textures = this.context.boundTextures;
        int type = this.convertTextureType(tex.getType());
        if (!this.context.textureIndexList.moveToNew(unit)) {
            // empty if block
        }
        if (textures[unit] != image) {
            if (this.context.boundTextureUnit != unit) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glActiveTexture(GLES20.GL_TEXTURE0 + " + unit + ")");
                }
                GLES20.glActiveTexture((int)(33984 + unit));
                this.context.boundTextureUnit = unit;
            }
            if (this.verboseLogging) {
                logger.info("GLES20.glBindTexture(" + type + ", " + texId + ")");
            }
            GLES20.glBindTexture((int)type, (int)texId);
            textures[unit] = image;
            this.statistics.onTextureUse(tex.getImage(), true);
        } else {
            this.statistics.onTextureUse(tex.getImage(), false);
        }
        this.setupTextureParams(tex);
    }

    public void clearTextureUnits() {
        IDList textureList = this.context.textureIndexList;
        Image[] textures = this.context.boundTextures;
        for (int i = 0; i < textureList.oldLen; ++i) {
            int idx = textureList.oldList[i];
            textures[idx] = null;
        }
        this.context.textureIndexList.copyNewToOld();
    }

    @Override
    public void deleteImage(Image image) {
        int texId = image.getId();
        if (texId != -1) {
            this.intBuf1.put(0, texId);
            this.intBuf1.position(0).limit(1);
            if (this.verboseLogging) {
                logger.info("GLES20.glDeleteTexture(1, buffer)");
            }
            GLES20.glDeleteTextures((int)1, (IntBuffer)this.intBuf1);
            image.resetObject();
            this.statistics.onDeleteTexture();
        }
    }

    private int convertUsage(VertexBuffer.Usage usage) {
        switch (usage) {
            case Static: {
                return 35044;
            }
            case Dynamic: {
                return 35048;
            }
            case Stream: {
                return 35040;
            }
        }
        throw new RuntimeException("Unknown usage type.");
    }

    private int convertFormat(VertexBuffer.Format format) {
        switch (format) {
            case Byte: {
                return 5120;
            }
            case UnsignedByte: {
                return 5121;
            }
            case Short: {
                return 5122;
            }
            case UnsignedShort: {
                return 5123;
            }
            case Int: {
                return 5124;
            }
            case UnsignedInt: {
                return 5125;
            }
            case Float: {
                return 5126;
            }
        }
        throw new RuntimeException("Unknown buffer format.");
    }

    @Override
    public void updateBufferData(VertexBuffer vb) {
        int target;
        if (this.verboseLogging) {
            logger.info("updateBufferData(" + vb + ")");
        }
        int bufId = vb.getId();
        boolean created = false;
        if (bufId == -1) {
            if (this.verboseLogging) {
                logger.info("GLES20.glGenBuffers(1, buffer)");
            }
            GLES20.glGenBuffers((int)1, (IntBuffer)this.intBuf1);
            bufId = this.intBuf1.get(0);
            vb.setId(bufId);
            this.objManager.registerForCleanup(vb);
            created = true;
        }
        if (vb.getBufferType() == VertexBuffer.Type.Index) {
            target = 34963;
            if (this.verboseLogging) {
                logger.info("vb.getBufferType() == VertexBuffer.Type.Index");
            }
            if (this.context.boundElementArrayVBO != bufId) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glBindBuffer(" + target + ", " + bufId + ")");
                }
                GLES20.glBindBuffer((int)target, (int)bufId);
                this.context.boundElementArrayVBO = bufId;
            }
        } else {
            if (this.verboseLogging) {
                logger.info("vb.getBufferType() != VertexBuffer.Type.Index");
            }
            target = 34962;
            if (this.context.boundArrayVBO != bufId) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glBindBuffer(" + target + ", " + bufId + ")");
                }
                GLES20.glBindBuffer((int)target, (int)bufId);
                this.context.boundArrayVBO = bufId;
            }
        }
        int usage = this.convertUsage(vb.getUsage());
        vb.getData().clear();
        if (created || vb.hasDataSizeChanged()) {
            int size = vb.getData().capacity() * vb.getFormat().getComponentSize();
            switch (vb.getFormat()) {
                case Byte: 
                case UnsignedByte: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBufferData(" + target + ", " + size + ", (data), " + usage + ")");
                    }
                    GLES20.glBufferData((int)target, (int)size, (Buffer)((ByteBuffer)vb.getData()), (int)usage);
                    break;
                }
                case Short: 
                case UnsignedShort: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBufferData(" + target + ", " + size + ", (data), " + usage + ")");
                    }
                    GLES20.glBufferData((int)target, (int)size, (Buffer)((ShortBuffer)vb.getData()), (int)usage);
                    break;
                }
                case Int: 
                case UnsignedInt: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBufferData(" + target + ", " + size + ", (data), " + usage + ")");
                    }
                    GLES20.glBufferData((int)target, (int)size, (Buffer)((IntBuffer)vb.getData()), (int)usage);
                    break;
                }
                case Float: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBufferData(" + target + ", " + size + ", (data), " + usage + ")");
                    }
                    GLES20.glBufferData((int)target, (int)size, (Buffer)((FloatBuffer)vb.getData()), (int)usage);
                    break;
                }
                case Double: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBufferData(" + target + ", " + size + ", (data), " + usage + ")");
                    }
                    GLES20.glBufferData((int)target, (int)size, (Buffer)((DoubleBuffer)vb.getData()), (int)usage);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown buffer format.");
                }
            }
        } else {
            int size = vb.getData().capacity() * vb.getFormat().getComponentSize();
            switch (vb.getFormat()) {
                case Byte: 
                case UnsignedByte: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBufferSubData(" + target + ", 0, " + size + ", (data))");
                    }
                    GLES20.glBufferSubData((int)target, (int)0, (int)size, (Buffer)((ByteBuffer)vb.getData()));
                    break;
                }
                case Short: 
                case UnsignedShort: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBufferSubData(" + target + ", 0, " + size + ", (data))");
                    }
                    GLES20.glBufferSubData((int)target, (int)0, (int)size, (Buffer)((ShortBuffer)vb.getData()));
                    break;
                }
                case Int: 
                case UnsignedInt: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBufferSubData(" + target + ", 0, " + size + ", (data))");
                    }
                    GLES20.glBufferSubData((int)target, (int)0, (int)size, (Buffer)((IntBuffer)vb.getData()));
                    break;
                }
                case Float: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBufferSubData(" + target + ", 0, " + size + ", (data))");
                    }
                    GLES20.glBufferSubData((int)target, (int)0, (int)size, (Buffer)((FloatBuffer)vb.getData()));
                    break;
                }
                case Double: {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBufferSubData(" + target + ", 0, " + size + ", (data))");
                    }
                    GLES20.glBufferSubData((int)target, (int)0, (int)size, (Buffer)((DoubleBuffer)vb.getData()));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown buffer format.");
                }
            }
        }
        vb.clearUpdateNeeded();
    }

    @Override
    public void deleteBuffer(VertexBuffer vb) {
        int bufId = vb.getId();
        if (bufId != -1) {
            this.intBuf1.put(0, bufId);
            this.intBuf1.position(0).limit(1);
            if (this.verboseLogging) {
                logger.info("GLES20.glDeleteBuffers(1, buffer)");
            }
            GLES20.glDeleteBuffers((int)1, (IntBuffer)this.intBuf1);
            vb.resetObject();
        }
    }

    public void clearVertexAttribs() {
        IDList attribList = this.context.attribIndexList;
        for (int i = 0; i < attribList.oldLen; ++i) {
            int idx = attribList.oldList[i];
            if (this.verboseLogging) {
                logger.info("GLES20.glDisableVertexAttribArray(" + idx + ")");
            }
            GLES20.glDisableVertexAttribArray((int)idx);
            this.context.boundAttribs[idx] = null;
        }
        this.context.attribIndexList.copyNewToOld();
    }

    public void setVertexAttrib(VertexBuffer vb, VertexBuffer idb) {
        int programId;
        if (this.verboseLogging) {
            logger.info("setVertexAttrib(" + vb + ", " + idb + ")");
        }
        if (vb.getBufferType() == VertexBuffer.Type.Index) {
            throw new IllegalArgumentException("Index buffers not allowed to be set to vertex attrib");
        }
        if (vb.isUpdateNeeded() && idb == null) {
            this.updateBufferData(vb);
        }
        if ((programId = this.context.boundShaderProgram) > 0) {
            Attribute attrib = this.boundShader.getAttribute(vb.getBufferType());
            int loc = attrib.getLocation();
            if (loc == -1) {
                if (this.verboseLogging) {
                    logger.warning("location is invalid for attrib: [" + vb.getBufferType().name() + "]");
                }
                return;
            }
            if (loc == -2) {
                String attributeName = "in" + vb.getBufferType().name();
                if (this.verboseLogging) {
                    logger.info("GLES20.glGetAttribLocation(" + programId + ", " + attributeName + ")");
                }
                if ((loc = GLES20.glGetAttribLocation((int)programId, (String)attributeName)) < 0) {
                    attrib.setLocation(-1);
                    if (this.verboseLogging) {
                        logger.warning("attribute is invalid in shader: [" + vb.getBufferType().name() + "]");
                    }
                    return;
                }
                attrib.setLocation(loc);
            }
            VertexBuffer[] attribs = this.context.boundAttribs;
            if (!this.context.attribIndexList.moveToNew(loc)) {
                if (this.verboseLogging) {
                    logger.info("GLES20.glEnableVertexAttribArray(" + loc + ")");
                }
                GLES20.glEnableVertexAttribArray((int)loc);
            }
            if (attribs[loc] != vb) {
                int bufId;
                int n = bufId = idb != null ? idb.getId() : vb.getId();
                assert (bufId != -1);
                if (bufId == -1) {
                    logger.warning("invalid buffer id");
                }
                if (this.context.boundArrayVBO != bufId) {
                    if (this.verboseLogging) {
                        logger.info("GLES20.glBindBuffer(34962, " + bufId + ")");
                    }
                    GLES20.glBindBuffer((int)34962, (int)bufId);
                    this.context.boundArrayVBO = bufId;
                }
                vb.getData().clear();
                if (this.verboseLogging) {
                    logger.info("GLES20.glVertexAttribPointer(location=" + loc + ", " + "numComponents=" + vb.getNumComponents() + ", " + "format=" + (Object)((Object)vb.getFormat()) + ", " + "isNormalized=" + vb.isNormalized() + ", " + "stride=" + vb.getStride() + ", " + "data.capacity=" + vb.getData().capacity() + ")");
                }
                GLES20.glVertexAttribPointer((int)loc, (int)vb.getNumComponents(), (int)this.convertFormat(vb.getFormat()), (boolean)vb.isNormalized(), (int)vb.getStride(), (Buffer)vb.getData());
                attribs[loc] = vb;
            }
        } else {
            throw new IllegalStateException("Cannot render mesh without shader bound");
        }
    }

    public void setVertexAttrib(VertexBuffer vb) {
        this.setVertexAttrib(vb, null);
    }

    public void drawTriangleArray(Mesh.Mode mode, int count, int vertCount) {
        if (this.verboseLogging) {
            logger.info("GLES20.glDrawArrays(" + vertCount + ")");
        }
        GLES20.glDrawArrays((int)this.convertElementMode(mode), (int)0, (int)vertCount);
    }

    public void drawTriangleList(VertexBuffer indexBuf, Mesh mesh, int count) {
        if (this.verboseLogging) {
            logger.info("drawTriangleList(" + count + ")");
        }
        if (indexBuf.getBufferType() != VertexBuffer.Type.Index) {
            throw new IllegalArgumentException("Only index buffers are allowed as triangle lists.");
        }
        if (indexBuf.isUpdateNeeded()) {
            if (this.verboseLogging) {
                logger.info("updateBufferData for indexBuf.");
            }
            this.updateBufferData(indexBuf);
        }
        int bufId = indexBuf.getId();
        assert (bufId != -1);
        if (bufId == -1) {
            logger.info("invalid buffer id!");
        }
        if (this.context.boundElementArrayVBO != bufId) {
            if (this.verboseLogging) {
                logger.info("GLES20.glBindBuffer(GLES20.GL_ELEMENT_ARRAY_BUFFER, " + bufId + ")");
            }
            GLES20.glBindBuffer((int)34963, (int)bufId);
            this.context.boundElementArrayVBO = bufId;
        }
        int vertCount = mesh.getVertexCount();
        boolean useInstancing = count > 1 && this.caps.contains((Object)Caps.MeshInstancing);
        Buffer indexData = indexBuf.getData();
        if (mesh.getMode() == Mesh.Mode.Hybrid) {
            int[] modeStart = mesh.getModeStart();
            int[] elementLengths = mesh.getElementLengths();
            int elMode = this.convertElementMode(Mesh.Mode.Triangles);
            int fmt = this.convertFormat(indexBuf.getFormat());
            int elSize = indexBuf.getFormat().getComponentSize();
            int listStart = modeStart[0];
            int stripStart = modeStart[1];
            int fanStart = modeStart[2];
            int curOffset = 0;
            for (int i = 0; i < elementLengths.length; ++i) {
                if (i == stripStart) {
                    elMode = this.convertElementMode(Mesh.Mode.TriangleStrip);
                } else if (i == fanStart) {
                    elMode = this.convertElementMode(Mesh.Mode.TriangleStrip);
                }
                int elementLength = elementLengths[i];
                if (useInstancing) {
                    throw new IllegalArgumentException("instancing is not supported.");
                }
                indexBuf.getData().position(curOffset);
                if (this.verboseLogging) {
                    logger.info("glDrawElements(): " + elementLength + ", " + curOffset);
                }
                GLES20.glDrawElements((int)elMode, (int)elementLength, (int)fmt, (Buffer)indexBuf.getData());
                curOffset += elementLength * elSize;
            }
        } else {
            if (useInstancing) {
                throw new IllegalArgumentException("instancing is not supported.");
            }
            indexData.clear();
            if (this.verboseLogging) {
                logger.info("glDrawElements(), indexBuf.capacity (" + indexBuf.getData().capacity() + "), vertCount (" + vertCount + ")");
            }
            GLES11.glDrawElements((int)this.convertElementMode(mesh.getMode()), (int)indexBuf.getData().capacity(), (int)this.convertFormat(indexBuf.getFormat()), (int)0);
        }
    }

    public int convertElementMode(Mesh.Mode mode) {
        switch (mode) {
            case Points: {
                return 0;
            }
            case Lines: {
                return 1;
            }
            case LineLoop: {
                return 2;
            }
            case LineStrip: {
                return 3;
            }
            case Triangles: {
                return 4;
            }
            case TriangleFan: {
                return 6;
            }
            case TriangleStrip: {
                return 5;
            }
        }
        throw new UnsupportedOperationException("Unrecognized mesh mode: " + (Object)((Object)mode));
    }

    public void updateVertexArray(Mesh mesh) {
        logger.info("updateVertexArray(" + mesh + ")");
        int id = mesh.getId();
        VertexBuffer interleavedData = mesh.getBuffer(VertexBuffer.Type.InterleavedData);
        if (interleavedData != null && interleavedData.isUpdateNeeded()) {
            this.updateBufferData(interleavedData);
        }
        IntMap<VertexBuffer> buffers = mesh.getBuffers();
        for (IntMap.Entry<VertexBuffer> entry : buffers) {
            VertexBuffer vb = entry.getValue();
            if (vb.getBufferType() == VertexBuffer.Type.InterleavedData || vb.getUsage() == VertexBuffer.Usage.CpuOnly || vb.getBufferType() == VertexBuffer.Type.Index) continue;
            if (vb.getStride() == 0) {
                this.setVertexAttrib(vb);
                continue;
            }
            this.setVertexAttrib(vb, interleavedData);
        }
    }

    private void renderMeshVertexArray(Mesh mesh, int lod, int count) {
        if (this.verboseLogging) {
            logger.info("renderMeshVertexArray");
        }
        IntMap<VertexBuffer> buffers = mesh.getBuffers();
        for (IntMap.Entry<VertexBuffer> entry : buffers) {
            VertexBuffer vb = entry.getValue();
            if (vb.getBufferType() == VertexBuffer.Type.InterleavedData || vb.getUsage() == VertexBuffer.Usage.CpuOnly || vb.getBufferType() == VertexBuffer.Type.Index) continue;
            if (vb.getStride() == 0) {
                this.setVertexAttrib_Array(vb);
                continue;
            }
            VertexBuffer interleavedData = mesh.getBuffer(VertexBuffer.Type.InterleavedData);
            this.setVertexAttrib_Array(vb, interleavedData);
        }
        VertexBuffer indices = null;
        indices = mesh.getNumLodLevels() > 0 ? mesh.getLodLevel(lod) : buffers.get(VertexBuffer.Type.Index.ordinal());
        if (indices != null) {
            this.drawTriangleList_Array(indices, mesh, count);
        } else {
            if (this.verboseLogging) {
                logger.info("GLES20.glDrawArrays(" + (Object)((Object)mesh.getMode()) + ", " + 0 + ", " + mesh.getVertexCount() + ")");
            }
            GLES20.glDrawArrays((int)this.convertElementMode(mesh.getMode()), (int)0, (int)mesh.getVertexCount());
        }
        this.clearVertexAttribs();
        this.clearTextureUnits();
    }

    private void renderMeshDefault(Mesh mesh, int lod, int count) {
        if (this.verboseLogging) {
            logger.info("renderMeshDefault(" + mesh + ", " + lod + ", " + count + ")");
        }
        VertexBuffer indices = null;
        VertexBuffer interleavedData = mesh.getBuffer(VertexBuffer.Type.InterleavedData);
        if (interleavedData != null && interleavedData.isUpdateNeeded()) {
            this.updateBufferData(interleavedData);
        }
        IntMap<VertexBuffer> buffers = mesh.getBuffers();
        indices = mesh.getNumLodLevels() > 0 ? mesh.getLodLevel(lod) : buffers.get(VertexBuffer.Type.Index.ordinal());
        for (IntMap.Entry<VertexBuffer> entry : buffers) {
            VertexBuffer vb = entry.getValue();
            if (vb.getBufferType() == VertexBuffer.Type.InterleavedData || vb.getUsage() == VertexBuffer.Usage.CpuOnly || vb.getBufferType() == VertexBuffer.Type.Index) continue;
            if (vb.getStride() == 0) {
                this.setVertexAttrib(vb);
                continue;
            }
            this.setVertexAttrib(vb, interleavedData);
        }
        if (indices != null) {
            this.drawTriangleList(indices, mesh, count);
        } else {
            if (this.verboseLogging) {
                logger.info("GLES20.glDrawArrays(" + this.convertElementMode(mesh.getMode()) + ", 0, " + mesh.getVertexCount() + ")");
            }
            GLES20.glDrawArrays((int)this.convertElementMode(mesh.getMode()), (int)0, (int)mesh.getVertexCount());
        }
        this.clearVertexAttribs();
        this.clearTextureUnits();
    }

    @Override
    public void renderMesh(Mesh mesh, int lod, int count) {
        if (this.context.pointSize != mesh.getPointSize()) {
            if (this.verboseLogging) {
                logger.info("GLES10.glPointSize(" + mesh.getPointSize() + ")");
            }
            GLES10.glPointSize((float)mesh.getPointSize());
            this.context.pointSize = mesh.getPointSize();
        }
        if (this.context.lineWidth != mesh.getLineWidth()) {
            if (this.verboseLogging) {
                logger.info("GLES20.glLineWidth(" + mesh.getLineWidth() + ")");
            }
            GLES20.glLineWidth((float)mesh.getLineWidth());
            this.context.lineWidth = mesh.getLineWidth();
        }
        this.statistics.onMeshDrawn(mesh, lod);
        if (this.useVBO) {
            if (this.verboseLogging) {
                logger.info("RENDERING A MESH USING VertexBufferObject");
            }
            this.renderMeshDefault(mesh, lod, count);
        } else {
            if (this.verboseLogging) {
                logger.info("RENDERING A MESH USING VertexArray");
            }
            this.renderMeshVertexArray(mesh, lod, count);
        }
    }

    private void checkGLError() {
        int error;
        while ((error = GLES20.glGetError()) != 0) {
            logger.warning("glError " + error);
        }
    }

    private boolean log(String message) {
        logger.info(message);
        return true;
    }

    public void drawTriangleList_Array(VertexBuffer indexBuf, Mesh mesh, int count) {
        boolean useInstancing;
        if (this.verboseLogging) {
            logger.info("drawTriangleList_Array(Count = " + count + ")");
        }
        if (indexBuf.getBufferType() != VertexBuffer.Type.Index) {
            throw new IllegalArgumentException("Only index buffers are allowed as triangle lists.");
        }
        boolean bl = useInstancing = count > 1 && this.caps.contains((Object)Caps.MeshInstancing);
        if (useInstancing) {
            throw new IllegalArgumentException("Caps.MeshInstancing is not supported.");
        }
        int vertCount = mesh.getVertexCount();
        Buffer indexData = indexBuf.getData();
        indexData.clear();
        if (mesh.getMode() == Mesh.Mode.Hybrid) {
            int[] modeStart = mesh.getModeStart();
            int[] elementLengths = mesh.getElementLengths();
            int elMode = this.convertElementMode(Mesh.Mode.Triangles);
            int fmt = this.convertFormat(indexBuf.getFormat());
            int elSize = indexBuf.getFormat().getComponentSize();
            int listStart = modeStart[0];
            int stripStart = modeStart[1];
            int fanStart = modeStart[2];
            int curOffset = 0;
            for (int i = 0; i < elementLengths.length; ++i) {
                if (i == stripStart) {
                    elMode = this.convertElementMode(Mesh.Mode.TriangleStrip);
                } else if (i == fanStart) {
                    elMode = this.convertElementMode(Mesh.Mode.TriangleStrip);
                }
                int elementLength = elementLengths[i];
                indexBuf.getData().position(curOffset);
                if (this.verboseLogging) {
                    logger.info("glDrawElements(): " + elementLength + ", " + curOffset);
                }
                GLES20.glDrawElements((int)elMode, (int)elementLength, (int)fmt, (Buffer)indexBuf.getData());
                curOffset += elementLength * elSize;
            }
        } else {
            if (this.verboseLogging) {
                logger.info("glDrawElements(), indexBuf.capacity (" + indexBuf.getData().capacity() + "), vertCount (" + vertCount + ")");
            }
            GLES20.glDrawElements((int)this.convertElementMode(mesh.getMode()), (int)indexBuf.getData().capacity(), (int)this.convertFormat(indexBuf.getFormat()), (Buffer)indexBuf.getData());
        }
    }

    public void setVertexAttrib_Array(VertexBuffer vb, VertexBuffer idb) {
        if (this.verboseLogging) {
            logger.info("setVertexAttrib_Array(" + vb + ", " + idb + ")");
        }
        if (vb.getBufferType() == VertexBuffer.Type.Index) {
            throw new IllegalArgumentException("Index buffers not allowed to be set to vertex attrib");
        }
        int programId = this.context.boundShaderProgram;
        if (programId > 0) {
            VertexBuffer[] attribs = this.context.boundAttribs;
            Attribute attrib = this.boundShader.getAttribute(vb.getBufferType());
            int loc = attrib.getLocation();
            if (loc == -1) {
                if (this.verboseLogging) {
                    logger.warning("attribute is invalid in shader: [" + vb.getBufferType().name() + "]");
                }
                return;
            }
            if (loc == -2) {
                String attributeName = "in" + vb.getBufferType().name();
                if (this.verboseLogging) {
                    logger.info("GLES20.glGetAttribLocation(" + programId + ", " + attributeName + ")");
                }
                if ((loc = GLES20.glGetAttribLocation((int)programId, (String)attributeName)) < 0) {
                    attrib.setLocation(-1);
                    if (this.verboseLogging) {
                        logger.warning("attribute is invalid in shader: [" + vb.getBufferType().name() + "]");
                    }
                    return;
                }
                attrib.setLocation(loc);
            }
            if (attribs[loc] != vb || vb.isUpdateNeeded()) {
                VertexBuffer avb = idb != null ? idb : vb;
                avb.getData().clear();
                avb.getData().position(vb.getOffset());
                if (this.verboseLogging) {
                    logger.info("GLES20.glVertexAttribPointer(location=" + loc + ", " + "numComponents=" + vb.getNumComponents() + ", " + "format=" + (Object)((Object)vb.getFormat()) + ", " + "isNormalized=" + vb.isNormalized() + ", " + "stride=" + vb.getStride() + ", " + "data.capacity=" + avb.getData().capacity() + ")");
                }
                GLES20.glVertexAttribPointer((int)loc, (int)vb.getNumComponents(), (int)this.convertFormat(vb.getFormat()), (boolean)vb.isNormalized(), (int)vb.getStride(), (Buffer)avb.getData());
                this.checkGLError();
                GLES20.glEnableVertexAttribArray((int)loc);
                attribs[loc] = vb;
            }
        } else {
            throw new IllegalStateException("Cannot render mesh without shader bound");
        }
    }

    public void setVertexAttrib_Array(VertexBuffer vb) {
        this.setVertexAttrib_Array(vb, null);
    }

    @Override
    public void setAlphaToCoverage(boolean value) {
        if (value) {
            GLES20.glEnable((int)32926);
        } else {
            GLES20.glDisable((int)32926);
        }
    }

    @Override
    public void invalidateState() {
        this.context.reset();
        this.boundShader = null;
        this.lastFb = null;
    }
}

