/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.rmi;

import com.jme3.network.Client;
import com.jme3.network.ClientStateListener;
import com.jme3.network.ConnectionListener;
import com.jme3.network.HostedConnection;
import com.jme3.network.Message;
import com.jme3.network.MessageListener;
import com.jme3.network.Server;
import com.jme3.network.rmi.LocalObject;
import com.jme3.network.rmi.ObjectDef;
import com.jme3.network.rmi.RemoteMethodCallMessage;
import com.jme3.network.rmi.RemoteMethodReturnMessage;
import com.jme3.network.rmi.RemoteObject;
import com.jme3.network.rmi.RemoteObjectDefMessage;
import com.jme3.network.rmi.RmiSerializer;
import com.jme3.network.serializing.Serializer;
import com.jme3.util.IntMap;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStore {
    private static final Logger logger = Logger.getLogger(ObjectStore.class.getName());
    private Client client;
    private Server server;
    private ClientEventHandler clientEventHandler = new ClientEventHandler();
    private ServerEventHandler serverEventHandler = new ServerEventHandler();
    private volatile short objectIdCounter = 0;
    private volatile short invocationIdCounter = 0;
    private IntMap<Invocation> pendingInvocations = new IntMap();
    private IntMap<LocalObject> localObjects = new IntMap();
    private HashMap<String, RemoteObject> remoteObjects = new HashMap();
    private IntMap<RemoteObject> remoteObjectsById = new IntMap();
    private final Object receiveObjectLock = new Object();

    public ObjectStore(Client client) {
        this.client = client;
        client.addMessageListener(this.clientEventHandler, RemoteObjectDefMessage.class, RemoteMethodCallMessage.class, RemoteMethodReturnMessage.class);
        client.addClientStateListener(this.clientEventHandler);
    }

    public ObjectStore(Server server) {
        this.server = server;
        server.addMessageListener(this.serverEventHandler, RemoteObjectDefMessage.class, RemoteMethodCallMessage.class, RemoteMethodReturnMessage.class);
        server.addConnectionListener(this.serverEventHandler);
    }

    private ObjectDef makeObjectDef(LocalObject localObj) {
        ObjectDef def = new ObjectDef();
        def.objectName = localObj.objectName;
        def.objectId = localObj.objectId;
        def.methods = localObj.methods;
        return def;
    }

    public void exposeObject(String name, Object obj) throws IOException {
        LocalObject localObj = new LocalObject();
        localObj.objectName = name;
        short s = this.objectIdCounter;
        this.objectIdCounter = (short)(s + 1);
        localObj.objectId = s;
        localObj.theObject = obj;
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : obj.getClass().getMethods()) {
            if (method.getDeclaringClass() != obj.getClass()) continue;
            methodList.add(method);
        }
        localObj.methods = methodList.toArray(new Method[methodList.size()]);
        this.localObjects.put(localObj.objectId, localObj);
        RemoteObjectDefMessage defMsg = new RemoteObjectDefMessage();
        defMsg.objects = new ObjectDef[]{this.makeObjectDef(localObj)};
        if (this.client != null) {
            this.client.send(defMsg);
            logger.log(Level.INFO, "Client: Sending {0}", defMsg);
        } else {
            this.server.broadcast(defMsg);
            logger.log(Level.INFO, "Server: Sending {0}", defMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getExposedObject(String name, Class<T> type, boolean waitFor) throws InterruptedException {
        RemoteObject ro = this.remoteObjects.get(name);
        if (ro == null) {
            if (!waitFor) {
                throw new RuntimeException("Cannot find remote object named: " + name);
            }
            do {
                Object object = this.receiveObjectLock;
                synchronized (object) {
                    this.receiveObjectLock.wait();
                }
            } while ((ro = this.remoteObjects.get(name)) == null);
        }
        Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)ro);
        ro.loadMethods(type);
        return (T)proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object invokeRemoteMethod(RemoteObject remoteObj, Method method, Object[] args) {
        Integer methodIdInt = remoteObj.methodMap.get(method);
        if (methodIdInt == null) {
            throw new RuntimeException("Method not implemented by remote object owner: " + method);
        }
        boolean needReturn = method.getReturnType() != Void.TYPE;
        short objectId = remoteObj.objectId;
        short methodId = methodIdInt.shortValue();
        RemoteMethodCallMessage call = new RemoteMethodCallMessage();
        call.methodId = methodId;
        call.objectId = objectId;
        call.args = args;
        Invocation invoke = null;
        if (needReturn) {
            short s = this.invocationIdCounter;
            this.invocationIdCounter = (short)(s + 1);
            call.invocationId = s;
            invoke = new Invocation();
            this.pendingInvocations.put(call.invocationId, invoke);
        }
        if (this.server != null) {
            remoteObj.client.send(call);
            logger.log(Level.INFO, "Server: Sending {0}", call);
        } else {
            this.client.send(call);
            logger.log(Level.INFO, "Client: Sending {0}", call);
        }
        if (invoke != null) {
            Invocation invocation = invoke;
            synchronized (invocation) {
                while (!invoke.available) {
                    try {
                        invoke.wait();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            }
            this.pendingInvocations.remove(call.invocationId);
            return invoke.retVal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessage(HostedConnection source, Message message) {
        if (message instanceof RemoteObjectDefMessage) {
            ObjectDef[] defs;
            RemoteObjectDefMessage defMsg = (RemoteObjectDefMessage)message;
            for (ObjectDef def : defs = defMsg.objects) {
                RemoteObject remoteObject = new RemoteObject(this, source);
                remoteObject.objectId = (short)def.objectId;
                remoteObject.methodDefs = def.methodDefs;
                this.remoteObjects.put(def.objectName, remoteObject);
                this.remoteObjectsById.put(def.objectId, remoteObject);
            }
            Object object = this.receiveObjectLock;
            synchronized (object) {
                this.receiveObjectLock.notifyAll();
            }
        }
        if (message instanceof RemoteMethodCallMessage) {
            RemoteMethodCallMessage call = (RemoteMethodCallMessage)message;
            LocalObject localObj = this.localObjects.get(call.objectId);
            if (localObj == null) {
                return;
            }
            if (call.methodId < 0 || call.methodId >= localObj.methods.length) {
                return;
            }
            Object invocation = localObj.theObject;
            Method method = localObj.methods[call.methodId];
            Object[] args = call.args;
            Object ret = null;
            try {
                ret = method.invoke(invocation, args);
            }
            catch (IllegalAccessException ex) {
                logger.log(Level.WARNING, "RMI: Error accessing method", ex);
            }
            catch (IllegalArgumentException ex) {
                logger.log(Level.WARNING, "RMI: Invalid arguments", ex);
            }
            catch (InvocationTargetException ex) {
                logger.log(Level.WARNING, "RMI: Invocation exception", ex);
            }
            if (method.getReturnType() != Void.TYPE) {
                RemoteMethodReturnMessage retMsg = new RemoteMethodReturnMessage();
                retMsg.invocationID = call.invocationId;
                retMsg.retVal = ret;
                if (this.server != null) {
                    source.send(retMsg);
                    logger.log(Level.INFO, "Server: Sending {0}", retMsg);
                } else {
                    this.client.send(retMsg);
                    logger.log(Level.INFO, "Client: Sending {0}", retMsg);
                }
            }
        } else if (message instanceof RemoteMethodReturnMessage) {
            RemoteMethodReturnMessage retMsg = (RemoteMethodReturnMessage)message;
            Invocation invoke = this.pendingInvocations.get(retMsg.invocationID);
            if (invoke == null) {
                logger.log(Level.WARNING, "Cannot find invocation ID: {0}", retMsg.invocationID);
                return;
            }
            Invocation invocation = invoke;
            synchronized (invocation) {
                invoke.retVal = retMsg.retVal;
                invoke.available = true;
                invoke.notifyAll();
            }
        }
    }

    private void onConnection(HostedConnection conn) {
        if (this.localObjects.size() > 0) {
            ObjectDef[] defs = new ObjectDef[this.localObjects.size()];
            int i = 0;
            for (IntMap.Entry<LocalObject> entry : this.localObjects) {
                defs[i] = this.makeObjectDef(entry.getValue());
                ++i;
            }
            RemoteObjectDefMessage defMsg = new RemoteObjectDefMessage();
            defMsg.objects = defs;
            if (this.client != null) {
                this.client.send(defMsg);
                logger.log(Level.INFO, "Client: Sending {0}", defMsg);
            } else {
                conn.send(defMsg);
                logger.log(Level.INFO, "Server: Sending {0}", defMsg);
            }
        }
    }

    static {
        RmiSerializer s = new RmiSerializer();
        Serializer.registerClass(RemoteObjectDefMessage.class, s);
        Serializer.registerClass(RemoteMethodCallMessage.class, s);
        Serializer.registerClass(RemoteMethodReturnMessage.class, s);
    }

    public class ClientEventHandler
    implements MessageListener,
    ClientStateListener {
        public void messageReceived(Object source, Message m) {
            ObjectStore.this.onMessage(null, m);
        }

        public void clientConnected(Client c) {
            ObjectStore.this.onConnection(null);
        }

        public void clientDisconnected(Client c, ClientStateListener.DisconnectInfo info) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ServerEventHandler
    implements MessageListener<HostedConnection>,
    ConnectionListener {
        @Override
        public void messageReceived(HostedConnection source, Message m) {
            ObjectStore.this.onMessage(source, m);
        }

        @Override
        public void connectionAdded(Server server, HostedConnection conn) {
            ObjectStore.this.onConnection(conn);
        }

        @Override
        public void connectionRemoved(Server server, HostedConnection conn) {
        }
    }

    private static final class Invocation {
        Object retVal;
        boolean available = false;

        private Invocation() {
        }

        public String toString() {
            return "Invocation[" + this.retVal + "]";
        }
    }
}

