/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.kernel.tcp;

import com.jme3.network.kernel.Connector;
import com.jme3.network.kernel.ConnectorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

public class SocketConnector
implements Connector {
    private Socket sock;
    private InputStream in;
    private OutputStream out;
    private SocketAddress remoteAddress;
    private byte[] buffer = new byte[65535];
    private AtomicBoolean connected = new AtomicBoolean(false);

    public SocketConnector(InetAddress address, int port) throws IOException {
        this.sock = new Socket(address, port);
        this.remoteAddress = this.sock.getRemoteSocketAddress();
        this.sock.setTcpNoDelay(true);
        this.in = this.sock.getInputStream();
        this.out = this.sock.getOutputStream();
        this.connected.set(true);
    }

    protected void checkClosed() {
        if (this.sock == null) {
            throw new ConnectorException("Connection is closed:" + this.remoteAddress);
        }
    }

    public boolean isConnected() {
        if (this.sock == null) {
            return false;
        }
        return this.sock.isConnected();
    }

    public void close() {
        this.checkClosed();
        try {
            Socket temp = this.sock;
            this.sock = null;
            this.connected.set(false);
            temp.close();
        }
        catch (IOException e) {
            throw new ConnectorException("Error closing socket for:" + this.remoteAddress, e);
        }
    }

    public boolean available() {
        this.checkClosed();
        try {
            return this.in.available() > 0;
        }
        catch (IOException e) {
            throw new ConnectorException("Error retrieving data availability for:" + this.remoteAddress, e);
        }
    }

    public ByteBuffer read() {
        this.checkClosed();
        try {
            int count = this.in.read(this.buffer);
            if (count < 0) {
                this.close();
                return null;
            }
            return ByteBuffer.wrap(this.buffer, 0, count);
        }
        catch (IOException e) {
            if (!this.connected.get()) {
                return null;
            }
            throw new ConnectorException("Error reading from connection to:" + this.remoteAddress, e);
        }
    }

    public void write(ByteBuffer data) {
        this.checkClosed();
        try {
            this.out.write(data.array(), data.position(), data.remaining());
        }
        catch (IOException e) {
            throw new ConnectorException("Error writing to connection:" + this.remoteAddress, e);
        }
    }
}

