/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.connection;

import com.jme3.network.connection.Client;
import com.jme3.network.connection.TCPConnection;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLTCPConnection
extends TCPConnection {
    protected ByteBuffer incDataEncrypted;
    protected ByteBuffer incDataDecrypted;
    protected ByteBuffer outDataEncrypted;
    protected ByteBuffer dummy;
    protected SSLEngine sslEngine;
    protected boolean initialHandshake;
    protected SSLEngineResult.HandshakeStatus handshakeStatus;
    protected SSLEngineResult.Status status;
    protected ArrayList<Client> handshakingConnectors = new ArrayList();

    public SSLTCPConnection(String name) {
        this.label = name;
        this.createSSLEngine();
        SSLSession session = this.sslEngine.getSession();
        this.incDataDecrypted = ByteBuffer.allocateDirect(session.getApplicationBufferSize());
        this.incDataEncrypted = ByteBuffer.allocateDirect(session.getPacketBufferSize());
        this.outDataEncrypted = ByteBuffer.allocateDirect(session.getPacketBufferSize());
        this.incDataEncrypted.position(this.incDataEncrypted.limit());
        this.outDataEncrypted.position(this.outDataEncrypted.limit());
        this.dummy = ByteBuffer.allocate(0);
    }

    private void createSSLEngine() {
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            File kf = new File("keystore");
            ks.load(new FileInputStream(kf), "lollercopter".toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, "lollercopter".toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), trustAllCerts, null);
            this.sslEngine = sslContext.createSSLEngine();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "[{0}][TCP] Could not create SSL engine: {1}", new Object[]{this.label, e.getMessage()});
        }
    }

    private void doHandshake(SocketChannel channel) throws IOException {
        block7: while (true) {
            this.log.log(Level.FINEST, "[{0}][TCP] Handshake Status is now {1}.", new Object[]{this.label, this.handshakeStatus});
            switch (this.handshakeStatus) {
                case NOT_HANDSHAKING: {
                    this.log.log(Level.SEVERE, "[{0}][TCP] We're doing a handshake while we're not handshaking.", this.label);
                    break;
                }
                case FINISHED: {
                    this.initialHandshake = false;
                    channel.keyFor(this.selector).interestOps(1);
                    return;
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.sslEngine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    this.handshakeStatus = this.sslEngine.getHandshakeStatus();
                    break;
                }
                case NEED_UNWRAP: {
                    this.readAndUnwrap(channel);
                    if (!this.initialHandshake || this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue block7;
                    channel.keyFor(this.selector).interestOps(1);
                    return;
                }
                case NEED_WRAP: {
                    if (this.outDataEncrypted.hasRemaining()) {
                        this.log.log(Level.FINE, "[{0}][TCP] We found data that should be written out.", this.label);
                        return;
                    }
                    this.outDataEncrypted.clear();
                    SSLEngineResult result = this.sslEngine.wrap(this.dummy, this.outDataEncrypted);
                    this.log.log(Level.FINEST, "[{0}][TCP] Wrapping result: {1}.", new Object[]{this.label, result});
                    if (result.bytesProduced() == 0) {
                        this.log.log(Level.SEVERE, "[{0}][TCP] No net data produced during wrap.", this.label);
                    }
                    if (result.bytesConsumed() != 0) {
                        this.log.log(Level.SEVERE, "[{0}][TCP] App data consumed during handshake wrap.", this.label);
                    }
                    this.handshakeStatus = result.getHandshakeStatus();
                    this.outDataEncrypted.flip();
                    System.out.println("WRITING TO: " + channel + " : " + channel.socket());
                    if (this.flushData(channel)) break;
                    return;
                }
            }
        }
    }

    public void connect(SocketAddress address) throws IOException {
        super.connect(address);
    }

    public void bind(SocketAddress address) throws IOException {
        super.bind(address);
        this.sslEngine.setUseClientMode(false);
        this.sslEngine.setNeedClientAuth(false);
    }

    public void connect(SelectableChannel channel) throws IOException {
        super.connect(channel);
        this.initialHandshake = true;
        this.sslEngine.setUseClientMode(true);
        this.sslEngine.beginHandshake();
        this.socketChannel.keyFor(this.selector).interestOps(4);
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        this.doHandshake(this.socketChannel);
    }

    public void accept(SelectableChannel channel) throws IOException {
        super.accept(channel);
        Client con = (Client)this.connections.get(this.connections.size() - 1);
        this.handshakingConnectors.add(con);
        this.initialHandshake = true;
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
        this.doHandshake(con.getSocketChannel());
    }

    public void read(SelectableChannel channel) throws IOException {
        if (this.initialHandshake) {
            this.doHandshake((SocketChannel)channel);
            return;
        }
        super.read(channel);
    }

    public void readAndUnwrap(SocketChannel channel) throws IOException {
        SSLEngineResult result;
        this.incDataEncrypted.flip();
        int bytesRead = channel.read(this.incDataEncrypted);
        if (bytesRead == 0) {
            System.out.println("BUFFER INFO: " + this.incDataEncrypted);
        }
        if (bytesRead == -1) {
            this.log.log(Level.FINE, "[{0}][TCP] -1 bytes read, closing stream.", new Object[]{this.label, bytesRead});
            return;
        }
        this.log.log(Level.FINE, "[{0}][TCP] Read {1} bytes.", new Object[]{this.label, bytesRead});
        this.incDataDecrypted.clear();
        this.incDataEncrypted.flip();
        do {
            result = this.sslEngine.unwrap(this.incDataEncrypted, this.incDataDecrypted);
            this.log.log(Level.FINE, "[{0}][TCP] Unwrap result: {1}.", new Object[]{this.label, result});
        } while (result.getStatus() == SSLEngineResult.Status.OK && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && result.bytesProduced() == 0);
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.initialHandshake = false;
            channel.keyFor(this.selector).interestOps(1);
        }
        if (this.incDataDecrypted.position() == 0 && result.getStatus() == SSLEngineResult.Status.OK && this.incDataEncrypted.hasRemaining()) {
            result = this.sslEngine.unwrap(this.incDataEncrypted, this.incDataDecrypted);
            this.log.log(Level.FINE, "[{0}][TCP] Unwrap result: {1}.", new Object[]{this.label, result});
        }
        this.status = result.getStatus();
        this.handshakeStatus = result.getHandshakeStatus();
        this.incDataEncrypted.compact();
        this.incDataDecrypted.flip();
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP || this.handshakeStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.log.log(Level.FINE, "[{0}][TCP] Rehandshaking..", this.label);
            this.doHandshake(channel);
        }
    }

    public void send(Object object) throws IOException {
        super.sendObject(object);
    }

    public void send(SocketChannel channel, Object object) throws IOException {
        super.send(channel, object);
    }

    public void write(SelectableChannel channel) throws IOException {
        SocketChannel socketChannel = (SocketChannel)channel;
        if (this.flushData(socketChannel) && this.initialHandshake) {
            this.doHandshake(socketChannel);
        }
    }

    private boolean flushData(SocketChannel channel) throws IOException {
        int written = 0;
        try {
            while (this.outDataEncrypted.hasRemaining()) {
                written += channel.write(this.outDataEncrypted);
            }
        }
        catch (IOException ioe) {
            this.outDataEncrypted.position(this.outDataEncrypted.limit());
            throw ioe;
        }
        this.log.log(Level.FINE, "[{0}][TCP] Wrote {1} bytes to {2}.", new Object[]{this.label, written, channel.socket().getRemoteSocketAddress()});
        if (this.outDataEncrypted.hasRemaining()) {
            SelectionKey key = channel.keyFor(this.selector);
            key.interestOps(4);
            return false;
        }
        return true;
    }
}

