/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.network.connection;

import com.jme3.network.connection.Client;
import com.jme3.network.connection.ConnectorFilter;
import com.jme3.network.events.ConnectionListener;
import com.jme3.network.events.MessageListener;
import com.jme3.network.message.Message;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Connection
implements Runnable {
    protected String label;
    protected Logger log = Logger.getLogger(Connection.class.getName());
    protected final ArrayList<Client> connections = new ArrayList();
    protected Selector selector;
    protected boolean alive = false;
    protected ArrayList<ConnectorFilter> connectorFilters = new ArrayList();
    protected LinkedList<Client> disconnectionQueue = new LinkedList();
    protected ArrayList<ConnectionListener> connectionListeners = new ArrayList();
    protected ArrayList<MessageListener> messageListeners = new ArrayList();
    protected HashMap<Class, List<MessageListener>> individualMessageListeners = new HashMap();

    public Connection() {
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Could not open selector.", e);
        }
    }

    public void addConnectorFilter(ConnectorFilter filter) {
        this.connectorFilters.add(filter);
    }

    public void removeConnectorFilter(ConnectorFilter filter) {
        this.connectorFilters.remove(filter);
    }

    public String shouldFilterConnector(InetSocketAddress address) {
        for (ConnectorFilter filter : this.connectorFilters) {
            String str = filter.filterConnector(address);
            if (str == null) continue;
            return str;
        }
        return null;
    }

    @Override
    public void run() {
        if (!this.alive) {
            this.alive = true;
        }
        try {
            if (this.selector.selectNow() > 0) {
                Set<SelectionKey> keys = this.selector.selectedKeys();
                Iterator<SelectionKey> it = keys.iterator();
                while (it.hasNext()) {
                    SelectionKey key = it.next();
                    it.remove();
                    if (key.isValid() && key.isReadable()) {
                        this.read(key.channel());
                    }
                    if (key.isValid() && key.isAcceptable()) {
                        this.accept(key.channel());
                    }
                    if (key.isValid() && key.isWritable()) {
                        this.write(key.channel());
                    }
                    if (!key.isValid() || !key.isConnectable()) continue;
                    this.connect(key.channel());
                }
            }
            Client dcClient = this.disconnectionQueue.poll();
            while (dcClient != null) {
                this.disconnect(dcClient);
                dcClient = this.disconnectionQueue.poll();
            }
        }
        catch (ConnectException ce) {
            this.log.log(Level.WARNING, "[{0}][???] Connection refused.", this.label);
            this.fireClientDisconnected(null);
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "[{0}][???] Error while selecting. Message: {1}", new Object[]{this.label, e.getMessage()});
        }
    }

    public List<Client> getLocalConnectors() {
        return Collections.unmodifiableList(this.connections);
    }

    public List<Client> getConnectors() {
        return Collections.unmodifiableList(this.connections);
    }

    public boolean isAlive() {
        return this.alive;
    }

    public abstract void accept(SelectableChannel var1) throws IOException;

    public abstract void connect(SelectableChannel var1) throws IOException;

    public abstract void read(SelectableChannel var1) throws IOException;

    public abstract void write(SelectableChannel var1) throws IOException;

    public abstract void connect(SocketAddress var1) throws IOException;

    public abstract void bind(SocketAddress var1) throws IOException;

    public abstract void sendObject(Object var1) throws IOException;

    public abstract void sendObject(Client var1, Object var2) throws IOException;

    public abstract void cleanup() throws IOException;

    public void addToDisconnectionQueue(Client client) {
        this.disconnectionQueue.add(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(Client client) throws IOException {
        SocketChannel chan;
        if (client == null) {
            return;
        }
        Client localClient = null;
        ArrayList<Client> arrayList = this.connections;
        synchronized (arrayList) {
            for (Client locClient : this.connections) {
                if (locClient.getPlayerID() != client.getPlayerID()) continue;
                localClient = locClient;
                break;
            }
        }
        if (localClient == null) {
            localClient = client;
        }
        if ((chan = localClient.getSocketChannel()) != null) {
            SelectionKey key = chan.keyFor(this.selector);
            if (key != null) {
                key.cancel();
            }
            chan.close();
        }
        ArrayList<Client> arrayList2 = this.connections;
        synchronized (arrayList2) {
            this.connections.remove(localClient);
        }
        this.fireClientDisconnected(client);
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void addMessageListener(MessageListener listener) {
        this.messageListeners.add(listener);
    }

    public void removeMessageListener(MessageListener listener) {
        this.messageListeners.remove(listener);
    }

    public void addMessageListener(Class messageClass, MessageListener listener) {
        if (this.individualMessageListeners.containsKey(messageClass)) {
            this.individualMessageListeners.get(messageClass).add(listener);
        } else {
            ArrayList<MessageListener> list = new ArrayList<MessageListener>();
            list.add(listener);
            this.individualMessageListeners.put(messageClass, list);
        }
    }

    public void removeMessageListener(Class messageClass, MessageListener listener) {
        if (this.individualMessageListeners.containsKey(messageClass)) {
            this.individualMessageListeners.get(messageClass).remove(listener);
        }
    }

    protected void fireMessageReceived(Message message) {
        for (MessageListener listener : this.messageListeners) {
            listener.messageReceived(message);
        }
        List<MessageListener> list = this.individualMessageListeners.get(message.getClass());
        if (list == null) {
            return;
        }
        for (MessageListener listener : list) {
            listener.messageReceived(message);
        }
    }

    protected void fireMessageSent(Message message) {
        for (MessageListener listener : this.messageListeners) {
            listener.messageSent(message);
        }
        List<MessageListener> list = this.individualMessageListeners.get(message.getClass());
        if (list == null) {
            return;
        }
        for (MessageListener listener : list) {
            listener.messageSent(message);
        }
    }

    protected void fireObjectReceived(Object data) {
        for (MessageListener listener : this.messageListeners) {
            listener.objectReceived(data);
        }
        if (data == null) {
            return;
        }
        List<MessageListener> list = this.individualMessageListeners.get(data.getClass());
        if (list == null) {
            return;
        }
        for (MessageListener listener : list) {
            listener.objectReceived(data);
        }
    }

    protected void fireObjectSent(Object data) {
        for (MessageListener listener : this.messageListeners) {
            listener.objectSent(data);
        }
        List<MessageListener> list = this.individualMessageListeners.get(data.getClass());
        if (list == null) {
            return;
        }
        for (MessageListener listener : list) {
            listener.objectSent(data);
        }
    }

    protected void fireClientConnected(Client client) {
        for (ConnectionListener listener : this.connectionListeners) {
            listener.clientConnected(client);
        }
    }

    protected void fireClientDisconnected(Client client) {
        for (ConnectionListener listener : this.connectionListeners) {
            listener.clientDisconnected(client);
        }
    }
}

