/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.material;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.material.MatParam;
import com.jme3.material.Technique;
import com.jme3.material.TechniqueDef;
import com.jme3.renderer.Renderer;
import com.jme3.shader.VarType;
import com.jme3.texture.Texture;
import java.io.IOException;

public class MatParamTexture
extends MatParam {
    private Texture texture;
    private int unit;

    public MatParamTexture(VarType type, String name, Texture texture, int unit) {
        super(type, name, texture, null);
        this.texture = texture;
        this.unit = unit;
    }

    public MatParamTexture() {
    }

    public Texture getTextureValue() {
        return this.texture;
    }

    public void setTextureValue(Texture value) {
        this.value = value;
        this.texture = value;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public int getUnit() {
        return this.unit;
    }

    public void apply(Renderer r, Technique technique) {
        TechniqueDef techDef = technique.getDef();
        r.setTexture(this.getUnit(), this.getTextureValue());
        if (techDef.isUsingShaders()) {
            technique.updateUniformParam(this.getPrefixedName(), this.getVarType(), this.getUnit(), true);
        }
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.unit, "texture_unit", -1);
        oc.write(this.texture, "texture", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.unit = ic.readInt("texture_unit", -1);
        this.texture = (Texture)ic.readSavable("texture", null);
    }
}

