/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.light;

import com.jme3.bounding.BoundingVolume;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.light.Light;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import java.io.IOException;

public class PointLight
extends Light {
    protected Vector3f position = new Vector3f();
    protected float radius = 0.0f;
    protected float invRadius = 0.0f;

    public void computeLastDistance(Spatial owner) {
        if (owner.getWorldBound() != null) {
            BoundingVolume bv = owner.getWorldBound();
            this.lastDistance = bv.distanceSquaredTo(this.position);
        } else {
            this.lastDistance = owner.getWorldTranslation().distanceSquared(this.position);
        }
    }

    public Vector3f getPosition() {
        return this.position;
    }

    public void setPosition(Vector3f position) {
        this.position.set(position);
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        if (radius < 0.0f) {
            throw new IllegalArgumentException("Light radius cannot be negative");
        }
        this.radius = radius;
        this.invRadius = radius != 0.0f ? 1.0f / radius : 0.0f;
    }

    public float getInvRadius() {
        return this.invRadius;
    }

    public Light.Type getType() {
        return Light.Type.Point;
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.position, "position", null);
        oc.write(this.radius, "radius", 0.0f);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule ic = im.getCapsule(this);
        this.position = (Vector3f)ic.readSavable("position", null);
        this.radius = ic.readFloat("radius", 0.0f);
        this.invRadius = this.radius != 0.0f ? 1.0f / this.radius : 0.0f;
    }
}

