/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.effect.influencers;

import com.jme3.effect.Particle;
import com.jme3.effect.influencers.ParticleInfluencer;
import com.jme3.effect.shapes.EmitterShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.FastMath;
import com.jme3.math.Vector3f;
import java.io.IOException;

public class DefaultParticleInfluencer
implements ParticleInfluencer {
    protected transient Vector3f temp = new Vector3f();
    protected Vector3f startVelocity = new Vector3f();
    protected float velocityVariation = 0.2f;

    public void influenceParticle(Particle particle, EmitterShape emitterShape) {
        emitterShape.getRandomPoint(particle.position);
        this.applyVelocityVariation(particle);
    }

    protected void applyVelocityVariation(Particle particle) {
        particle.velocity.set(this.startVelocity);
        this.temp.set(FastMath.nextRandomFloat(), FastMath.nextRandomFloat(), FastMath.nextRandomFloat());
        this.temp.multLocal(2.0f);
        this.temp.subtractLocal(1.0f, 1.0f, 1.0f);
        this.temp.multLocal(this.startVelocity.length());
        particle.velocity.interpolate(this.temp, this.velocityVariation);
    }

    public void write(JmeExporter ex) throws IOException {
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.startVelocity, "startVelocity", Vector3f.ZERO);
        oc.write(this.velocityVariation, "variation", 0.2f);
    }

    public void read(JmeImporter im) throws IOException {
        InputCapsule ic = im.getCapsule(this);
        this.startVelocity = (Vector3f)ic.readSavable("startVelocity", Vector3f.ZERO.clone());
        this.velocityVariation = ic.readFloat("variation", 0.2f);
    }

    public ParticleInfluencer clone() {
        try {
            DefaultParticleInfluencer clone = (DefaultParticleInfluencer)super.clone();
            clone.startVelocity = this.startVelocity.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public void setInitialVelocity(Vector3f initialVelocity) {
        this.startVelocity.set(initialVelocity);
    }

    public Vector3f getInitialVelocity() {
        return this.startVelocity;
    }

    public void setVelocityVariation(float variation) {
        this.velocityVariation = variation;
    }

    public float getVelocityVariation() {
        return this.velocityVariation;
    }
}

