/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.cinematic.events;

import com.jme3.animation.LoopMode;
import com.jme3.app.Application;
import com.jme3.cinematic.Cinematic;
import com.jme3.cinematic.MotionPath;
import com.jme3.cinematic.PlayState;
import com.jme3.cinematic.events.AbstractCinematicEvent;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import java.io.IOException;

public class MotionTrack
extends AbstractCinematicEvent
implements Control {
    protected Spatial spatial;
    protected int currentWayPoint;
    protected float currentValue;
    protected Vector3f direction = new Vector3f();
    protected Vector3f lookAt;
    protected Vector3f upVector;
    protected Quaternion rotation;
    protected Direction directionType = Direction.None;
    protected MotionPath path;
    private boolean isControl = true;

    public MotionTrack() {
    }

    public MotionTrack(Spatial spatial, MotionPath path) {
        this.spatial = spatial;
        spatial.addControl(this);
        this.path = path;
    }

    public MotionTrack(Spatial spatial, MotionPath path, float initialDuration) {
        super(initialDuration);
        this.spatial = spatial;
        spatial.addControl(this);
        this.path = path;
    }

    public MotionTrack(Spatial spatial, MotionPath path, LoopMode loopMode) {
        this.spatial = spatial;
        spatial.addControl(this);
        this.path = path;
        this.loopMode = loopMode;
    }

    public MotionTrack(Spatial spatial, MotionPath path, float initialDuration, LoopMode loopMode) {
        super(initialDuration);
        this.spatial = spatial;
        spatial.addControl(this);
        this.path = path;
        this.loopMode = loopMode;
    }

    public void update(float tpf) {
        if (this.isControl && this.playState == PlayState.Playing) {
            this.time += tpf * this.speed;
            this.onUpdate(tpf);
            if (this.time >= this.duration) {
                if (this.loopMode == LoopMode.DontLoop) {
                    this.stop();
                }
            }
        }
    }

    public void initEvent(Application app, Cinematic cinematic) {
        this.isControl = false;
    }

    public void onUpdate(float tpf) {
        this.spatial.setLocalTranslation(this.path.interpolatePath(tpf, this));
        this.computeTargetDirection();
        if (this.currentValue >= 1.0f) {
            this.currentValue = 0.0f;
            ++this.currentWayPoint;
            this.path.triggerWayPointReach(this.currentWayPoint, this);
        }
        if (this.currentWayPoint == this.path.getNbWayPoints() - 1) {
            if (this.loopMode == LoopMode.Loop) {
                this.currentWayPoint = 0;
            } else {
                this.stop();
            }
        }
    }

    public void write(JmeExporter ex) throws IOException {
        super.write(ex);
        OutputCapsule oc = ex.getCapsule(this);
        oc.write(this.lookAt, "lookAt", Vector3f.ZERO);
        oc.write(this.upVector, "upVector", Vector3f.UNIT_Y);
        oc.write(this.rotation, "rotation", Quaternion.IDENTITY);
        oc.write(this.directionType, "directionType", Direction.None);
        oc.write(this.path, "path", null);
    }

    public void read(JmeImporter im) throws IOException {
        super.read(im);
        InputCapsule in = im.getCapsule(this);
        this.lookAt = (Vector3f)in.readSavable("lookAt", Vector3f.ZERO);
        this.upVector = (Vector3f)in.readSavable("upVector", Vector3f.UNIT_Y);
        this.rotation = (Quaternion)in.readSavable("rotation", Quaternion.IDENTITY);
        this.directionType = in.readEnum("directionType", Direction.class, Direction.None);
        this.path = (MotionPath)in.readSavable("path", null);
    }

    public boolean needsDirection() {
        return this.directionType == Direction.Path || this.directionType == Direction.PathAndRotation;
    }

    private void computeTargetDirection() {
        switch (this.directionType) {
            case Path: {
                Quaternion q = new Quaternion();
                q.lookAt(this.direction, Vector3f.UNIT_Y);
                this.spatial.setLocalRotation(q);
                break;
            }
            case LookAt: {
                if (this.lookAt == null) break;
                this.spatial.lookAt(this.lookAt, this.upVector);
                break;
            }
            case PathAndRotation: {
                if (this.rotation == null) break;
                Quaternion q2 = new Quaternion();
                q2.lookAt(this.direction, Vector3f.UNIT_Y);
                q2.multLocal(this.rotation);
                this.spatial.setLocalRotation(q2);
                break;
            }
            case Rotation: {
                if (this.rotation == null) break;
                this.spatial.setLocalRotation(this.rotation);
                break;
            }
            case None: {
                break;
            }
        }
    }

    public Control cloneForSpatial(Spatial spatial) {
        MotionTrack control = new MotionTrack(spatial, this.path);
        control.playState = this.playState;
        control.currentWayPoint = this.currentWayPoint;
        control.currentValue = this.currentValue;
        control.direction = this.direction.clone();
        control.lookAt = this.lookAt.clone();
        control.upVector = this.upVector.clone();
        control.rotation = this.rotation.clone();
        control.duration = this.duration;
        control.initialDuration = this.initialDuration;
        control.speed = this.speed;
        control.duration = this.duration;
        control.loopMode = this.loopMode;
        control.directionType = this.directionType;
        return control;
    }

    public void onPlay() {
    }

    public void onStop() {
        this.currentWayPoint = 0;
    }

    public void onPause() {
    }

    public float getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(float currentValue) {
        this.currentValue = currentValue;
    }

    public int getCurrentWayPoint() {
        return this.currentWayPoint;
    }

    public void setCurrentWayPoint(int currentWayPoint) {
        this.currentWayPoint = currentWayPoint;
    }

    public Vector3f getDirection() {
        return this.direction;
    }

    public void setDirection(Vector3f direction) {
        this.direction.set(direction);
    }

    public Direction getDirectionType() {
        return this.directionType;
    }

    public void setDirectionType(Direction directionType) {
        this.directionType = directionType;
    }

    public void setLookAt(Vector3f lookAt, Vector3f upVector) {
        this.lookAt = lookAt;
        this.upVector = upVector;
    }

    public Quaternion getRotation() {
        return this.rotation;
    }

    public void setRotation(Quaternion rotation) {
        this.rotation = rotation;
    }

    public MotionPath getPath() {
        return this.path;
    }

    public void setPath(MotionPath path) {
        this.path = path;
    }

    public void setEnabled(boolean enabled) {
        this.play();
    }

    public boolean isEnabled() {
        return this.playState != PlayState.Stopped;
    }

    public void render(RenderManager rm, ViewPort vp) {
    }

    public void setSpatial(Spatial spatial) {
        this.spatial = spatial;
    }

    public Spatial getSpatial() {
        return this.spatial;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        None,
        Path,
        PathAndRotation,
        Rotation,
        LookAt;

    }
}

