/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset;

import com.jme3.asset.AssetManager;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;

public class AssetConfig {
    private AssetManager manager;

    public AssetConfig(AssetManager manager) {
        this.manager = manager;
    }

    public void loadText(InputStream in) throws IOException {
        Scanner scan = new Scanner(in);
        while (scan.hasNext()) {
            String cmd = scan.next();
            if (cmd.equals("LOADER")) {
                String loaderClass = scan.next();
                String colon = scan.next();
                if (!colon.equals(":")) {
                    throw new IOException("Expected ':', got '" + colon + "'");
                }
                String extensionsList = scan.nextLine();
                String[] extensions = extensionsList.split(",");
                for (int i = 0; i < extensions.length; ++i) {
                    extensions[i] = extensions[i].trim();
                }
                this.manager.registerLoader(loaderClass, extensions);
                continue;
            }
            if (cmd.equals("LOCATOR")) {
                String rootPath = scan.next();
                String locatorClass = scan.nextLine().trim();
                this.manager.registerLocator(rootPath, locatorClass);
                continue;
            }
            throw new IOException("Expected command, got '" + cmd + "'");
        }
    }

    private static String readString(DataInput dataIn) throws IOException {
        int length = dataIn.readUnsignedShort();
        char[] chrs = new char[length];
        for (int i = 0; i < length; ++i) {
            chrs[i] = (char)dataIn.readUnsignedByte();
        }
        return String.valueOf(chrs);
    }
}

