/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.app;

import com.jme3.system.AppSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SettingsDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(SettingsDialog.class.getName());
    private static final long serialVersionUID = 1L;
    public static final int NO_SELECTION = 0;
    public static final int APPROVE_SELECTION = 1;
    public static final int CANCEL_SELECTION = 2;
    private final AppSettings source;
    private URL imageFile = null;
    private DisplayMode[] modes = null;
    private String[] windowedResolutions = new String[]{"320 x 240", "640 x 480", "800 x 600", "1024 x 768", "1152 x 864", "1280 x 720"};
    private JCheckBox vsyncBox = null;
    private JCheckBox fullscreenBox = null;
    private JComboBox displayResCombo = null;
    private JComboBox colorDepthCombo = null;
    private JComboBox displayFreqCombo = null;
    private JComboBox antialiasCombo = null;
    private JLabel icon = null;
    private int selection = 0;
    private SelectionListener selectionListener = null;

    public SettingsDialog(AppSettings source, String imageFile, boolean loadSettings) {
        this(source, SettingsDialog.getURL(imageFile), loadSettings);
    }

    public SettingsDialog(AppSettings source, URL imageFile, boolean loadSettings) {
        if (source == null) {
            throw new NullPointerException("Settings source cannot be null");
        }
        this.source = source;
        this.imageFile = imageFile;
        this.setModal(true);
        AppSettings registrySettings = new AppSettings(true);
        String appTitle = source.getTitle() != null ? source.getTitle() : registrySettings.getTitle();
        try {
            registrySettings.load(appTitle);
        }
        catch (BackingStoreException ex) {
            logger.log(Level.WARNING, "Failed to load settings", ex);
        }
        if (loadSettings) {
            source.copyFrom(registrySettings);
        } else if (!registrySettings.isEmpty()) {
            source.mergeFrom(registrySettings);
        }
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        this.modes = device.getDisplayModes();
        Arrays.sort(this.modes, new DisplayModeSorter());
        this.createUI();
    }

    public void setSelectionListener(SelectionListener sl) {
        this.selectionListener = sl;
    }

    public int getUserSelection() {
        return this.selection;
    }

    private void setUserSelection(int selection) {
        this.selection = selection;
        this.selectionListener.onSelection(selection);
    }

    public void setImage(String image) {
        try {
            URL file = new URL("file:" + image);
            this.setImage(file);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setImage(URL image) {
        this.icon.setIcon(new ImageIcon(image));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void showDialog() {
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.toFront();
    }

    private void createUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            logger.warning("Could not set native look and feel.");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SettingsDialog.this.setUserSelection(2);
                SettingsDialog.this.dispose();
            }
        });
        if (this.source.getIcons() != null) {
            this.safeSetIconImages(Arrays.asList((BufferedImage[])this.source.getIcons()));
        }
        this.setTitle("Select Display Settings");
        JPanel mainPanel = new JPanel();
        JPanel centerPanel = new JPanel();
        JPanel optionsPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("Ok");
        JButton cancel = new JButton("Cancel");
        this.icon = new JLabel(this.imageFile != null ? new ImageIcon(this.imageFile) : null);
        mainPanel.setLayout(new BorderLayout());
        centerPanel.setLayout(new BorderLayout());
        KeyAdapter aListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (SettingsDialog.this.verifyAndSaveCurrentSelection()) {
                        SettingsDialog.this.setUserSelection(1);
                        SettingsDialog.this.dispose();
                    }
                } else if (e.getKeyCode() == 27) {
                    SettingsDialog.this.setUserSelection(2);
                    SettingsDialog.this.dispose();
                }
            }
        };
        this.displayResCombo = this.setUpResolutionChooser();
        this.displayResCombo.addKeyListener(aListener);
        this.colorDepthCombo = new JComboBox();
        this.colorDepthCombo.addKeyListener(aListener);
        this.displayFreqCombo = new JComboBox();
        this.displayFreqCombo.addKeyListener(aListener);
        this.antialiasCombo = new JComboBox();
        this.antialiasCombo.addKeyListener(aListener);
        this.fullscreenBox = new JCheckBox("Fullscreen?");
        this.fullscreenBox.setSelected(this.source.isFullscreen());
        this.fullscreenBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.updateResolutionChoices();
            }
        });
        this.vsyncBox = new JCheckBox("VSync?");
        this.vsyncBox.setSelected(this.source.isVSync());
        this.updateResolutionChoices();
        this.updateAntialiasChoices();
        this.displayResCombo.setSelectedItem(this.source.getWidth() + " x " + this.source.getHeight());
        this.colorDepthCombo.setSelectedItem(this.source.getBitsPerPixel() + " bpp");
        optionsPanel.add(this.displayResCombo);
        optionsPanel.add(this.colorDepthCombo);
        optionsPanel.add(this.displayFreqCombo);
        optionsPanel.add(this.antialiasCombo);
        optionsPanel.add(this.fullscreenBox);
        optionsPanel.add(this.vsyncBox);
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (SettingsDialog.this.verifyAndSaveCurrentSelection()) {
                    SettingsDialog.this.setUserSelection(1);
                    SettingsDialog.this.dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.setUserSelection(2);
                SettingsDialog.this.dispose();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        if (this.icon != null) {
            centerPanel.add((Component)this.icon, "North");
        }
        centerPanel.add((Component)optionsPanel, "South");
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)buttonPanel, "South");
        this.getContentPane().add(mainPanel);
        this.pack();
    }

    private void safeSetIconImages(List<? extends Image> icons) {
        try {
            Window owner = this.getOwner();
            if (owner != null) {
                Method setIconImages = owner.getClass().getMethod("setIconImages", List.class);
                setIconImages.invoke((Object)owner, icons);
                return;
            }
            Method setIconImages = this.getClass().getMethod("setIconImages", List.class);
            setIconImages.invoke((Object)this, icons);
        }
        catch (Exception e) {
            return;
        }
    }

    private boolean verifyAndSaveCurrentSelection() {
        String display = (String)this.displayResCombo.getSelectedItem();
        boolean fullscreen = this.fullscreenBox.isSelected();
        boolean vsync = this.vsyncBox.isSelected();
        int width = Integer.parseInt(display.substring(0, display.indexOf(" x ")));
        display = display.substring(display.indexOf(" x ") + 3);
        int height = Integer.parseInt(display);
        String depthString = (String)this.colorDepthCombo.getSelectedItem();
        int depth = -1;
        depth = depthString.equals("???") ? 0 : Integer.parseInt(depthString.substring(0, depthString.indexOf(32)));
        String freqString = (String)this.displayFreqCombo.getSelectedItem();
        int freq = -1;
        if (fullscreen) {
            freq = freqString.equals("???") ? 0 : Integer.parseInt(freqString.substring(0, freqString.indexOf(32)));
        }
        String aaString = (String)this.antialiasCombo.getSelectedItem();
        int multisample = -1;
        multisample = aaString.equals("Disabled") ? 0 : Integer.parseInt(aaString.substring(0, aaString.indexOf(120)));
        String renderer = "LWJGL-OpenGL2";
        boolean valid = false;
        if (!fullscreen) {
            valid = true;
        } else {
            GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            valid = device.isFullScreenSupported();
        }
        if (valid) {
            this.source.setWidth(width);
            this.source.setHeight(height);
            this.source.setBitsPerPixel(depth);
            this.source.setFrequency(freq);
            this.source.setFullscreen(fullscreen);
            this.source.setVSync(vsync);
            this.source.setSamples(multisample);
            String appTitle = this.source.getTitle();
            try {
                this.source.save(appTitle);
            }
            catch (BackingStoreException ex) {
                logger.log(Level.WARNING, "Failed to save setting changes", ex);
            }
        } else {
            SettingsDialog.showError(this, "Your monitor claims to not support the display mode you've selected.\nThe combination of bit depth and refresh rate is not supported.");
        }
        return valid;
    }

    private JComboBox setUpResolutionChooser() {
        String[] res = SettingsDialog.getResolutions(this.modes);
        JComboBox<String> resolutionBox = new JComboBox<String>(res);
        resolutionBox.setSelectedItem(this.source.getWidth() + " x " + this.source.getHeight());
        resolutionBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SettingsDialog.this.updateDisplayChoices();
            }
        });
        return resolutionBox;
    }

    private JComboBox setUpRendererChooser() {
        String[] modes = new String[]{"NULL", "JOGL-OpenGL1", "LWJGL-OpenGL2", "LWJGL-OpenGL3", "LWJGL-OpenGL3.1"};
        JComboBox<String> nameBox = new JComboBox<String>(modes);
        nameBox.setSelectedItem(this.source.getRenderer());
        return nameBox;
    }

    private void updateDisplayChoices() {
        String displayFreq;
        if (!this.fullscreenBox.isSelected()) {
            return;
        }
        String resolution = (String)this.displayResCombo.getSelectedItem();
        String colorDepth = (String)this.colorDepthCombo.getSelectedItem();
        if (colorDepth == null) {
            colorDepth = this.source.getBitsPerPixel() + " bpp";
        }
        if ((displayFreq = (String)this.displayFreqCombo.getSelectedItem()) == null) {
            displayFreq = this.source.getFrequency() + " Hz";
        }
        String[] depths = SettingsDialog.getDepths(resolution, this.modes);
        this.colorDepthCombo.setModel(new DefaultComboBoxModel<String>(depths));
        this.colorDepthCombo.setSelectedItem(colorDepth);
        String[] freqs = SettingsDialog.getFrequencies(resolution, this.modes);
        this.displayFreqCombo.setModel(new DefaultComboBoxModel<String>(freqs));
        this.displayFreqCombo.setSelectedItem(displayFreq);
    }

    private void updateResolutionChoices() {
        if (!this.fullscreenBox.isSelected()) {
            this.displayResCombo.setModel(new DefaultComboBoxModel<String>(this.windowedResolutions));
            this.colorDepthCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"24 bpp", "16 bpp"}));
            this.displayFreqCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"n/a"}));
            this.displayFreqCombo.setEnabled(false);
        } else {
            this.displayResCombo.setModel(new DefaultComboBoxModel<String>(SettingsDialog.getResolutions(this.modes)));
            this.displayFreqCombo.setEnabled(true);
            this.updateDisplayChoices();
        }
    }

    private void updateAntialiasChoices() {
        String[] choices = new String[]{"Disabled", "2x", "4x", "6x", "8x", "16x"};
        this.antialiasCombo.setModel(new DefaultComboBoxModel<String>(choices));
        this.antialiasCombo.setSelectedItem(choices[Math.min(this.source.getSamples() / 2, 5)]);
    }

    private static URL getURL(String file) {
        URL url = null;
        try {
            url = new URL("file:" + file);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    private static void showError(Component parent, String message) {
        JOptionPane.showMessageDialog(parent, message, "Error", 0);
    }

    private static String[] getResolutions(DisplayMode[] modes) {
        ArrayList<String> resolutions = new ArrayList<String>(modes.length);
        for (int i = 0; i < modes.length; ++i) {
            String res = modes[i].getWidth() + " x " + modes[i].getHeight();
            if (resolutions.contains(res)) continue;
            resolutions.add(res);
        }
        String[] res = new String[resolutions.size()];
        resolutions.toArray(res);
        return res;
    }

    private static String[] getDepths(String resolution, DisplayMode[] modes) {
        ArrayList<String> depths = new ArrayList<String>(4);
        for (int i = 0; i < modes.length; ++i) {
            if (modes[i].getBitDepth() < 16 && modes[i].getBitDepth() > 0) continue;
            String res = modes[i].getWidth() + " x " + modes[i].getHeight();
            String depth = modes[i].getBitDepth() + " bpp";
            if (!res.equals(resolution) || depths.contains(depth)) continue;
            depths.add(depth);
        }
        if (depths.size() == 1 && depths.contains("-1 bpp")) {
            depths.clear();
            depths.add("24 bpp");
        }
        String[] res = new String[depths.size()];
        depths.toArray(res);
        return res;
    }

    private static String[] getFrequencies(String resolution, DisplayMode[] modes) {
        ArrayList<String> freqs = new ArrayList<String>(4);
        for (int i = 0; i < modes.length; ++i) {
            String res = modes[i].getWidth() + " x " + modes[i].getHeight();
            String freq = modes[i].getRefreshRate() == 0 ? "???" : modes[i].getRefreshRate() + " Hz";
            if (!res.equals(resolution) || freqs.contains(freq)) continue;
            freqs.add(freq);
        }
        String[] res = new String[freqs.size()];
        freqs.toArray(res);
        return res;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DisplayModeSorter
    implements Comparator<DisplayMode> {
        private DisplayModeSorter() {
        }

        @Override
        public int compare(DisplayMode a, DisplayMode b) {
            if (a.getWidth() != b.getWidth()) {
                return a.getWidth() > b.getWidth() ? 1 : -1;
            }
            if (a.getHeight() != b.getHeight()) {
                return a.getHeight() > b.getHeight() ? 1 : -1;
            }
            if (a.getBitDepth() != b.getBitDepth()) {
                return a.getBitDepth() > b.getBitDepth() ? 1 : -1;
            }
            if (a.getRefreshRate() != b.getRefreshRate()) {
                return a.getRefreshRate() > b.getRefreshRate() ? 1 : -1;
            }
            return 0;
        }
    }

    public static interface SelectionListener {
        public void onSelection(int var1);
    }
}

