/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.animation;

import com.jme3.animation.Pose;
import com.jme3.animation.Track;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import java.io.IOException;
import java.nio.FloatBuffer;

public final class PoseTrack
extends Track {
    private PoseFrame[] frames;
    private float[] times;

    public PoseTrack(int targetMeshIndex, float[] times, PoseFrame[] frames) {
        super(targetMeshIndex);
        this.times = times;
        this.frames = frames;
    }

    private void applyFrame(Mesh target, int frameIndex, float weight) {
        PoseFrame frame = this.frames[frameIndex];
        VertexBuffer pb = target.getBuffer(VertexBuffer.Type.Position);
        for (int i = 0; i < frame.poses.length; ++i) {
            Pose pose = frame.poses[i];
            float poseWeight = frame.weights[i] * weight;
            pose.apply(poseWeight, (FloatBuffer)pb.getData());
        }
        pb.updateData(pb.getData());
    }

    public void setTime(float time, Mesh[] targets, float weight) {
        Mesh target = targets[this.targetMeshIndex];
        if (time < this.times[0]) {
            this.applyFrame(target, 0, weight);
        } else if (time > this.times[this.times.length - 1]) {
            this.applyFrame(target, this.times.length - 1, weight);
        } else {
            int startFrame = 0;
            for (int i = 0; i < this.times.length; ++i) {
                if (!(this.times[i] < time)) continue;
                startFrame = i;
            }
            int endFrame = startFrame + 1;
            float blend = (time - this.times[startFrame]) / (this.times[endFrame] - this.times[startFrame]);
            this.applyFrame(target, startFrame, blend * weight);
            this.applyFrame(target, endFrame, (1.0f - blend) * weight);
        }
    }

    public void write(JmeExporter e) throws IOException {
        OutputCapsule out = e.getCapsule(this);
        out.write(this.frames, "frames", null);
        out.write(this.times, "times", (float[])null);
    }

    public void read(JmeImporter i) throws IOException {
        InputCapsule in = i.getCapsule(this);
        this.frames = (PoseFrame[])in.readSavableArray("frames", null);
        this.times = in.readFloatArray("times", null);
    }

    public static class PoseFrame
    implements Savable {
        Pose[] poses;
        float[] weights;

        public PoseFrame(Pose[] poses, float[] weights) {
            this.poses = poses;
            this.weights = weights;
        }

        public void write(JmeExporter e) throws IOException {
            OutputCapsule out = e.getCapsule(this);
            out.write(this.poses, "poses", null);
            out.write(this.weights, "weights", (float[])null);
        }

        public void read(JmeImporter i) throws IOException {
            InputCapsule in = i.getCapsule(this);
            this.poses = (Pose[])in.readSavableArray("poses", null);
            this.weights = in.readFloatArray("weights", null);
        }
    }
}

