/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jkate;

import com.jcraft.jogg.Buffer;

public class Bitwise {
    private static final int fp_bits = 32;
    private static final int fp_cuts_bits_bits = 4;

    static void readbuf(Buffer opb, byte[] buf, int len) {
        for (int i = 0; i < len; ++i) {
            buf[i] = (byte)opb.read(8);
        }
    }

    static int read32(Buffer opb) {
        int value = opb.read(8);
        value |= opb.read(8) << 8;
        value |= opb.read(8) << 16;
        return value |= opb.read(8) << 24;
    }

    static int read32v(Buffer opb) {
        int value = opb.read(4);
        if (value == 15) {
            int sign = opb.read(1);
            int bits = opb.read(5) + 1;
            value = opb.read(bits);
            if (sign != 0) {
                value = -value;
            }
        }
        return value;
    }

    static long read64(Buffer opb) {
        long vl = Bitwise.read32(opb);
        long vh = Bitwise.read32(opb);
        return vl | vh << 32;
    }

    static int skipWarp(Buffer opb) {
        int bits;
        while ((bits = Bitwise.read32v(opb)) != 0) {
            if (bits < 0) {
                return -6;
            }
            opb.adv(bits);
        }
        return 0;
    }

    private static int[] readFixed(Buffer opb, int count) {
        int head = opb.read(4);
        int tail = opb.read(4);
        int bits = 32 - head - tail;
        int[] values = new int[count];
        int n = 0;
        while (count-- > 0) {
            int sign = 0;
            if (head > 0) {
                sign = opb.read1();
            }
            int v = opb.read(bits);
            v <<= tail;
            if (sign != 0) {
                v = -v;
            }
            values[n++] = v;
        }
        return values;
    }

    private static double fixedToFloat(int v) {
        return (double)v / 65536.0;
    }

    static double[][] readFloats(Buffer opb, int count, int streams) {
        if (count * streams == 0) {
            return null;
        }
        if (streams > 1 && opb.read1() != 0) {
            count *= streams;
            streams = 1;
        }
        double[][] values = new double[streams][];
        for (int s = 0; s < streams; ++s) {
            int[] ints = Bitwise.readFixed(opb, count);
            values[s] = new double[count];
            for (int c = 0; c < count; ++c) {
                values[s][c] = Bitwise.fixedToFloat(ints[c]);
            }
        }
        return values;
    }
}

