/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.sound.openal.slick;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import de.lessvoid.nifty.sound.openal.slick.AudioInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;

public class OggInputStream
extends InputStream
implements AudioInputStream {
    private Logger log;
    private int convsize;
    private byte[] convbuffer;
    private InputStream input;
    private Info oggInfo;
    private boolean endOfStream;
    private SyncState syncState;
    private StreamState streamState;
    private Page page;
    private Packet packet;
    private Comment comment;
    private DspState dspState;
    private Block vorbisBlock;
    byte[] buffer;
    int bytes;
    boolean bigEndian;
    boolean endOfBitStream;
    boolean inited;
    private int readIndex;
    private ByteBuffer pcmBuffer;
    private int total;
    static /* synthetic */ Class class$0;

    public OggInputStream(InputStream input) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.lessvoid.nifty.sound.openal.slick.OggInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
        this.convsize = 16384;
        this.convbuffer = new byte[this.convsize];
        this.oggInfo = new Info();
        this.syncState = new SyncState();
        this.streamState = new StreamState();
        this.page = new Page();
        this.packet = new Packet();
        this.comment = new Comment();
        this.dspState = new DspState();
        this.vorbisBlock = new Block(this.dspState);
        this.bytes = 0;
        this.bigEndian = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
        this.endOfBitStream = true;
        this.inited = false;
        this.pcmBuffer = BufferUtils.createByteBuffer((int)2048000);
        this.input = input;
        this.total = input.available();
        this.init();
    }

    public int getLength() {
        return this.total;
    }

    public int getChannels() {
        return this.oggInfo.channels;
    }

    public int getRate() {
        return this.oggInfo.rate;
    }

    private void init() throws IOException {
        this.initVorbis();
        this.readPCM();
    }

    public int available() {
        return this.endOfStream ? 0 : 1;
    }

    private void initVorbis() {
        this.syncState.init();
    }

    /*
     * Unable to fully structure code
     */
    private boolean getPageAndPacket() {
        block16: {
            index = this.syncState.buffer(4096);
            this.buffer = this.syncState.data;
            if (this.buffer == null) {
                this.endOfStream = true;
                return false;
            }
            try {
                this.bytes = this.input.read(this.buffer, index, 4096);
            }
            catch (Exception e) {
                this.log.warning("Failure reading in vorbis: " + e.getMessage());
                this.endOfStream = true;
                return false;
            }
            this.syncState.wrote(this.bytes);
            if (this.syncState.pageout(this.page) != 1) {
                if (this.bytes < 4096) {
                    return false;
                }
                this.log.warning("Input does not appear to be an Ogg bitstream.");
                this.endOfStream = true;
                return false;
            }
            this.streamState.init(this.page.serialno());
            this.oggInfo.init();
            this.comment.init();
            if (this.streamState.pagein(this.page) < 0) {
                this.log.warning("Error reading first page of Ogg bitstream data.");
                this.endOfStream = true;
                return false;
            }
            if (this.streamState.packetout(this.packet) != 1) {
                this.log.warning("Error reading initial header packet.");
                this.endOfStream = true;
                return false;
            }
            if (this.oggInfo.synthesis_headerin(this.comment, this.packet) < 0) {
                this.log.warning("This Ogg bitstream does not contain Vorbis audio data.");
                this.endOfStream = true;
                return false;
            }
            i = 0;
            break block16;
            while ((result = this.syncState.pageout(this.page)) != 0) {
                if (result == 1) {
                    this.streamState.pagein(this.page);
                    while (i < 2) {
                        result = this.streamState.packetout(this.packet);
                        if (result == 0) break;
                        if (result == -1) {
                            this.log.warning("Corrupt secondary header.  Exiting.");
                            this.endOfStream = true;
                            return false;
                        }
                        this.oggInfo.synthesis_headerin(this.comment, this.packet);
                        ++i;
                    }
                }
lbl53:
                // 5 sources

                ** while (i >= 2)
lbl54:
                // 1 sources

            }
lbl55:
            // 2 sources

            index = this.syncState.buffer(4096);
            this.buffer = this.syncState.data;
            try {
                this.bytes = this.input.read(this.buffer, index, 4096);
            }
            catch (Exception e) {
                this.log.warning("Failed to read Vorbis: " + e.getMessage());
                this.endOfStream = true;
                return false;
            }
            if (this.bytes == 0 && i < 2) {
                this.log.warning("End of file before finding all Vorbis headers!");
                this.endOfStream = true;
                return false;
            }
            this.syncState.wrote(this.bytes);
        }
        if (i < 2) ** GOTO lbl53
        this.convsize = 4096 / this.oggInfo.channels;
        this.dspState.synthesis_init(this.oggInfo);
        this.vorbisBlock.init(this.dspState);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void readPCM() throws IOException {
        wrote = false;
        while (true) {
            block27: {
                if (this.endOfBitStream) {
                    if (!this.getPageAndPacket()) break;
                    this.endOfBitStream = false;
                }
                if (!this.inited) {
                    this.inited = true;
                    return;
                }
                _pcm = new float[1][][];
                _index = new int[this.oggInfo.channels];
                break block27;
                while ((result = this.syncState.pageout(this.page)) != 0) {
                    if (result == -1) {
                        this.log.warning("Corrupt or missing data in bitstream; continuing...");
                    } else {
                        this.streamState.pagein(this.page);
                        while ((result = this.streamState.packetout(this.packet)) != 0) {
                            if (result == -1) continue;
                            if (this.vorbisBlock.synthesis(this.packet) == 0) {
                                this.dspState.synthesis_blockin(this.vorbisBlock);
                            }
                            while ((samples = this.dspState.synthesis_pcmout((float[][][])_pcm, _index)) > 0) {
                                pcm = _pcm[0];
                                bout = samples < this.convsize ? samples : this.convsize;
                                i = 0;
                                while (i < this.oggInfo.channels) {
                                    ptr = i * 2;
                                    mono = _index[i];
                                    j = 0;
                                    while (j < bout) {
                                        val = (int)((double)pcm[i][mono + j] * 32767.0);
                                        if (val > 32767) {
                                            val = 32767;
                                        }
                                        if (val < -32768) {
                                            val = -32768;
                                        }
                                        if (val < 0) {
                                            val |= 32768;
                                        }
                                        if (this.bigEndian) {
                                            this.convbuffer[ptr] = (byte)(val >>> 8);
                                            this.convbuffer[ptr + 1] = (byte)val;
                                        } else {
                                            this.convbuffer[ptr] = (byte)val;
                                            this.convbuffer[ptr + 1] = (byte)(val >>> 8);
                                        }
                                        ptr += 2 * this.oggInfo.channels;
                                        ++j;
                                    }
                                    ++i;
                                }
                                bytesToWrite = 2 * this.oggInfo.channels * bout;
                                if (bytesToWrite >= this.pcmBuffer.remaining()) {
                                    this.log.warning("Read block from OGG that was too big to be buffered: " + bytesToWrite);
                                } else {
                                    this.pcmBuffer.put(this.convbuffer, 0, bytesToWrite);
                                }
                                wrote = true;
                                this.dspState.synthesis_read(bout);
                            }
                        }
                        if (this.page.eos() != 0) {
                            this.endOfBitStream = true;
                        }
                        if (!this.endOfBitStream && wrote) {
                            return;
                        }
                    }
lbl65:
                    // 4 sources

                    ** while (this.endOfBitStream)
lbl66:
                    // 1 sources

                }
lbl67:
                // 2 sources

                if (!this.endOfBitStream) {
                    this.bytes = 0;
                    index = this.syncState.buffer(4096);
                    if (index >= 0) {
                        this.buffer = this.syncState.data;
                        try {
                            this.bytes = this.input.read(this.buffer, index, 4096);
                        }
                        catch (Exception e) {
                            this.log.warning("Failure during vorbis decoding: " + e.getMessage());
                            this.endOfStream = true;
                            return;
                        }
                    } else {
                        this.bytes = 0;
                    }
                    this.syncState.wrote(this.bytes);
                    if (this.bytes == 0) {
                        this.endOfBitStream = true;
                    }
                }
            }
            if (!this.endOfBitStream) ** GOTO lbl65
            this.streamState.clear();
            this.vorbisBlock.clear();
            this.dspState.clear();
            this.oggInfo.clear();
        }
        this.syncState.clear();
        this.endOfStream = true;
    }

    public int read() throws IOException {
        if (this.readIndex >= this.pcmBuffer.position()) {
            this.pcmBuffer.clear();
            this.readPCM();
            this.readIndex = 0;
        }
        if (this.readIndex >= this.pcmBuffer.position()) {
            return -1;
        }
        int value = this.pcmBuffer.get(this.readIndex);
        if (value < 0) {
            value += 256;
        }
        ++this.readIndex;
        return value;
    }

    public boolean atEnd() {
        return this.endOfStream && this.readIndex >= this.pcmBuffer.position();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            block5: {
                block6: {
                    try {
                        int value = this.read();
                        if (value >= 0) {
                            b[i] = (byte)value;
                            break block5;
                        }
                        if (i != 0) break block6;
                        return -1;
                    }
                    catch (IOException e) {
                        this.log.warning(e.getMessage());
                        return i;
                    }
                }
                return i;
            }
            ++i;
        }
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void close() throws IOException {
    }
}

