/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.renderer.lwjgl.input;

import de.lessvoid.nifty.NiftyInputConsumer;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.renderer.lwjgl.input.LwjglKeyboardInputEventCreator;
import de.lessvoid.nifty.spi.input.InputSystem;
import java.nio.IntBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class LwjglInputSystem
implements InputSystem {
    private Logger log = Logger.getLogger(LwjglInputSystem.class.getName());
    private LwjglKeyboardInputEventCreator keyboardEventCreator = new LwjglKeyboardInputEventCreator();
    private IntBuffer viewportBuffer = BufferUtils.createIntBuffer((int)16);
    private ConcurrentLinkedQueue<MouseInputEvent> mouseEventsOut = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<KeyboardInputEvent> keyboardEventsOut = new ConcurrentLinkedQueue();
    public boolean niftyHasKeyboardFocus = true;
    public boolean niftyTakesKeyboardFocusOnClick = false;

    public void startup() throws Exception {
        Mouse.create();
        Keyboard.create();
        Keyboard.enableRepeatEvents((boolean)true);
        this.logMouseCapabilities();
    }

    public void shutdown() {
        Mouse.destroy();
        Keyboard.destroy();
    }

    public void forwardEvents(NiftyInputConsumer inputEventConsumer) {
        this.mouseEventsOut.clear();
        this.keyboardEventsOut.clear();
        this.processMouseEvents(inputEventConsumer);
        this.processKeyboardEvents(inputEventConsumer);
    }

    public void setMousePosition(int x, int y) {
        int viewportHeight = this.getViewportHeight();
        Mouse.setCursorPosition((int)x, (int)(viewportHeight - y));
    }

    public boolean hasNextMouseEvent() {
        return this.mouseEventsOut.peek() != null;
    }

    public MouseInputEvent nextMouseEvent() {
        return this.mouseEventsOut.poll();
    }

    public boolean hasNextKeyboardEvent() {
        return this.keyboardEventsOut.peek() != null;
    }

    public KeyboardInputEvent nextKeyboardEvent() {
        return this.keyboardEventsOut.poll();
    }

    private void processMouseEvents(NiftyInputConsumer inputEventConsumer) {
        int viewportHeight = this.getViewportHeight();
        while (Mouse.next()) {
            boolean buttonDown;
            int button;
            int mouseWheel;
            int mouseY;
            int mouseX = Mouse.getEventX();
            boolean mouseEventProcessedByNifty = inputEventConsumer.processMouseEvent(mouseX, mouseY = viewportHeight - Mouse.getEventY(), mouseWheel = Mouse.getEventDWheel() / 120, button = Mouse.getEventButton(), buttonDown = Mouse.getEventButtonState());
            if (!mouseEventProcessedByNifty) {
                this.log.fine("Nifty did not processed this mouse event. You can handle it.");
                this.mouseEventsOut.offer(new MouseInputEvent(mouseX, mouseY, mouseWheel, button, buttonDown));
                if (!this.niftyTakesKeyboardFocusOnClick) continue;
                this.log.fine("Nifty gave up the keyboard focus");
                this.niftyHasKeyboardFocus = false;
                continue;
            }
            this.log.fine("Nifty has processed this mouse event");
            if (!this.niftyTakesKeyboardFocusOnClick) continue;
            this.log.fine("Nifty takes the keyboard focus back");
            this.niftyHasKeyboardFocus = true;
        }
    }

    private void processKeyboardEvents(NiftyInputConsumer inputEventConsumer) {
        while (Keyboard.next()) {
            KeyboardInputEvent event = this.keyboardEventCreator.createEvent(Keyboard.getEventKey(), Keyboard.getEventCharacter(), Keyboard.getEventKeyState());
            if (this.niftyHasKeyboardFocus && inputEventConsumer.processKeyboardEvent(event)) continue;
            this.keyboardEventsOut.offer(event);
        }
    }

    private int getViewportHeight() {
        GL11.glGetInteger((int)2978, (IntBuffer)this.viewportBuffer);
        return this.viewportBuffer.get(3);
    }

    private void logMouseCapabilities() {
        int caps = Cursor.getCapabilities();
        StringBuffer out = new StringBuffer();
        if ((caps & 1) != 0) {
            LwjglInputSystem.add(out, "CURSOR_ONE_BIT_TRANSPARENCY");
        }
        if ((caps & 2) != 0) {
            LwjglInputSystem.add(out, "CURSOR_8_BIT_ALPHA");
        }
        if ((caps & 4) != 0) {
            LwjglInputSystem.add(out, "CURSOR_ANIMATION");
        }
        this.log.info("native cursor support (" + caps + ") -> [" + out.toString() + "]");
        this.log.info("native cursor min size: " + Cursor.getMinCursorSize());
        this.log.info("native cursor max size: " + Cursor.getMaxCursorSize());
    }

    private static void add(StringBuffer out, String text) {
        if (out.length() > 0) {
            out.append(", ");
        }
        out.append(text);
    }

    public class MouseInputEvent {
        public float mouseX;
        public float mouseY;
        public float pmouseX;
        public float pmouseY;
        public int button;
        public int scroll;
        public boolean buttonDown;

        MouseInputEvent(float mx, float my, int scroll, int button, boolean buttonDown) {
            this.mouseX = mx;
            this.mouseY = my;
            this.button = button;
            this.scroll = scroll;
            this.buttonDown = buttonDown;
        }

        public String toString() {
            return this.button + "=" + this.buttonDown + " at " + this.mouseX + "," + this.mouseY + " scroll:" + this.scroll;
        }
    }
}

