/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.control.ragdoll;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.bullet.collision.shapes.HullCollisionShape;
import com.jme3.bullet.joints.SixDofJoint;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RagdollUtils {
    public static void setJointLimit(SixDofJoint sixDofJoint, float f, float f2, float f3, float f4, float f5, float f6) {
        sixDofJoint.getRotationalLimitMotor(0).setHiLimit(f);
        sixDofJoint.getRotationalLimitMotor(0).setLoLimit(f2);
        sixDofJoint.getRotationalLimitMotor(1).setHiLimit(f3);
        sixDofJoint.getRotationalLimitMotor(1).setLoLimit(f4);
        sixDofJoint.getRotationalLimitMotor(2).setHiLimit(f5);
        sixDofJoint.getRotationalLimitMotor(2).setLoLimit(f6);
    }

    public static Map<Integer, List<Float>> buildPointMap(Spatial spatial) {
        HashMap<Integer, List<Float>> hashMap = new HashMap<Integer, List<Float>>();
        if (spatial instanceof Geometry) {
            Geometry geometry = (Geometry)spatial;
            RagdollUtils.buildPointMapForMesh(geometry.getMesh(), hashMap);
        } else if (spatial instanceof Node) {
            Node node = (Node)spatial;
            for (Spatial spatial2 : node.getChildren()) {
                if (!(spatial2 instanceof Geometry)) continue;
                Geometry geometry = (Geometry)spatial2;
                RagdollUtils.buildPointMapForMesh(geometry.getMesh(), hashMap);
            }
        }
        return hashMap;
    }

    private static Map<Integer, List<Float>> buildPointMapForMesh(Mesh mesh, Map<Integer, List<Float>> map) {
        FloatBuffer floatBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        ByteBuffer byteBuffer = (ByteBuffer)mesh.getBuffer(VertexBuffer.Type.BoneIndex).getData();
        FloatBuffer floatBuffer2 = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
        floatBuffer.rewind();
        byteBuffer.rewind();
        floatBuffer2.rewind();
        int n = mesh.getVertexCount() * 3;
        float f = 0.0f;
        for (int i = 0; i < n; i += 3) {
            int n2 = i / 3 * 4;
            int n3 = 0;
            f = -1.0f;
            for (int j = n2; j < n2 + 4; ++j) {
                float f2 = floatBuffer2.get(j);
                if (!(f2 > f)) continue;
                f = f2;
                n3 = byteBuffer.get(j);
            }
            List<Float> list = map.get(n3);
            if (list == null) {
                list = new ArrayList<Float>();
                map.put(n3, list);
            }
            list.add(Float.valueOf(floatBuffer.get(i)));
            list.add(Float.valueOf(floatBuffer.get(i + 1)));
            list.add(Float.valueOf(floatBuffer.get(i + 2)));
        }
        return map;
    }

    public static HullCollisionShape makeShapeFromPointMap(Map<Integer, List<Float>> map, List<Integer> list, Vector3f vector3f, Vector3f vector3f2) {
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (Integer n : list) {
            List<Float> list2 = map.get(n);
            if (list2 == null) continue;
            for (int i = 0; i < list2.size(); i += 3) {
                Vector3f vector3f3 = new Vector3f();
                vector3f3.x = list2.get(i).floatValue();
                vector3f3.y = list2.get(i + 1).floatValue();
                vector3f3.z = list2.get(i + 2).floatValue();
                vector3f3.subtractLocal(vector3f2).multLocal(vector3f);
                arrayList.add(Float.valueOf(vector3f3.x));
                arrayList.add(Float.valueOf(vector3f3.y));
                arrayList.add(Float.valueOf(vector3f3.z));
            }
        }
        Object object = new float[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = ((Float)arrayList.get(i)).floatValue();
        }
        return new HullCollisionShape((float[])object);
    }

    public static List<Integer> getBoneIndices(Bone bone, Skeleton skeleton, Set<String> set) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        if (set.isEmpty()) {
            linkedList.add(skeleton.getBoneIndex(bone));
        } else {
            linkedList.add(skeleton.getBoneIndex(bone));
            for (Bone bone2 : bone.getChildren()) {
                if (set.contains(bone2.getName())) continue;
                linkedList.addAll(RagdollUtils.getBoneIndices(bone2, skeleton, set));
            }
        }
        return linkedList;
    }

    public static HullCollisionShape makeShapeFromVerticeWeights(Spatial spatial, List<Integer> list, Vector3f vector3f, Vector3f vector3f2, float f) {
        Object object;
        ArrayList<Float> arrayList = new ArrayList<Float>();
        if (spatial instanceof Geometry) {
            object = (Geometry)spatial;
            for (Integer n : list) {
                arrayList.addAll(RagdollUtils.getPoints(object.getMesh(), n, vector3f, vector3f2, f));
            }
        } else if (spatial instanceof Node) {
            object = (Node)spatial;
            for (Integer n : object.getChildren()) {
                if (!(n instanceof Geometry)) continue;
                Geometry geometry = (Geometry)n;
                for (Integer n2 : list) {
                    arrayList.addAll(RagdollUtils.getPoints(geometry.getMesh(), n2, vector3f, vector3f2, f));
                }
            }
        }
        object = new float[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object[i] = (Geometry)((Float)arrayList.get(i)).floatValue();
        }
        return new HullCollisionShape((float[])object);
    }

    private static List<Float> getPoints(Mesh mesh, int n, Vector3f vector3f, Vector3f vector3f2, float f) {
        FloatBuffer floatBuffer = mesh.getFloatBuffer(VertexBuffer.Type.Position);
        ByteBuffer byteBuffer = (ByteBuffer)mesh.getBuffer(VertexBuffer.Type.BoneIndex).getData();
        FloatBuffer floatBuffer2 = (FloatBuffer)mesh.getBuffer(VertexBuffer.Type.BoneWeight).getData();
        floatBuffer.rewind();
        byteBuffer.rewind();
        floatBuffer2.rewind();
        ArrayList<Float> arrayList = new ArrayList<Float>();
        int n2 = mesh.getVertexCount() * 3;
        for (int i = 0; i < n2; i += 3) {
            int n3;
            boolean bl = false;
            for (int j = n3 = i / 3 * 4; j < n3 + 4; ++j) {
                if (byteBuffer.get(j) != n || !(floatBuffer2.get(j) >= f)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            Vector3f vector3f3 = new Vector3f();
            vector3f3.x = floatBuffer.get(i);
            vector3f3.y = floatBuffer.get(i + 1);
            vector3f3.z = floatBuffer.get(i + 2);
            vector3f3.subtractLocal(vector3f2).multLocal(vector3f);
            arrayList.add(Float.valueOf(vector3f3.x));
            arrayList.add(Float.valueOf(vector3f3.y));
            arrayList.add(Float.valueOf(vector3f3.z));
        }
        return arrayList;
    }

    public static void setTransform(Bone bone, Vector3f vector3f, Quaternion quaternion, boolean bl, Set<String> set) {
        if (bl) {
            bone.setUserControl(true);
        }
        bone.setUserTransformsWorld(vector3f, quaternion);
        for (Bone bone2 : bone.getChildren()) {
            if (set.contains(bone2.getName())) continue;
            Transform transform = bone2.getCombinedTransform(vector3f, quaternion);
            RagdollUtils.setTransform(bone2, transform.getTranslation(), transform.getRotation(), bl, set);
        }
        if (bl) {
            bone.setUserControl(false);
        }
    }

    public static void setUserControl(Bone bone, boolean bl) {
        bone.setUserControl(bl);
        for (Bone bone2 : bone.getChildren()) {
            RagdollUtils.setUserControl(bone2, bl);
        }
    }
}

