/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.bullet.collision.shapes;

import com.jme3.bullet.collision.shapes.CollisionShape;
import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.export.Savable;
import com.jme3.math.Vector3f;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CylinderCollisionShape
extends CollisionShape {
    protected Vector3f halfExtents;
    protected int axis;

    public CylinderCollisionShape() {
    }

    public CylinderCollisionShape(Vector3f vector3f) {
        this.halfExtents = vector3f;
        this.axis = 2;
        this.createShape();
    }

    public CylinderCollisionShape(Vector3f vector3f, int n) {
        this.halfExtents = vector3f;
        this.axis = n;
        this.createShape();
    }

    public final Vector3f getHalfExtents() {
        return this.halfExtents;
    }

    public int getAxis() {
        return this.axis;
    }

    @Override
    public void write(JmeExporter jmeExporter) throws IOException {
        super.write(jmeExporter);
        OutputCapsule outputCapsule = jmeExporter.getCapsule((Savable)this);
        outputCapsule.write((Savable)this.halfExtents, "halfExtents", (Savable)new Vector3f(0.5f, 0.5f, 0.5f));
        outputCapsule.write(this.axis, "axis", 1);
    }

    @Override
    public void read(JmeImporter jmeImporter) throws IOException {
        super.read(jmeImporter);
        InputCapsule inputCapsule = jmeImporter.getCapsule((Savable)this);
        this.halfExtents = (Vector3f)inputCapsule.readSavable("halfExtents", (Savable)new Vector3f(0.5f, 0.5f, 0.5f));
        this.axis = inputCapsule.readInt("axis", 1);
        this.createShape();
    }

    protected void createShape() {
        this.objectId = this.createShape(this.axis, this.halfExtents);
        Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Created Shape {0}", Long.toHexString(this.objectId));
        this.setScale(this.scale);
        this.setMargin(this.margin);
    }

    private native long createShape(int var1, Vector3f var2);
}

